/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.sender.tcp;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.common.EventInfo;
import org.apache.inlong.sdk.dataproxy.exception.ProxyEventException;

public class TcpEventInfo
extends EventInfo<byte[]> {
    public TcpEventInfo(String groupId, String streamId, long dtMs, Map<String, String> attrs, byte[] body) throws ProxyEventException {
        super(groupId, streamId, dtMs, null, null, attrs, true, Collections.singletonList(body));
    }

    public TcpEventInfo(String groupId, String streamId, long dtMs, long auditId, Map<String, String> attrs, byte[] body) throws ProxyEventException {
        super(groupId, streamId, dtMs, auditId, null, attrs, true, Collections.singletonList(body));
    }

    public TcpEventInfo(String groupId, String streamId, long dtMs, String msgUUID, Map<String, String> attrs, byte[] body) throws ProxyEventException {
        super(groupId, streamId, dtMs, null, msgUUID, attrs, true, Collections.singletonList(body));
    }

    public TcpEventInfo(String groupId, String streamId, long dtMs, long auditId, String msgUUID, Map<String, String> attrs, byte[] body) throws ProxyEventException {
        super(groupId, streamId, dtMs, auditId, msgUUID, attrs, true, Collections.singletonList(body));
    }

    public TcpEventInfo(String groupId, String streamId, long dtMs, Map<String, String> attrs, List<byte[]> bodyList) throws ProxyEventException {
        super(groupId, streamId, dtMs, null, null, attrs, false, bodyList);
    }

    public TcpEventInfo(String groupId, String streamId, long dtMs, long auditId, Map<String, String> attrs, List<byte[]> bodyList) throws ProxyEventException {
        super(groupId, streamId, dtMs, auditId, null, attrs, false, bodyList);
    }

    public TcpEventInfo(String groupId, String streamId, long dtMs, String msgUUID, Map<String, String> attrs, List<byte[]> bodyList) throws ProxyEventException {
        super(groupId, streamId, dtMs, null, msgUUID, attrs, false, bodyList);
    }

    public TcpEventInfo(String groupId, String streamId, long dtMs, long auditId, String msgUUID, Map<String, String> attrs, List<byte[]> bodyList) throws ProxyEventException {
        super(groupId, streamId, dtMs, auditId, msgUUID, attrs, false, bodyList);
    }

    public List<byte[]> getBodyList() {
        return this.bodyList;
    }

    public void setAttr(String key, String value) throws ProxyEventException {
        if (StringUtils.isBlank(key)) {
            throw new ProxyEventException("Parameter key is blank!");
        }
        if (value == null) {
            throw new ProxyEventException("Parameter value is null!");
        }
        this.innSetAttr(key.trim(), value.trim());
    }

    @Override
    protected void setBodyList(boolean isSingle, List<byte[]> bodyList) throws ProxyEventException {
        if (isSingle) {
            if (bodyList.get(0) == null || bodyList.get(0).length == 0) {
                throw new ProxyEventException("body is null or empty!");
            }
            this.bodyList.add(bodyList.get(0));
            this.bodySize = bodyList.get(0).length;
            this.msgCnt = 1;
        } else {
            if (bodyList == null || bodyList.isEmpty()) {
                throw new ProxyEventException("bodyList is null or empty!");
            }
            for (byte[] body : bodyList) {
                if (body == null || body.length == 0) continue;
                this.bodyList.add(body);
                this.bodySize += body.length;
                ++this.msgCnt;
            }
            if (this.bodyList.isEmpty()) {
                throw new ProxyEventException("bodyList no valid content!");
            }
        }
    }
}

