/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.metric;

import java.util.Objects;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricConfig {
    private static final Logger logger = LoggerFactory.getLogger(MetricConfig.class);
    private static final long DEF_METRIC_OUTPUT_INTVL_MS = 60000L;
    private static final long MIN_METRIC_OUTPUT_INTVL_MS = 10000L;
    private static final long DEF_METRIC_OUTPUT_WARN_INT_MS = 10000L;
    private static final long DEF_METRIC_DATE_FORMAT_MS = 60000L;
    private static final String DEF_METRIC_REPORT_GROUP_ID = "inlong_sla_metric";
    private boolean enableMetric = true;
    private boolean maskGroupId = false;
    private boolean maskStreamId = false;
    private long metricOutIntvlMs = 60000L;
    private long metricOutWarnIntMs = 10000L;
    private long dateFormatIntvlMs = 60000L;
    private String metricGroupId = "inlong_sla_metric";

    public void setEnableMetric(boolean enableMetric) {
        this.enableMetric = enableMetric;
    }

    public boolean isEnableMetric() {
        return this.enableMetric;
    }

    public void setMetricKeyMaskInfos(boolean maskGroupId, boolean maskStreamId) {
        this.maskGroupId = maskGroupId;
        this.maskStreamId = maskStreamId;
    }

    public boolean isMaskGroupId() {
        return this.maskGroupId;
    }

    public boolean isMaskStreamId() {
        return this.maskStreamId;
    }

    public void setMetricOutIntvlInfo(Long metricOutIntvlMs, Long metricOutWarnIntMs) {
        if (metricOutIntvlMs != null && metricOutIntvlMs >= 10000L) {
            this.metricOutIntvlMs = metricOutIntvlMs;
        }
        if (metricOutWarnIntMs != null && metricOutWarnIntMs >= 10000L) {
            this.metricOutWarnIntMs = metricOutWarnIntMs;
        }
    }

    public long getMetricOutIntvlMs() {
        return this.metricOutIntvlMs;
    }

    public long getMetricOutWarnIntMs() {
        return this.metricOutWarnIntMs;
    }

    public long getDateFormatIntvlMs() {
        return this.dateFormatIntvlMs;
    }

    public String getMetricGroupId() {
        return this.metricGroupId;
    }

    public void setMetricGroupId(String metricGroupId) {
        if (StringUtils.isNotBlank(metricGroupId)) {
            this.metricGroupId = metricGroupId.trim();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricConfig that = (MetricConfig)o;
        return this.enableMetric == that.enableMetric && this.maskGroupId == that.maskGroupId && this.maskStreamId == that.maskStreamId && this.metricOutIntvlMs == that.metricOutIntvlMs && this.metricOutWarnIntMs == that.metricOutWarnIntMs && this.dateFormatIntvlMs == that.dateFormatIntvlMs && Objects.equals(this.metricGroupId, that.metricGroupId);
    }

    public int hashCode() {
        return Objects.hash(this.enableMetric, this.maskGroupId, this.maskStreamId, this.metricOutIntvlMs, this.dateFormatIntvlMs, this.metricOutWarnIntMs, this.metricGroupId);
    }

    public MetricConfig clone() {
        try {
            return (MetricConfig)super.clone();
        }
        catch (Throwable ex) {
            logger.warn("Failed to clone MetricConfig", ex);
            return null;
        }
    }

    public void getSetting(StringBuilder strBuff) {
        strBuff.append("{enableMetric=").append(this.enableMetric).append(", maskGroupId=").append(this.maskGroupId).append(", maskStreamId=").append(this.maskStreamId).append(", metricRptIntvlMs=").append(this.metricOutIntvlMs).append(", metricOutWarnIntMs=").append(this.metricOutWarnIntMs).append(", dateFormatIntvlMs=").append(this.dateFormatIntvlMs).append(", metricGroupId='").append(this.metricGroupId).append("'}");
    }
}

