/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;

public class Preconditions {
    public static void expectNotNull(Object obj, String errMsg) {
        Preconditions.expectTrue(obj != null, errMsg);
    }

    public static void expectNotNull(Object obj, Supplier<String> errMsg) {
        Preconditions.expectTrue(obj != null, errMsg);
    }

    public static void expectNull(Object obj, String errMsg) {
        Preconditions.expectTrue(obj == null, errMsg);
    }

    public static void expectNull(Object obj, Supplier<String> errMsg) {
        Preconditions.expectTrue(obj == null, errMsg);
    }

    public static void expectEmpty(String str, String errMsg) {
        Preconditions.expectTrue(str == null || str.isEmpty(), errMsg);
    }

    public static void expectEmpty(String str, Supplier<String> errMsg) {
        Preconditions.expectTrue(str == null || str.isEmpty(), errMsg);
    }

    public static void expectEmpty(Collection<?> str, String errMsg) {
        Preconditions.expectTrue(str == null || str.isEmpty(), errMsg);
    }

    public static void expectEmpty(Collection<?> collection, Supplier<String> errMsg) {
        Preconditions.expectTrue(collection == null || collection.isEmpty(), errMsg);
    }

    public static void expectEmpty(Map<?, ?> map, String errMsg) {
        Preconditions.expectTrue(map == null || map.isEmpty(), errMsg);
    }

    public static void expectEmpty(Map<?, ?> map, Supplier<String> errMsg) {
        Preconditions.expectTrue(map == null || map.isEmpty(), errMsg);
    }

    public static void expectNotEmpty(String str, String errMsg) {
        Preconditions.expectTrue(str != null && !str.isEmpty(), errMsg);
    }

    public static void expectNotEmpty(String str, Supplier<String> errMsg) {
        Preconditions.expectTrue(str != null && !str.isEmpty(), errMsg);
    }

    public static void expectNotEmpty(Collection<?> collection, String errMsg) {
        Preconditions.expectTrue(collection != null && !collection.isEmpty(), errMsg);
    }

    public static void expectNotEmpty(Collection<?> collection, Supplier<String> errMsg) {
        Preconditions.expectTrue(collection != null && !collection.isEmpty(), errMsg);
    }

    public static void expectNotEmpty(String[] collection, String errMsg) {
        Preconditions.expectTrue(collection != null && collection.length != 0, errMsg);
    }

    public static void expectNotEmpty(String[] collection, Supplier<String> errMsg) {
        Preconditions.expectTrue(collection != null && collection.length != 0, errMsg);
    }

    public static void expectNotEmpty(Map<?, ?> map, String errMsg) {
        Preconditions.expectTrue(map != null && !map.isEmpty(), errMsg);
    }

    public static void expectNotEmpty(Map<?, ?> map, Supplier<String> errMsg) {
        Preconditions.expectTrue(map != null && !map.isEmpty(), errMsg);
    }

    public static void expectNoNullElements(Object[] array, String errMsg) {
        if (array != null) {
            for (Object o : array) {
                if (o != null) continue;
                throw new IllegalArgumentException(errMsg);
            }
        }
    }

    public static void expectFalse(boolean condition, String errMsg) {
        Preconditions.expectTrue(!condition, errMsg);
    }

    public static void expectFalse(boolean condition, Supplier<String> errMsg) {
        Preconditions.expectTrue(!condition, errMsg);
    }

    public static void expectTrue(boolean condition, Supplier<String> errMsg) {
        if (!condition) {
            throw new IllegalArgumentException(errMsg.get());
        }
    }

    public static void expectTrue(boolean condition, String errMsg) {
        if (!condition) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    public static void expectNotBlank(String obj, String errMsg) {
        if (StringUtils.isBlank((CharSequence)obj)) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    public static void expectNotBlank(String obj, ErrorCodeEnum errorCodeEnum) {
        if (StringUtils.isBlank((CharSequence)obj)) {
            throw new BusinessException(errorCodeEnum);
        }
    }

    public static void expectNotBlank(String obj, ErrorCodeEnum errorCodeEnum, String errMsg) {
        if (StringUtils.isBlank((CharSequence)obj)) {
            throw new BusinessException(errorCodeEnum, errMsg);
        }
    }

    public static void expectEmpty(List<String> obj, ErrorCodeEnum errorCodeEnum, String errMsg) {
        if (CollectionUtils.isNotEmpty(obj)) {
            throw new BusinessException(errorCodeEnum, errMsg);
        }
    }

    public static void expectNotNull(Object obj, ErrorCodeEnum errorCodeEnum) {
        if (obj == null) {
            throw new BusinessException(errorCodeEnum);
        }
    }

    public static void expectNotNull(Object obj, ErrorCodeEnum errorCodeEnum, String errMsg) {
        if (obj == null) {
            throw new BusinessException(errorCodeEnum, errMsg);
        }
    }

    public static void expectEquals(Object a, Object b, ErrorCodeEnum errorCodeEnum) {
        if (!Objects.equals(a, b)) {
            throw new BusinessException(errorCodeEnum);
        }
    }

    public static void expectEquals(Object a, Object b, ErrorCodeEnum errorCodeEnum, String errMsg) {
        if (!Objects.equals(a, b)) {
            throw new BusinessException(errorCodeEnum, errMsg);
        }
    }

    public static boolean inSeparatedString(String target, String separatedStr, String separator) {
        if (StringUtils.isBlank((CharSequence)target) || StringUtils.isBlank((CharSequence)separatedStr)) {
            return false;
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(separatedStr.split(separator)));
        return set.contains(target);
    }
}

