/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SortStatus {
    NOT_EXISTS(40, "job not exists"),
    NEW(100, "job not started: draft, pending, etc."),
    RUNNING(110, "job is running"),
    PAUSED(120, "job was paused"),
    STOPPED(130, "job stopped without error, e.g canceled"),
    FAILED(140, "job failed with an error"),
    FINISHED(200, "job finished successfully"),
    OPERATING(300, "job in an intermediate status such as restarting, canceling, etc."),
    UNKNOWN(400, "job status unknown");

    @JsonValue
    private final Integer code;
    private final String description;

    private SortStatus(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonCreator
    public static SortStatus forCode(int code) {
        for (SortStatus status : SortStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalStateException(String.format("Illegal code=%s for SortStatus", code));
    }
}

