/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

public enum ScheduleStatus {
    NEW(100, "new"),
    APPROVED(101, "approved"),
    REGISTERED(102, "registered"),
    UPDATED(103, "updated"),
    DELETED(99, "deleted");

    private final Integer code;
    private final String description;

    private ScheduleStatus(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static ScheduleStatus forCode(int code) {
        for (ScheduleStatus status : ScheduleStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalStateException(String.format("Illegal code=%s for ScheduleStatus", code));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

