/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.compressor.gzip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtil {
    private static final int BUFFER_SIZE = 8192;

    private GzipUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
            gzip.write(bytes);
            gzip.flush();
            gzip.finish();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("gzip compress error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompress(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPInputStream gunzip = new GZIPInputStream(new ByteArrayInputStream(bytes));){
            int n;
            byte[] buffer = new byte[8192];
            while ((n = gunzip.read(buffer)) > -1) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("gzip decompress error", e);
        }
    }
}

