/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.metrics.exporter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.metrics.exporter.Exporter;
import org.apache.seata.metrics.exporter.ExporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExporterFactory.class);

    public static List<Exporter> getInstanceList() {
        ArrayList<Exporter> exporters = new ArrayList<Exporter>();
        String exporterTypeNameList = ConfigurationFactory.getInstance().getConfig("metrics.exporterList", "prometheus");
        if (!StringUtils.isNullOrEmpty((String)exporterTypeNameList)) {
            String[] exporterTypeNames;
            for (String exporterTypeName : exporterTypeNames = exporterTypeNameList.split(",")) {
                try {
                    ExporterType exporterType = ExporterType.getType(exporterTypeName);
                    exporters.add((Exporter)EnhancedServiceLoader.load(Exporter.class, (String)Objects.requireNonNull(exporterType).getName()));
                }
                catch (Exception exx) {
                    LOGGER.error("not support metrics exporter type: {}", (Object)exporterTypeName, (Object)exx);
                }
            }
        }
        return exporters;
    }
}

