/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.server.console.impl.AbstractService;
import org.apache.seata.server.coordinator.DefaultCoordinator;
import org.apache.seata.server.lock.LockManager;
import org.apache.seata.server.lock.LockerManagerFactory;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractService.class);
    protected final LockManager lockManager = LockerManagerFactory.getLockManager();
    protected static final List<GlobalStatus> RETRY_COMMIT_STATUS = Arrays.asList(GlobalStatus.CommitRetrying);
    protected static final List<GlobalStatus> RETRY_ROLLBACK_STATUS = Arrays.asList(GlobalStatus.RollbackRetrying, GlobalStatus.TimeoutRollbackRetrying, GlobalStatus.TimeoutRollbacking);
    protected static final List<GlobalStatus> COMMIT_ING_STATUS = Stream.concat(RETRY_COMMIT_STATUS.stream(), Collections.singletonList(GlobalStatus.Committing).stream()).collect(Collectors.toList());
    protected static final List<GlobalStatus> ROLLBACK_ING_STATUS = Stream.concat(RETRY_ROLLBACK_STATUS.stream(), Collections.singletonList(GlobalStatus.Rollbacking).stream()).collect(Collectors.toList());
    protected static final List<GlobalStatus> RETRY_STATUS = Stream.concat(RETRY_COMMIT_STATUS.stream(), RETRY_ROLLBACK_STATUS.stream()).collect(Collectors.toList());
    protected static final List<GlobalStatus> FAIL_COMMIT_STATUS = Arrays.asList(GlobalStatus.CommitFailed, GlobalStatus.CommitRetryTimeout);
    protected static final List<GlobalStatus> FAIL_ROLLBACK_STATUS = Arrays.asList(GlobalStatus.TimeoutRollbacked, GlobalStatus.RollbackFailed, GlobalStatus.RollbackRetryTimeout);
    protected static final List<GlobalStatus> FAIL_STATUS = Stream.concat(FAIL_COMMIT_STATUS.stream(), FAIL_ROLLBACK_STATUS.stream()).collect(Collectors.toList());
    protected static final List<GlobalStatus> FINISH_STATUS = Arrays.asList(GlobalStatus.Committed, GlobalStatus.Finished, GlobalStatus.Rollbacked);

    protected void commonCheck(String xid, String branchId) {
        if (StringUtils.isBlank((String)xid)) {
            throw new IllegalArgumentException("Wrong parameter for xid");
        }
        if (StringUtils.isBlank((String)branchId)) {
            throw new IllegalArgumentException("Wrong parameter for branchId");
        }
        try {
            Long.parseLong(branchId);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wrong parameter for branchId, branch Id is not number");
        }
    }

    protected GlobalSession checkGlobalSession(String xid) {
        if (StringUtils.isBlank((String)xid)) {
            throw new IllegalArgumentException("Wrong parameter for xid");
        }
        GlobalSession globalSession = SessionHolder.findGlobalSession((String)xid);
        if (Objects.isNull(globalSession)) {
            throw new IllegalArgumentException("Global session is not exist, may be finished");
        }
        return globalSession;
    }

    protected CheckResult commonCheckAndGetGlobalStatus(String xid, String branchId) {
        this.commonCheck(xid, branchId);
        GlobalSession globalSession = SessionHolder.findGlobalSession((String)xid);
        if (Objects.isNull(globalSession)) {
            throw new IllegalArgumentException("global session is not exist, may be finished");
        }
        List branchSessions = globalSession.getBranchSessions();
        Long paramBranchId = Long.valueOf(branchId);
        BranchSession branchSession = branchSessions.stream().filter(session -> paramBranchId.equals(session.getBranchId())).findAny().orElseThrow(() -> new IllegalArgumentException("branch session is not exist, may be finished"));
        return new CheckResult(globalSession, branchSession);
    }

    protected boolean doDeleteBranch(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Branch delete start, xid:{} branchId:{} branchType:{}", new Object[]{branchSession.getXid(), branchSession.getBranchId(), branchSession.getBranchType()});
        }
        if (branchSession.getStatus() == BranchStatus.PhaseOne_Failed) {
            globalSession.removeBranch(branchSession);
            return true;
        }
        boolean result = DefaultCoordinator.getInstance().doBranchDelete(globalSession, branchSession);
        if (result && (result = branchSession.unlock())) {
            globalSession.removeBranch(branchSession);
            return true;
        }
        return false;
    }

    protected boolean doForceDeleteBranch(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Branch force delete start, xid:{} branchId:{} branchType:{}", new Object[]{branchSession.getXid(), branchSession.getBranchId(), branchSession.getBranchType()});
        }
        globalSession.removeBranch(branchSession);
        return true;
    }

    protected boolean doRetryCommitGlobal(GlobalSession globalSession) throws TransactionException {
        return DefaultCoordinator.getInstance().doGlobalCommit(globalSession, true);
    }

    protected boolean doRetryRollbackGlobal(GlobalSession globalSession) throws TransactionException {
        return DefaultCoordinator.getInstance().doGlobalRollback(globalSession, true);
    }
}

