/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.core.protocol.IncompatibleVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version.class);
    private static final String CURRENT = "2.5.0";
    private static final String VERSION_0_7_1 = "0.7.1";
    private static final String VERSION_1_5_0 = "1.5.0";
    private static final String VERSION_2_3_0 = "2.3.0";
    private static final int MAX_VERSION_DOT = 3;
    public static final Map<String, String> VERSION_MAP = new ConcurrentHashMap<String, String>();

    private Version() {
    }

    public static String getCurrent() {
        return CURRENT;
    }

    public static void putChannelVersion(Channel c, String v) {
        VERSION_MAP.put(NetUtil.toStringAddress((SocketAddress)c.remoteAddress()), v);
    }

    public static String getChannelVersion(Channel c) {
        return VERSION_MAP.get(NetUtil.toStringAddress((SocketAddress)c.remoteAddress()));
    }

    public static boolean isAboveOrEqualVersion150(String version) {
        return Version.isAboveOrEqualVersion(version, VERSION_1_5_0);
    }

    public static boolean isAboveOrEqualVersion230(String version) {
        return Version.isAboveOrEqualVersion(version, VERSION_2_3_0);
    }

    public static boolean isV0(String version) {
        return !Version.isAboveOrEqualVersion(version, VERSION_0_7_1);
    }

    public static boolean isAboveOrEqualVersion(String clientVersion, String divideVersion) {
        boolean isAboveOrEqualVersion = false;
        try {
            isAboveOrEqualVersion = Version.convertVersion(clientVersion) >= Version.convertVersion(divideVersion);
        }
        catch (Exception e) {
            LOGGER.error("convert version error, clientVersion:{}", (Object)clientVersion, (Object)e);
        }
        return isAboveOrEqualVersion;
    }

    public static long convertVersion(String version) throws IncompatibleVersionException {
        if (StringUtils.isBlank((String)version)) {
            throw new IllegalArgumentException("The version must not be blank.");
        }
        String[] parts = StringUtils.split((String)version, (char)'.');
        int size = parts.length;
        if (size > 4) {
            throw new IncompatibleVersionException("incompatible version format:" + version);
        }
        long result = 0L;
        int i = 1;
        size = 4;
        for (String part : parts) {
            if (StringUtils.isNumeric((String)part)) {
                result += Version.calculatePartValue(part, size, i);
            } else {
                String[] subParts = StringUtils.split((String)part, (char)'-');
                if (StringUtils.isNumeric((String)subParts[0])) {
                    result += Version.calculatePartValue(subParts[0], size, i);
                }
            }
            ++i;
        }
        return result;
    }

    public static long convertVersionNotThrowException(String version) {
        try {
            return Version.convertVersion(version);
        }
        catch (Exception e) {
            LOGGER.error("convert version error,version:{}", (Object)version, (Object)e);
            return -1L;
        }
    }

    public static byte calcProtocolVersion(String sdkVersion) throws IncompatibleVersionException {
        long v0;
        long version = Version.convertVersion(sdkVersion);
        if (version <= (v0 = Version.convertVersion(VERSION_0_7_1))) {
            return 0;
        }
        return 1;
    }

    private static long calculatePartValue(String partNumeric, int size, int index) {
        return Long.parseLong(partNumeric) * Double.valueOf(Math.pow(100.0, size - index)).longValue();
    }
}

