/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.enums;

import com.ctrip.framework.apollo.core.utils.StringUtils;
import java.util.stream.Stream;

public enum ConfigFileFormat {
    Properties("properties"),
    XML("xml"),
    JSON("json"),
    YML("yml"),
    YAML("yaml"),
    TXT("txt");

    private final String value;

    private ConfigFileFormat(String value) {
        this.value = value;
    }

    private static String getWellFormedName(String configFileName) {
        if (StringUtils.isBlank(configFileName)) {
            return "";
        }
        return configFileName.trim().toLowerCase();
    }

    public static ConfigFileFormat fromString(String value) {
        if (StringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("value can not be empty");
        }
        String cleansedName = ConfigFileFormat.getWellFormedName(value);
        return Stream.of(ConfigFileFormat.values()).filter(item -> cleansedName.equalsIgnoreCase(item.getValue())).findFirst().orElseThrow(() -> new IllegalArgumentException(value + " can not map enum"));
    }

    public static boolean isValidFormat(String value) {
        try {
            ConfigFileFormat.fromString(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isPropertiesCompatible(ConfigFileFormat format) {
        return format == YAML || format == YML || format == Properties;
    }

    public String getValue() {
        return this.value;
    }
}

