/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.Joinable;

public abstract class AbstractRowSet
implements Serializable,
Joinable {
    private String m_url;
    private String m_dataSourceName;
    protected String m_userName;
    protected String m_password;
    private String m_command;
    private int m_transationIsolation;
    private boolean m_readOnly;
    private int m_maxFieldSize;
    private int m_maxRows;
    private int m_queryTimeout;
    private int m_rowSetType;
    private int m_resultConcurrencyType;
    private boolean m_process_escapes;
    private int m_direction;
    private int m_fetchSize;
    protected Vector m_listeners;
    protected RowSetEvent m_rowsetEvent;
    protected boolean m_showDeleted;
    private Vector m_matchColIndexes;
    private Vector m_matchColNames;
    private Map m_typeMap = null;

    private void initializeProps() {
        this.m_process_escapes = true;
        this.m_showDeleted = false;
        this.m_rowSetType = 1004;
        this.m_direction = 1000;
        this.m_readOnly = false;
        this.m_maxFieldSize = 0;
        this.m_maxRows = 0;
        this.m_fetchSize = 0;
        this.m_queryTimeout = 0;
        this.m_url = "";
        this.m_userName = "";
        this.m_password = "";
        this.m_command = "";
        this.m_resultConcurrencyType = 1008;
        this.m_transationIsolation = 2;
    }

    protected AbstractRowSet() {
        this.initializeProps();
        this.m_listeners = new Vector();
        this.m_rowsetEvent = new RowSetEvent((RowSet)((Object)this));
        this.m_matchColIndexes = new Vector(10);
        this.m_matchColNames = new Vector(10);
    }

    protected final void notifyRowSetChanged() {
        int n2 = this.m_listeners.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.m_listeners.elementAt(n3)).rowSetChanged(this.m_rowsetEvent);
                ++n3;
            }
        }
    }

    protected final void notifyCursorMovement() {
        int n2 = this.m_listeners.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.m_listeners.elementAt(n3)).cursorMoved(this.m_rowsetEvent);
                ++n3;
            }
        }
    }

    protected final void notifyRowChanged() {
        int n2 = this.m_listeners.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.m_listeners.elementAt(n3)).rowChanged(this.m_rowsetEvent);
                ++n3;
            }
        }
    }

    protected final void notifyUpdateListeners() {
        int n2 = this.m_listeners.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                ((RowSetListener)this.m_listeners.elementAt(n3)).rowChanged(this.m_rowsetEvent);
                ++n3;
            }
        }
    }

    private void unsetColIndexIfSet(int n2) {
        int n3 = this.m_matchColIndexes.size();
        int[] nArray = new int[n3];
        int n4 = 0;
        if (n2 <= 0) {
            DBError.ECJDBC_COLINDEX_SMALLER_ONE.throwz(new Object[0]);
        }
        int n5 = 0;
        while (n5 < n3) {
            if (((Integer)this.m_matchColIndexes.get(n5)).equals(n2)) {
                nArray[n4] = n5;
                ++n4;
            }
            ++n5;
        }
        if (n4 == 0) {
            DBError.ECJDBC_COLINDEX_UNSET.throwz(new Object[0]);
        }
        n5 = n4 - 1;
        while (n5 >= 0) {
            this.m_matchColIndexes.remove(nArray[n5]);
            --n5;
        }
    }

    private void unsetColNameIfSet(String string) {
        int n2 = this.m_matchColNames.size();
        int[] nArray = new int[n2];
        int n3 = 0;
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_COLNAME_EMPTY.throwz(new Object[0]);
        }
        int n4 = 0;
        while (n4 < n2) {
            if (((String)this.m_matchColNames.get(n4)).equalsIgnoreCase(string)) {
                nArray[n4] = n4;
                ++n3;
            }
            ++n4;
        }
        if (n3 == 0) {
            DBError.ECJDBC_COLINDEX_UNSET.throwz(new Object[0]);
        }
        n4 = n3 - 1;
        while (n4 >= 0) {
            this.m_matchColNames.remove(nArray[n4]);
            --n4;
        }
    }

    @Override
    public void setMatchColumn(int n2) {
        if (n2 <= 0) {
            DBError.ECJDBC_COLINDEX_SMALLER_ONE.throwz(new Object[0]);
        }
        this.m_matchColIndexes.clear();
        this.m_matchColNames.clear();
        this.m_matchColIndexes.add(n2);
    }

    @Override
    public void setMatchColumn(int[] nArray) {
        if (nArray == null) {
            DBError.ECJDBC_COLINDEXES_NULL.throwz(new Object[0]);
            return;
        }
        this.m_matchColIndexes.clear();
        this.m_matchColNames.clear();
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (n4 <= 0) {
                DBError.ECJDBC_COLINDEX_SMALLER_ONE.throwz(new Object[0]);
            }
            this.m_matchColIndexes.add(n4);
            ++n3;
        }
    }

    @Override
    public void setMatchColumn(String string) {
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_COLNAME_EMPTY.throwz(new Object[0]);
        }
        this.m_matchColIndexes.clear();
        this.m_matchColNames.clear();
        this.m_matchColNames.add(string);
    }

    @Override
    public void setMatchColumn(String[] stringArray) {
        if (stringArray == null) {
            DBError.ECJDBC_COLNAMES_NULL.throwz(new Object[0]);
            return;
        }
        this.m_matchColIndexes.clear();
        this.m_matchColNames.clear();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            if (StringUtil.isEmpty(string)) {
                DBError.ECJDBC_COLNAME_EMPTY.throwz(new Object[0]);
            }
            this.m_matchColNames.add(string);
            ++n3;
        }
    }

    public abstract int findColumn(String var1);

    @Override
    public int[] getMatchColumnIndexes() {
        int[] nArray;
        if (this.m_matchColIndexes.isEmpty() && this.m_matchColNames.isEmpty()) {
            DBError.ECJDBC_NOCOLUMNS_SET.throwz(new Object[0]);
        }
        if (!this.m_matchColIndexes.isEmpty()) {
            int n2 = this.m_matchColIndexes.size();
            nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = (Integer)this.m_matchColIndexes.get(n3);
                ++n3;
            }
        } else {
            int n4 = this.m_matchColNames.size();
            nArray = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                nArray[n5] = this.findColumn((String)this.m_matchColNames.get(n5));
                ++n5;
            }
        }
        return nArray;
    }

    @Override
    public String[] getMatchColumnNames() {
        if (this.m_matchColNames.isEmpty()) {
            DBError.ECJDBC_NOCOLNAMES_SET.throwz(new Object[0]);
        }
        int n2 = this.m_matchColNames.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (String)this.m_matchColNames.get(n3);
            ++n3;
        }
        return stringArray;
    }

    @Override
    public void unsetMatchColumn(int n2) {
        if (this.m_matchColIndexes.isEmpty()) {
            DBError.ECJDBC_NOCOLINDEXES_SET.throwz(new Object[0]);
        }
        this.unsetColIndexIfSet(n2);
    }

    @Override
    public void unsetMatchColumn(int[] nArray) {
        if (this.m_matchColIndexes.isEmpty()) {
            DBError.ECJDBC_NOCOLINDEXES_SET.throwz(new Object[0]);
        }
        if (nArray == null) {
            DBError.ECJDBC_COLINDEXES_NULL.throwz(new Object[0]);
            return;
        }
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            this.unsetColIndexIfSet(n4);
            ++n3;
        }
    }

    @Override
    public void unsetMatchColumn(String string) {
        if (this.m_matchColNames.isEmpty()) {
            DBError.ECJDBC_NOCOLNAMES_SET.throwz(new Object[0]);
        }
        this.unsetColNameIfSet(string);
    }

    @Override
    public void unsetMatchColumn(String[] stringArray) {
        if (this.m_matchColNames.isEmpty()) {
            DBError.ECJDBC_NOCOLNAMES_SET.throwz(new Object[0]);
        }
        if (stringArray == null) {
            DBError.ECJDBC_COLNAMES_NULL.throwz(new Object[0]);
            return;
        }
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            this.unsetColNameIfSet(string);
            ++n3;
        }
    }

    public void setFetchDirection(int n2) {
        this.m_direction = n2;
    }

    public int getFetchDirection() {
        return this.m_direction;
    }

    public void setFetchSize(int n2) {
        this.m_fetchSize = n2;
    }

    public int getFetchSize() {
        return this.m_fetchSize;
    }

    public int getType() {
        return this.m_rowSetType;
    }

    public int getConcurrency() {
        return this.m_resultConcurrencyType;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String string) {
        this.m_url = string;
    }

    public String getDataSourceName() {
        return this.m_dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.m_dataSourceName = string;
    }

    public String getUsername() {
        return this.m_userName;
    }

    public void setUsername(String string) {
        this.m_userName = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public int getTransactionIsolation() {
        return this.m_transationIsolation;
    }

    public void setTransactionIsolation(int n2) {
        this.m_transationIsolation = n2;
    }

    public Map getTypeMap() {
        return this.m_typeMap;
    }

    public void setTypeMap(Map map) {
        this.m_typeMap = map;
    }

    public String getCommand() {
        return this.m_command;
    }

    public void setCommand(String string) {
        this.m_command = string;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.m_readOnly = bl;
    }

    public int getMaxFieldSize() {
        return this.m_maxFieldSize;
    }

    public void setMaxFieldSize(int n2) {
        this.m_maxFieldSize = n2;
    }

    public int getMaxRows() {
        return this.m_maxRows;
    }

    public void setMaxRows(int n2) {
        this.m_maxRows = n2;
    }

    public boolean getEscapeProcessing() {
        return this.m_process_escapes;
    }

    public void setEscapeProcessing(boolean bl) {
        this.m_process_escapes = bl;
    }

    public int getQueryTimeout() {
        return this.m_queryTimeout;
    }

    public void setQueryTimeout(int n2) {
        this.m_queryTimeout = n2;
    }

    public boolean getShowDeleted() {
        return this.m_showDeleted;
    }

    public void setShowDeleted(boolean bl) {
        this.m_showDeleted = bl;
    }

    public void setType(int n2) {
        this.m_rowSetType = n2;
    }

    public void setConcurrency(int n2) {
        this.m_resultConcurrencyType = n2;
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        int n2 = 0;
        while (n2 < this.m_listeners.size()) {
            if (((RowSetListener)this.m_listeners.get(n2)).equals(rowSetListener)) {
                return;
            }
            ++n2;
        }
        this.m_listeners.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        int n2 = 0;
        while (n2 < this.m_listeners.size()) {
            if (((RowSetListener)this.m_listeners.get(n2)).equals(rowSetListener)) {
                this.m_listeners.remove(n2);
            }
            ++n2;
        }
    }
}

