/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.sql;

import org.apache.ignite3.internal.catalog.sql.QueryPart;

class QueryContext {
    private static final int INDENT = 2;
    private final StringBuilder sql = new StringBuilder();
    private int indent;
    private boolean newline = false;

    QueryContext() {
    }

    QueryContext visit(QueryPart part) {
        part.accept(this);
        return this;
    }

    String getSql() {
        return this.sql.toString();
    }

    QueryContext sql(char c) {
        this.applyNewLine();
        this.sql.append(c);
        this.resetSeparatorFlags();
        return this;
    }

    QueryContext sql(String s) {
        this.applyNewLine();
        this.sql.append(s);
        this.resetSeparatorFlags();
        return this;
    }

    QueryContext sql(int i) {
        this.applyNewLine();
        this.sql.append(i);
        this.resetSeparatorFlags();
        return this;
    }

    QueryContext sql(double d) {
        this.applyNewLine();
        this.sql.append(d);
        this.resetSeparatorFlags();
        return this;
    }

    QueryContext formatSeparator() {
        this.newline = true;
        return this;
    }

    boolean isQuoteNames() {
        return false;
    }

    QueryContext sqlIndentStart(String s) {
        return this.sql(s).sqlIndentStart();
    }

    private QueryContext sqlIndentStart() {
        this.indent += 2;
        return this;
    }

    private String indentation() {
        return this.indent == 0 ? "" : " ".repeat(this.indent);
    }

    private void applyNewLine() {
        if (this.newline) {
            this.sql.append(System.lineSeparator());
        }
    }

    private void resetSeparatorFlags() {
        this.newline = false;
    }
}

