/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Collection;
import java.util.Iterator;
import org.apache.ignite.internal.util.GridSerializableCollection;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;

public class TransformCollectionView<T1, T2>
extends GridSerializableCollection<T1> {
    private static final long serialVersionUID = 0L;
    private final Collection<? extends T2> col;
    private final IgniteClosure<? super T2, T1> clos;
    private final IgnitePredicate<? super T2>[] preds;

    @SafeVarargs
    public TransformCollectionView(Collection<? extends T2> col, IgniteClosure<? super T2, T1> clos, IgnitePredicate<? super T2> ... preds) {
        this.col = col;
        this.clos = clos;
        this.preds = preds;
    }

    @Override
    @NotNull
    public Iterator<T1> iterator() {
        return F.iterator(this.col, this.clos, true, this.preds);
    }

    @Override
    public int size() {
        return F.isEmpty(this.preds) ? this.col.size() : F.size(this.iterator(), new IgnitePredicate[0]);
    }

    @Override
    public boolean isEmpty() {
        return F.isEmpty(this.preds) ? this.col.isEmpty() : !this.iterator().hasNext();
    }
}

