/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.odbc.ClientAsyncResponse;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolVersionFeature;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryNextPageRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheSqlFieldsQueryRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheSqlQueryRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxContext;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityException;

public class ClientRequestHandler
implements ClientListenerRequestHandler {
    public static final long DFLT_ASYNC_REQUEST_WAIT_TIMEOUT_MILLIS = 10L;
    private final long asyncReqWaitTimeout = IgniteSystemProperties.getLong("IGNITE_THIN_CLIENT_ASYNC_REQUESTS_WAIT_TIMEOUT", 10L);
    private final ClientConnectionContext ctx;
    private final ClientProtocolContext protocolCtx;
    private final IgniteLogger log;

    ClientRequestHandler(ClientConnectionContext ctx, ClientProtocolContext protocolCtx) {
        assert (ctx != null);
        this.ctx = ctx;
        this.protocolCtx = protocolCtx;
        this.log = ctx.kernalContext().log(this.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClientListenerResponse handle(ClientListenerRequest req) {
        try {
            if (!(req instanceof ClientTxAwareRequest)) return this.handle0(req);
            ClientTxAwareRequest req0 = (ClientTxAwareRequest)((Object)req);
            if (!req0.isTransactional()) return this.handle0(req);
            int txId = req0.txId();
            ClientTxContext txCtx = this.ctx.txContext(txId);
            if (txCtx == null) return this.handle0(req);
            try {
                txCtx.acquire(true);
                ClientListenerResponse clientListenerResponse = this.handle0(req);
                return clientListenerResponse;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteClientException(1, e.getMessage(), e);
            }
            finally {
                try {
                    txCtx.release(true);
                }
                catch (Exception e) {
                    this.log.warning("Failed to release client transaction context", e);
                }
            }
        }
        catch (SecurityException ex) {
            throw new IgniteClientException(1012, "Client is not authorized to perform this operation", ex);
        }
    }

    private ClientListenerResponse handle0(ClientListenerRequest req) {
        ClientRequest req0 = (ClientRequest)req;
        if (req0.isAsync(this.ctx)) {
            IgniteInternalFuture<ClientResponse> fut = req0.processAsync(this.ctx);
            if (this.asyncReqWaitTimeout <= 0L) {
                return new ClientAsyncResponse(req0.requestId(), fut);
            }
            try {
                return fut.get(this.asyncReqWaitTimeout);
            }
            catch (IgniteFutureTimeoutCheckedException ignored) {
                return new ClientAsyncResponse(req0.requestId(), fut);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteClientException(1, e.getMessage(), e);
            }
        }
        return req0.process(this.ctx);
    }

    @Override
    public ClientListenerResponse handleException(Throwable e, ClientListenerRequest req) {
        assert (req != null);
        assert (e != null);
        int status = this.getStatus(e);
        Object msg = e.getMessage();
        if (req instanceof ClientCacheSqlQueryRequest || req instanceof ClientCacheSqlFieldsQueryRequest || req instanceof ClientCacheQueryNextPageRequest) {
            String sqlState = IgniteQueryErrorCode.codeToSqlState(SqlListenerUtils.exceptionToSqlErrorCode(e));
            msg = sqlState + ": " + (String)msg;
        }
        if (this.ctx.kernalContext().clientListener().sendServerExceptionStackTraceToClient()) {
            msg = (String)msg + U.nl() + X.getFullStackTrace(e);
        }
        return new ClientResponse(req.requestId(), status, (String)msg);
    }

    @Override
    public void writeHandshake(BinaryWriterExImpl writer) {
        writer.writeBoolean(true);
        if (this.protocolCtx.isFeatureSupported(ClientProtocolVersionFeature.BITMAP_FEATURES)) {
            writer.writeByteArray(this.protocolCtx.featureBytes());
        }
        if (this.protocolCtx.isFeatureSupported(ClientProtocolVersionFeature.PARTITION_AWARENESS)) {
            writer.writeUuid(this.ctx.kernalContext().localNodeId());
        }
    }

    @Override
    public boolean isCancellationCommand(int cmdId) {
        return false;
    }

    @Override
    public boolean isCancellationSupported() {
        return false;
    }

    @Override
    public void registerRequest(long reqId, int cmdType) {
    }

    @Override
    public void unregisterRequest(long reqId) {
    }

    @Override
    public ClientListenerProtocolVersion protocolVersion() {
        return this.protocolCtx.version();
    }

    private int getStatus(Throwable e) {
        IllegalStateException ex;
        if (e instanceof IgniteClientException) {
            return ((IgniteClientException)e).statusCode();
        }
        if (e instanceof IgniteIllegalStateException && (ex = (IgniteIllegalStateException)e).getMessage().startsWith("Grid is in invalid state")) {
            return 10;
        }
        if (e instanceof IllegalStateException && (ex = (IllegalStateException)e).getMessage().contains("grid is stopping")) {
            return 10;
        }
        return 1;
    }
}

