/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteStateAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgniteTxRemoteSingleStateImpl
extends IgniteTxRemoteStateAdapter {
    private IgniteTxEntry entry;

    @Override
    public void unwindEvicts(GridCacheSharedContext cctx) {
        if (this.entry == null) {
            return;
        }
        GridCacheContext ctx = cctx.cacheContext(this.entry.cacheId());
        if (ctx != null) {
            CU.unwindEvicts(ctx);
        }
    }

    @Override
    public void addWriteEntry(IgniteTxKey key, IgniteTxEntry e) {
        this.entry = e;
    }

    @Override
    public void clearEntry(IgniteTxKey key) {
        if (this.entry != null && this.entry.txKey().equals(key)) {
            this.entry = null;
        }
    }

    @Override
    public IgniteTxEntry entry(IgniteTxKey key) {
        if (this.entry != null && this.entry.txKey().equals(key)) {
            return this.entry;
        }
        return null;
    }

    @Override
    public boolean hasWriteKey(IgniteTxKey key) {
        return this.entry != null && this.entry.txKey().equals(key);
    }

    @Override
    public Set<IgniteTxKey> readSet() {
        return Collections.emptySet();
    }

    @Override
    public Set<IgniteTxKey> writeSet() {
        return this.entry != null ? Collections.singleton(this.entry.txKey()) : Collections.emptySet();
    }

    @Override
    public Collection<IgniteTxEntry> writeEntries() {
        return this.entry != null ? Collections.singletonList(this.entry) : Collections.emptyList();
    }

    @Override
    public Collection<IgniteTxEntry> readEntries() {
        return Collections.emptyList();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> writeMap() {
        return this.entry != null ? F.asMap(this.entry.txKey(), this.entry) : Collections.emptyMap();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> readMap() {
        return Collections.emptyMap();
    }

    @Override
    public boolean empty() {
        return this.entry == null;
    }

    @Override
    public Collection<IgniteTxEntry> allEntries() {
        return this.entry != null ? Collections.singletonList(this.entry) : Collections.emptyList();
    }

    @Override
    @Nullable
    public IgniteTxEntry singleWrite() {
        return this.entry;
    }

    @Override
    public void invalidPartition(int cacheId, int part, GridCacheVersion ver) {
        if (this.entry != null && this.entry.context().affinity().partition(this.entry.key()) == part) {
            this.entry = null;
        }
    }

    public String toString() {
        return S.toString(IgniteTxRemoteSingleStateImpl.class, this);
    }

    @Override
    public Collection<CacheStoreManager> stores(GridCacheSharedContext cctx) {
        if (this.entry == null) {
            return null;
        }
        CacheStoreManager store = this.entry.context().store();
        if (store.configured() && store.isLocal()) {
            return Collections.singleton(store);
        }
        return null;
    }
}

