/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationWrongPolymorphicTypeIdException;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.annotation.AbstractConfiguration;
import org.apache.ignite.configuration.annotation.Name;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.configuration.asm.AbstractAsmGenerator;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.asm.SchemaClassesInfo;
import org.apache.ignite.internal.configuration.asm.StringSwitchBuilder;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

class InnerNodeAsmGenerator
extends AbstractAsmGenerator {
    private static final Method ACCEPT;
    private static final Method VISIT_LEAF;
    private static final Method VISIT_INNER;
    private static final Method VISIT_NAMED;
    private static final Method UNWRAP;
    private static final Method DESCEND;
    private static final Method INTERNAL_ID;
    private static final Method REQUIRE_NON_NULL;
    private static final Method CLASS_GET_NAME_MTD;
    private static final Method STRING_EQUALS_MTD;
    private static final Method POLYMORPHIC_TYPE_ID_MTD;
    private static final Method CONSTRUCT_DEFAULT_MTD;
    private static final Method SPECIFIC_NODE_MTD;
    private static final Method ADD_DEFAULTS_MTD;
    private static final Method SET_INJECTED_NAME_FIELD_VALUE_MTD;
    private static final Method IS_POLYMORPHIC_MTD;
    private static final Method EXTENSION_SCHEMA_TYPES_MTD;
    private static final Method ASSERT_MUTABILITY_MTD;
    private static final Method GET_DECLARED_FIELD_MTD;
    private static final String CONVERT_MTD_NAME = "convert";
    private static final String CONSTRUCT_MTD_NAME = "construct";
    private static final String INJECTED_VALUE_FIELD_NAME_MTD_NAME = "injectedValueFieldName";
    private final Map<Field, FieldDefinition> fieldToFieldDefinitionMap = new HashMap<Field, FieldDefinition>();
    private ClassDefinition innerNodeClassDef;

    InnerNodeAsmGenerator(ConfigurationAsmGenerator cgen, Class<?> schemaClass, Set<Class<?>> extensions, Set<Class<?>> polymorphicExtensions, List<Field> schemaFields, Collection<Field> publicExtensionFields, Collection<Field> internalExtensionFields, Collection<Field> polymorphicFields, @Nullable Field internalIdField) {
        super(cgen, schemaClass, extensions, polymorphicExtensions, schemaFields, publicExtensionFields, internalExtensionFields, polymorphicFields, internalIdField);
    }

    @Override
    public List<ClassDefinition> generate() {
        assert (this.innerNodeClassDef == null);
        ArrayList<ClassDefinition> classDefs = new ArrayList<ClassDefinition>();
        classDefs.add(this.createNodeClass());
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection polymorphicFields = this.polymorphicFields.stream().filter(f -> f.getDeclaringClass() == polymorphicExtension).collect(Collectors.toList());
            classDefs.add(this.createPolymorphicExtensionNodeClass(polymorphicExtension, polymorphicFields));
        }
        return classDefs;
    }

    private ClassDefinition createNodeClass() {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        this.innerNodeClassDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.nodeClassName), ParameterizedType.type(InnerNode.class), ConfigurationAsmGenerator.nodeClassInterfaces(this.schemaClass, this.extensions));
        HashMap specFields = new HashMap();
        int i = 0;
        for (Class clazz : CollectionUtils.concat((Collection[])new Collection[]{List.of(this.schemaClass), this.extensions, this.polymorphicExtensions})) {
            specFields.put(clazz, this.innerNodeClassDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "_spec" + i++, clazz));
        }
        HashMap<String, FieldDefinition> fieldDefs = new HashMap<String, FieldDefinition>();
        FieldDefinition polymorphicTypeIdFieldDef = null;
        FieldDefinition injectedNameFieldDef = null;
        Field injectedValueField = null;
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields, this.polymorphicFields})) {
            FieldDefinition fieldDef = this.addInnerNodeField(schemaField);
            fieldDefs.put(fieldDef.getName(), fieldDef);
            if (ConfigurationUtil.isPolymorphicId(schemaField)) {
                polymorphicTypeIdFieldDef = fieldDef;
                continue;
            }
            if (ConfigurationUtil.isInjectedName(schemaField)) {
                injectedNameFieldDef = fieldDef;
                continue;
            }
            if (!ConfigurationUtil.isInjectedValue(schemaField)) continue;
            injectedValueField = schemaField;
        }
        MethodDefinition classInitializer = this.innerNodeClassDef.getClassInitializer();
        this.fieldToFieldDefinitionMap.forEach((k, v) -> {
            BytecodeExpression getDeclaredFieldExp = BytecodeExpressions.constantClass(k.getDeclaringClass()).invoke(GET_DECLARED_FIELD_MTD, new BytecodeExpression[]{BytecodeExpressions.constantString((String)k.getName())});
            classInitializer.getBody().append((BytecodeNode)BytecodeExpressions.setStatic((FieldDefinition)v, (BytecodeExpression)getDeclaredFieldExp));
        });
        this.addNodeSchemaTypeMethod(polymorphicTypeIdFieldDef);
        FieldDefinition extensionSchemaTypesFieldDef = null;
        if (!this.extensions.isEmpty()) {
            extensionSchemaTypesFieldDef = this.innerNodeClassDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "_" + EXTENSION_SCHEMA_TYPES_MTD.getName(), Class[].class);
        }
        this.addNodeConstructor(specFields, fieldDefs, extensionSchemaTypesFieldDef);
        if (this.internalIdField != null) {
            this.addNodeInternalIdMethod();
        }
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
            String fieldName = schemaField.getName();
            FieldDefinition fieldDef = (FieldDefinition)fieldDefs.get(fieldName);
            this.addNodeViewMethod(this.innerNodeClassDef, schemaField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, fieldDef), null);
            if (ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField)) continue;
            List<MethodDefinition> changeMethods = this.addNodeChangeMethod(this.innerNodeClassDef, schemaField, changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, fieldDef), (changeMtd, newValue) -> ConfigurationAsmGenerator.setThisFieldCode(changeMtd, newValue, fieldDef), null);
            InnerNodeAsmGenerator.addNodeChangeBridgeMethod(this.innerNodeClassDef, SchemaClassesInfo.changeClassName(schemaField.getDeclaringClass()), changeMethods.get(0));
        }
        Map<Class<?>, List<Field>> polymorphicFieldsByExtension = Map.of();
        MethodDefinition changePolymorphicTypeIdMtd = null;
        if (!this.polymorphicExtensions.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : this.schemaClass.getName();
            this.addNodeSpecificNodeMethod(polymorphicTypeIdFieldDef);
            changePolymorphicTypeIdMtd = this.addNodeChangePolymorphicTypeIdMethod(fieldDefs, polymorphicTypeIdFieldDef);
            this.addNodeConvertMethods(changePolymorphicTypeIdMtd);
            polymorphicFieldsByExtension = new LinkedHashMap();
            for (Class polymorphicExtension : this.polymorphicExtensions) {
                polymorphicFieldsByExtension.put(polymorphicExtension, this.polymorphicFields.stream().filter(f -> polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList()));
            }
        }
        this.addNodeTraverseChildrenMethod(fieldDefs, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef);
        this.addNodeTraverseChildMethod(fieldDefs, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef);
        this.addNodeConstructMethod(fieldDefs, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef, changePolymorphicTypeIdMtd);
        this.addNodeConstructDefaultMethod(specFields, fieldDefs, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef);
        if (injectedNameFieldDef != null) {
            this.addInjectedNameFieldMethods(injectedNameFieldDef);
        }
        if (injectedValueField != null) {
            this.implementInjectedValueFieldNameMethod(injectedValueField);
        }
        if (polymorphicTypeIdFieldDef != null) {
            this.addIsPolymorphicMethod();
        }
        if (extensionSchemaTypesFieldDef != null) {
            this.addExtensionSchemaTypesMethod(extensionSchemaTypesFieldDef);
        }
        if (this.schemaClass.getSuperclass().isAnnotationPresent(AbstractConfiguration.class)) {
            this.addIsExtendAbstractConfigurationMethod();
        }
        return this.innerNodeClassDef;
    }

    private void addNodeSchemaTypeMethod(@Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition schemaTypeMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "schemaType", ParameterizedType.type(Class.class), new Parameter[0]);
        BytecodeBlock mtdBody = schemaTypeMtd.getBody();
        if (this.polymorphicExtensions.isEmpty()) {
            mtdBody.append((BytecodeNode)BytecodeExpressions.constantClass((Class)this.schemaClass)).retObject();
        } else {
            assert (polymorphicTypeIdFieldDef != null) : this.innerNodeClassDef.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(schemaTypeMtd, polymorphicTypeIdFieldDef);
            for (Class polymorphicExtension : this.polymorphicExtensions) {
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)BytecodeExpressions.constantClass((Class)polymorphicExtension).ret());
            }
            mtdBody.append((BytecodeNode)switchBuilderTypeId.build());
        }
    }

    private FieldDefinition addInnerNodeField(Field schemaField) {
        ParameterizedType nodeFieldType;
        String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
        Class<?> schemaFieldClass = schemaField.getType();
        if (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField)) {
            nodeFieldType = ParameterizedType.type(ConfigurationAsmGenerator.box(schemaFieldClass));
        } else if (ConfigurationUtil.isConfigValue(schemaField)) {
            nodeFieldType = ParameterizedType.typeFromJavaClassName((String)this.cgen.schemaInfo(schemaFieldClass).nodeClassName);
        } else if (ConfigurationUtil.isNamedConfigValue(schemaField)) {
            nodeFieldType = ParameterizedType.type(NamedListNode.class);
        } else {
            throw new IllegalArgumentException("Unsupported field: " + String.valueOf(schemaField));
        }
        this.fieldToFieldDefinitionMap.put(schemaField, this.innerNodeClassDef.declareField(EnumSet.of(Access.PUBLIC, Access.STATIC, Access.FINAL), fieldName.toUpperCase(Locale.ROOT) + "_SCHEMA_FIELD", Field.class));
        return this.innerNodeClassDef.declareField(EnumSet.of(Access.PUBLIC), fieldName, nodeFieldType);
    }

    private void addNodeConstructor(Map<Class<?>, FieldDefinition> specFields, Map<String, FieldDefinition> fieldDefs, @Nullable FieldDefinition extensionSchemaTypesFieldDef) {
        MethodDefinition ctor = this.innerNodeClassDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[0]);
        BytecodeBlock ctorBody = ctor.getBody();
        ctorBody.append((BytecodeNode)ctor.getThis()).invokeConstructor(InnerNode.class, new Class[0]);
        for (Map.Entry<Class<?>, FieldDefinition> e : specFields.entrySet()) {
            ctorBody.append((BytecodeNode)ctor.getThis().setField(e.getValue(), BytecodeExpressions.newInstance(e.getKey(), (BytecodeExpression[])new BytecodeExpression[0])));
        }
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields, this.polymorphicFields})) {
            if (!ConfigurationUtil.isNamedConfigValue(schemaField)) continue;
            FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField));
            ctorBody.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(ctor, this.cgen.newNamedListNode(schemaField), fieldDef));
        }
        if (!this.extensions.isEmpty()) {
            assert (extensionSchemaTypesFieldDef != null) : this.innerNodeClassDef;
            Variable tmpVar = ctor.getScope().createTempVariable(Class[].class);
            BytecodeBlock initExtensionSchemaTypesField = new BytecodeBlock();
            initExtensionSchemaTypesField.append((BytecodeNode)tmpVar.set(BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Class[].class), (int)this.extensions.size())));
            int i = 0;
            for (Class extension : this.extensions) {
                initExtensionSchemaTypesField.append((BytecodeNode)BytecodeExpressions.set((BytecodeExpression)tmpVar, (BytecodeExpression)BytecodeExpressions.constantInt((int)i++), (BytecodeExpression)BytecodeExpressions.constantClass((Class)extension)));
            }
            initExtensionSchemaTypesField.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(ctor, (BytecodeExpression)tmpVar, extensionSchemaTypesFieldDef));
            ctorBody.append((BytecodeNode)initExtensionSchemaTypesField);
        }
        ctorBody.ret();
    }

    private void addNodeInternalIdMethod() {
        MethodDefinition internalIdMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), this.internalIdField.getName(), ParameterizedType.type(UUID.class), new Parameter[0]);
        internalIdMtd.getBody().append((BytecodeNode)internalIdMtd.getThis().invoke(INTERNAL_ID, new BytecodeExpression[0])).retObject();
    }

    private void addNodeViewMethod(ClassDefinition classDef, Field schemaField, Function<MethodDefinition, BytecodeExpression> getFieldCodeFun, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun) {
        Class<?> schemaFieldType = schemaField.getType();
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(schemaFieldType);
        ParameterizedType returnType = ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.viewClassName) : (ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListView.class) : ParameterizedType.type(schemaFieldType));
        String fieldName = schemaField.getName();
        MethodDefinition viewMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        BytecodeBlock bytecodeBlock = new BytecodeBlock();
        bytecodeBlock.append((BytecodeNode)getFieldCodeFun.apply(viewMtd));
        if (schemaFieldType.isPrimitive()) {
            bytecodeBlock.invokeVirtual(ConfigurationAsmGenerator.box(schemaFieldType), schemaFieldType.getSimpleName() + "Value", schemaFieldType, new Class[0]);
        } else if (schemaFieldType.isArray()) {
            bytecodeBlock.invokeVirtual(schemaFieldType, "clone", Object.class, new Class[0]).checkCast(schemaFieldType);
        } else if (ConfigurationUtil.isPolymorphicConfig(schemaFieldType) && ConfigurationUtil.isConfigValue(schemaField)) {
            bytecodeBlock.invokeVirtual(SPECIFIC_NODE_MTD);
        }
        bytecodeBlock.ret(schemaFieldType);
        this.enrichWithPolymorphicTypeCheck(schemaField, getPolymorphicTypeIdFieldFun, viewMtd, bytecodeBlock);
    }

    private List<MethodDefinition> addNodeChangeMethod(ClassDefinition classDef, Field schemaField, Function<MethodDefinition, BytecodeExpression> getFieldCodeFun, BiFunction<MethodDefinition, BytecodeExpression, BytecodeExpression> setFieldCodeFun, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun) {
        Class<?> schemaFieldType = schemaField.getType();
        MethodDefinition changeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), ConfigurationAsmGenerator.changeMethodName(schemaField.getName()), classDef.getType(), new Parameter[]{Parameter.arg((String)"change", (ParameterizedType)(ConfigurationUtil.isValue(schemaField) ? ParameterizedType.type(schemaFieldType) : ParameterizedType.type(Consumer.class)))});
        MethodDefinition shortChangeMtd = null;
        Variable changeVar = changeMtd.getScope().getVariable("change");
        BytecodeBlock bytecodeBlock = new BytecodeBlock();
        this.addAssertMutabilityMethodCall(classDef, changeMtd, bytecodeBlock);
        if (!schemaFieldType.isPrimitive()) {
            bytecodeBlock.append((BytecodeNode)BytecodeExpressions.invokeStatic((Method)REQUIRE_NON_NULL, (BytecodeExpression[])new BytecodeExpression[]{changeVar, BytecodeExpressions.constantString((String)"change")}));
        }
        if (ConfigurationUtil.isValue(schemaField)) {
            Object newValue;
            if (schemaFieldType.isPrimitive()) {
                ParameterizedType type = ParameterizedType.type(ConfigurationAsmGenerator.box(schemaFieldType));
                newValue = BytecodeExpressions.invokeStatic((ParameterizedType)type, (String)"valueOf", (ParameterizedType)type, Collections.singleton(changeVar));
            } else {
                newValue = schemaFieldType.isArray() ? changeVar.invoke("clone", Object.class, new BytecodeExpression[0]).cast(schemaFieldType) : changeVar;
            }
            bytecodeBlock.append((BytecodeNode)setFieldCodeFun.apply(changeMtd, (BytecodeExpression)newValue));
        } else {
            shortChangeMtd = this.createShortChangeMethod(classDef, schemaField, getFieldCodeFun, setFieldCodeFun, getPolymorphicTypeIdFieldFun);
            bytecodeBlock.append((BytecodeNode)changeVar.invoke(ACCEPT, new BytecodeExpression[]{changeMtd.getThis().invoke(shortChangeMtd, List.of())}));
        }
        bytecodeBlock.append((BytecodeNode)changeMtd.getThis()).retObject();
        this.enrichWithPolymorphicTypeCheck(schemaField, getPolymorphicTypeIdFieldFun, changeMtd, bytecodeBlock);
        if (shortChangeMtd == null) {
            return List.of(changeMtd);
        }
        return List.of(changeMtd, shortChangeMtd);
    }

    private MethodDefinition createShortChangeMethod(ClassDefinition classDef, Field schemaField, Function<MethodDefinition, BytecodeExpression> getFieldCodeFun, BiFunction<MethodDefinition, BytecodeExpression, BytecodeExpression> setFieldCodeFun, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun) {
        BytecodeExpression newValue;
        MethodDefinition shortChangeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), ConfigurationAsmGenerator.changeMethodName(schemaField.getName()), ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.changeClassName(schemaField.getType())) : ParameterizedType.type(NamedListChange.class), new Parameter[0]);
        BytecodeBlock shortBytecodeBlock = new BytecodeBlock();
        this.addAssertMutabilityMethodCall(classDef, shortChangeMtd, shortBytecodeBlock);
        if (ConfigurationUtil.isConfigValue(schemaField)) {
            newValue = this.cgen.newOrCopyNodeField(schemaField, getFieldCodeFun.apply(shortChangeMtd));
        } else {
            assert (ConfigurationUtil.isNamedConfigValue(schemaField)) : schemaField;
            newValue = this.cgen.copyNodeField(schemaField, getFieldCodeFun.apply(shortChangeMtd));
        }
        shortBytecodeBlock.append((BytecodeNode)setFieldCodeFun.apply(shortChangeMtd, newValue));
        BytecodeExpression getFieldCode = getFieldCodeFun.apply(shortChangeMtd);
        if (ConfigurationUtil.isPolymorphicConfig(schemaField.getType()) && ConfigurationUtil.isConfigValue(schemaField)) {
            getFieldCode = getFieldCode.invoke(SPECIFIC_NODE_MTD, new BytecodeExpression[0]);
        }
        shortBytecodeBlock.append((BytecodeNode)getFieldCode).retObject();
        this.enrichWithPolymorphicTypeCheck(schemaField, getPolymorphicTypeIdFieldFun, shortChangeMtd, shortBytecodeBlock);
        shortChangeMtd.getBody().append((BytecodeNode)shortBytecodeBlock);
        return shortChangeMtd;
    }

    private void addAssertMutabilityMethodCall(ClassDefinition classDef, MethodDefinition changeMtd, BytecodeBlock body) {
        if (classDef == this.innerNodeClassDef) {
            body.append((BytecodeNode)changeMtd.getThis().invoke(ASSERT_MUTABILITY_MTD, new BytecodeExpression[0]));
        } else {
            body.append((BytecodeNode)changeMtd.getThis().getField(classDef.getType(), "this$0", this.innerNodeClassDef.getType()).invoke(ASSERT_MUTABILITY_MTD, new BytecodeExpression[0]));
        }
    }

    private void enrichWithPolymorphicTypeCheck(Field schemaField, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun, MethodDefinition method, BytecodeBlock bytecodeBlock) {
        if (getPolymorphicTypeIdFieldFun != null) {
            assert (ConfigurationUtil.isPolymorphicConfigInstance(schemaField.getDeclaringClass())) : schemaField;
            BytecodeExpression getPolymorphicTypeIdFieldValue = getPolymorphicTypeIdFieldFun.apply(method);
            String polymorphicInstanceId = ConfigurationUtil.polymorphicInstanceId(schemaField.getDeclaringClass());
            method.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)BytecodeExpressions.constantString((String)polymorphicInstanceId).invoke(STRING_EQUALS_MTD, new BytecodeExpression[]{getPolymorphicTypeIdFieldValue}))).ifTrue((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, getPolymorphicTypeIdFieldValue)).ifFalse((BytecodeNode)bytecodeBlock));
        } else {
            method.getBody().append((BytecodeNode)bytecodeBlock);
        }
    }

    private static void addNodeChangeBridgeMethod(ClassDefinition classDef, String changeClassName, MethodDefinition changeMtd) {
        MethodDefinition bridgeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC, Access.SYNTHETIC, Access.BRIDGE), changeMtd.getName(), ParameterizedType.typeFromJavaClassName((String)changeClassName), (Collection)changeMtd.getParameters());
        Variable changeVar = bridgeMtd.getScope().getVariable("change");
        BytecodeExpression invokeChangeMtd = bridgeMtd.getThis().invoke(changeMtd, List.of(changeVar));
        bridgeMtd.getBody().append((BytecodeNode)invokeChangeMtd).retObject();
    }

    private void addNodeTraverseChildrenMethod(Map<String, FieldDefinition> fieldDefs, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition traverseChildrenMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "traverseChildren", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"visitor", (ParameterizedType)ParameterizedType.type(ConfigurationVisitor.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        BytecodeBlock mtdBody = traverseChildrenMtd.getBody();
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields})) {
            if (ConfigurationUtil.isInjectedName(schemaField)) continue;
            mtdBody.append((BytecodeNode)this.invokeVisit(traverseChildrenMtd, schemaField, fieldDefs.get(schemaField.getName())).pop());
        }
        if (!this.internalExtensionFields.isEmpty()) {
            BytecodeBlock includeInternalBlock = new BytecodeBlock();
            for (Field field : this.internalExtensionFields) {
                includeInternalBlock.append((BytecodeNode)this.invokeVisit(traverseChildrenMtd, field, fieldDefs.get(field.getName())).pop());
            }
            mtdBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)traverseChildrenMtd.getScope().getVariable("includeInternal")).ifTrue((BytecodeNode)includeInternalBlock));
        } else if (!polymorphicFieldsByExtension.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : this.schemaClass.getName();
            assert (this.schemaFields.stream().anyMatch(ConfigurationUtil::isPolymorphicId)) : "Missing field with @PolymorphicId in " + this.schemaClass.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(traverseChildrenMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry entry : polymorphicFieldsByExtension.entrySet()) {
                BytecodeBlock codeBlock = new BytecodeBlock();
                for (Field polymorphicField : (List)entry.getValue()) {
                    String fieldName = ConfigurationAsmGenerator.fieldName(polymorphicField);
                    codeBlock.append((BytecodeNode)this.invokeVisit(traverseChildrenMtd, polymorphicField, fieldDefs.get(fieldName)).pop());
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId((Class)entry.getKey()), (BytecodeNode)codeBlock);
            }
            mtdBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)ConfigurationAsmGenerator.getThisFieldCode(traverseChildrenMtd, polymorphicTypeIdFieldDef))).ifTrue((BytecodeNode)switchBuilderTypeId.build()));
        }
        mtdBody.ret();
    }

    private void addNodeTraverseChildMethod(Map<String, FieldDefinition> fieldDefs, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition traverseChildMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "traverseChild", ParameterizedType.type(Object.class), new Parameter[]{Parameter.arg((String)"key", (ParameterizedType)ParameterizedType.type(String.class)), Parameter.arg((String)"visitor", (ParameterizedType)ParameterizedType.type(ConfigurationVisitor.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        Variable keyVar = traverseChildMtd.getScope().getVariable("key");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(traverseChildMtd.getScope()).expression((BytecodeExpression)keyVar);
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields})) {
            if (ConfigurationUtil.isInjectedName(schemaField)) continue;
            String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
            String publicName = ConfigurationAsmGenerator.publicName(schemaField);
            switchBuilder.addCase(publicName, (BytecodeNode)this.invokeVisit(traverseChildMtd, schemaField, fieldDefs.get(fieldName)).retObject());
        }
        if (!this.internalExtensionFields.isEmpty()) {
            StringSwitchBuilder switchBuilderAllFields = new StringSwitchBuilder(traverseChildMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
            for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
                if (ConfigurationUtil.isInjectedName(schemaField)) continue;
                String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
                String publicName = ConfigurationAsmGenerator.publicName(schemaField);
                switchBuilderAllFields.addCase(publicName, (BytecodeNode)this.invokeVisit(traverseChildMtd, schemaField, fieldDefs.get(fieldName)).retObject());
            }
            traverseChildMtd.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)traverseChildMtd.getScope().getVariable("includeInternal")).ifTrue((BytecodeNode)switchBuilderAllFields.build()).ifFalse((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build()));
        } else if (!polymorphicFieldsByExtension.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : this.innerNodeClassDef.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(traverseChildMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry<Class<?>, List<Field>> e : polymorphicFieldsByExtension.entrySet()) {
                StringSwitchBuilder switchBuilderPolymorphicExtension = new StringSwitchBuilder(traverseChildMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
                for (Field polymorphicField : e.getValue()) {
                    String fieldName = ConfigurationAsmGenerator.fieldName(polymorphicField);
                    String publicName = ConfigurationAsmGenerator.publicName(polymorphicField);
                    switchBuilderPolymorphicExtension.addCase(publicName, (BytecodeNode)this.invokeVisit(traverseChildMtd, polymorphicField, fieldDefs.get(fieldName)).retObject());
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(e.getKey()), (BytecodeNode)switchBuilderPolymorphicExtension.build());
            }
            traverseChildMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock()).build()).append((BytecodeNode)switchBuilderTypeId.build());
        } else {
            traverseChildMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build());
        }
    }

    private BytecodeBlock invokeVisit(MethodDefinition mtd, Field schemaField, FieldDefinition fieldDef) {
        Method visitMethod = ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) ? VISIT_LEAF : (ConfigurationUtil.isConfigValue(schemaField) ? VISIT_INNER : VISIT_NAMED);
        FieldDefinition definition = this.fieldToFieldDefinitionMap.get(schemaField);
        return new BytecodeBlock().append((BytecodeNode)mtd.getScope().getVariable("visitor").invoke(visitMethod, new BytecodeExpression[]{BytecodeExpressions.getStatic((FieldDefinition)definition), BytecodeExpressions.constantString((String)ConfigurationAsmGenerator.publicName(schemaField)), mtd.getThis().getField(fieldDef)}));
    }

    /*
     * WARNING - void declaration
     */
    private void addNodeConstructMethod(Map<String, FieldDefinition> fieldDefs, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef, @Nullable MethodDefinition changePolymorphicTypeIdMtd) {
        MethodDefinition constructMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), CONSTRUCT_MTD_NAME, ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"key", (ParameterizedType)ParameterizedType.type(String.class)), Parameter.arg((String)"src", (ParameterizedType)ParameterizedType.type(ConfigurationSource.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        Variable keyVar = constructMtd.getScope().getVariable("key");
        Variable srcVar = constructMtd.getScope().getVariable("src");
        this.addAssertMutabilityMethodCall(this.innerNodeClassDef, constructMtd, constructMtd.getBody());
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(constructMtd.getScope()).expression((BytecodeExpression)keyVar);
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields})) {
            if (ConfigurationUtil.isInjectedName(schemaField)) continue;
            String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
            String publicName = ConfigurationAsmGenerator.publicName(schemaField);
            FieldDefinition fieldDef = fieldDefs.get(fieldName);
            if (ConfigurationUtil.isPolymorphicId(schemaField)) {
                void var17_22;
                String[] getTypeIdFromSrcVar = BytecodeExpressions.inlineIf((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)srcVar), (BytecodeExpression)BytecodeExpressions.constantNull((ParameterizedType)fieldDef.getType()), (BytecodeExpression)srcVar.invoke(UNWRAP, new BytecodeExpression[]{BytecodeExpressions.constantClass((ParameterizedType)fieldDef.getType())}).cast(fieldDef.getType()));
                switchBuilder.addCase(publicName, (BytecodeNode)new BytecodeBlock().append((BytecodeNode)constructMtd.getThis()).append((BytecodeNode)getTypeIdFromSrcVar).invokeVirtual(changePolymorphicTypeIdMtd).ret());
                String[] stringArray = ConfigurationAsmGenerator.legacyNames(schemaField);
                int n = stringArray.length;
                boolean i = false;
                while (var17_22 < n) {
                    String legacyName = stringArray[var17_22];
                    switchBuilder.addCase(legacyName, (BytecodeNode)new BytecodeBlock().append((BytecodeNode)constructMtd.getThis()).append((BytecodeNode)getTypeIdFromSrcVar).invokeVirtual(changePolymorphicTypeIdMtd).ret());
                    ++var17_22;
                }
                continue;
            }
            switchBuilder.addCase(publicName, (BytecodeNode)this.treatSourceForConstruct(constructMtd, schemaField, fieldDef).ret());
            for (BytecodeExpression bytecodeExpression : ConfigurationAsmGenerator.legacyNames(schemaField)) {
                switchBuilder.addCase((String)bytecodeExpression, (BytecodeNode)this.treatSourceForConstruct(constructMtd, schemaField, fieldDef).ret());
            }
        }
        if (!this.internalExtensionFields.isEmpty()) {
            StringSwitchBuilder switchBuilderAllFields = new StringSwitchBuilder(constructMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
            for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
                if (ConfigurationUtil.isInjectedName(schemaField)) continue;
                String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
                String publicName = ConfigurationAsmGenerator.publicName(schemaField);
                switchBuilderAllFields.addCase(publicName, (BytecodeNode)this.treatSourceForConstruct(constructMtd, schemaField, fieldDefs.get(fieldName)).ret());
                for (String string : ConfigurationAsmGenerator.legacyNames(schemaField)) {
                    switchBuilderAllFields.addCase(string, (BytecodeNode)this.treatSourceForConstruct(constructMtd, schemaField, fieldDefs.get(fieldName)).ret());
                }
            }
            constructMtd.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)constructMtd.getScope().getVariable("includeInternal")).ifTrue((BytecodeNode)switchBuilderAllFields.build()).ifFalse((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build())).ret();
        } else if (!polymorphicFieldsByExtension.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : this.innerNodeClassDef.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(constructMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry<Class<?>, List<Field>> e : polymorphicFieldsByExtension.entrySet()) {
                StringSwitchBuilder switchBuilderPolymorphicExtension = new StringSwitchBuilder(constructMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
                for (Field polymorphicField : e.getValue()) {
                    String fieldName = ConfigurationAsmGenerator.fieldName(polymorphicField);
                    String publicName = ConfigurationAsmGenerator.publicName(polymorphicField);
                    FieldDefinition fieldDefinition = fieldDefs.get(fieldName);
                    switchBuilderPolymorphicExtension.addCase(publicName, (BytecodeNode)this.treatSourceForConstruct(constructMtd, polymorphicField, fieldDefinition).ret());
                    for (String legacyName : ConfigurationAsmGenerator.legacyNames(polymorphicField)) {
                        switchBuilderPolymorphicExtension.addCase(legacyName, (BytecodeNode)this.treatSourceForConstruct(constructMtd, polymorphicField, fieldDefinition).ret());
                    }
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(e.getKey()), (BytecodeNode)switchBuilderPolymorphicExtension.build());
            }
            constructMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock()).build()).append((BytecodeNode)switchBuilderTypeId.build()).ret();
        } else {
            constructMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build()).ret();
        }
    }

    private BytecodeBlock treatSourceForConstruct(MethodDefinition constructMtd, Field schemaField, FieldDefinition schemaFieldDef) {
        BytecodeBlock codeBlock = new BytecodeBlock();
        Variable thisVar = constructMtd.getThis();
        Variable srcVar = constructMtd.getScope().getVariable("src");
        if (ConfigurationUtil.isValue(schemaField)) {
            codeBlock.append((BytecodeNode)thisVar.setField(schemaFieldDef, BytecodeExpressions.inlineIf((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)srcVar), (BytecodeExpression)BytecodeExpressions.constantNull((ParameterizedType)schemaFieldDef.getType()), (BytecodeExpression)srcVar.invoke(UNWRAP, new BytecodeExpression[]{BytecodeExpressions.constantClass((ParameterizedType)schemaFieldDef.getType())}).cast(schemaFieldDef.getType()))));
        } else if (ConfigurationUtil.isConfigValue(schemaField)) {
            BytecodeExpression setField;
            ParameterizedType fieldDefType = schemaFieldDef.getType();
            if (ConfigurationUtil.isPolymorphicConfig(schemaField.getType())) {
                Field polymorphicIdField = ConfigurationAsmGenerator.polymorphicIdField(schemaField.getType());
                assert (polymorphicIdField != null) : schemaField.getType().getName();
                BytecodeExpression thisField = ConfigurationAsmGenerator.getThisFieldCode(constructMtd, schemaFieldDef);
                Variable tmpStrVar = constructMtd.getScope().createTempVariable(String.class);
                BytecodeBlock copyWithChange = new BytecodeBlock().append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, thisField.invoke(COPY, new BytecodeExpression[0]).cast(fieldDefType), schemaFieldDef)).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)tmpStrVar)).ifTrue((BytecodeNode)thisField.invoke(ConfigurationAsmGenerator.changeMethodName(polymorphicIdField.getName()), Void.TYPE, new BytecodeExpression[]{tmpStrVar})));
                BytecodeBlock newInstanceWithChange = new BytecodeBlock().append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, BytecodeExpressions.newInstance((ParameterizedType)fieldDefType, (BytecodeExpression[])new BytecodeExpression[0]), schemaFieldDef)).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)tmpStrVar)).ifTrue((BytecodeNode)thisField.invoke(ConfigurationAsmGenerator.changeMethodName(polymorphicIdField.getName()), Void.TYPE, new BytecodeExpression[]{tmpStrVar})).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)thisField.invoke(CONSTRUCT_DEFAULT_MTD, new BytecodeExpression[]{BytecodeExpressions.constantString((String)polymorphicIdField.getName())})).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)thisField.getField(polymorphicIdField.getName(), String.class))).ifTrue((BytecodeNode)ConfigurationAsmGenerator.throwException(IllegalStateException.class, BytecodeExpressions.constantString((String)InnerNodeAsmGenerator.polymorphicTypeNotDefinedErrorMessage(polymorphicIdField)))))));
                setField = new BytecodeBlock().append((BytecodeNode)tmpStrVar.set(srcVar.invoke(POLYMORPHIC_TYPE_ID_MTD, new BytecodeExpression[]{BytecodeExpressions.constantString((String)polymorphicIdField.getName())}))).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)thisField)).ifTrue((BytecodeNode)newInstanceWithChange).ifFalse((BytecodeNode)copyWithChange));
            } else {
                BytecodeExpression newValue = this.cgen.newOrCopyNodeField(schemaField, ConfigurationAsmGenerator.getThisFieldCode(constructMtd, schemaFieldDef));
                setField = ConfigurationAsmGenerator.setThisFieldCode(constructMtd, newValue, schemaFieldDef);
            }
            if (ConfigurationUtil.containsNameAnnotation(schemaField)) {
                setField = new BytecodeBlock().append((BytecodeNode)setField).append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(constructMtd, schemaFieldDef).invoke(SET_INJECTED_NAME_FIELD_VALUE_MTD, new BytecodeExpression[]{BytecodeExpressions.constantString((String)schemaField.getAnnotation(Name.class).value())}));
            }
            codeBlock.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)srcVar)).ifTrue((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, BytecodeExpressions.constantNull((ParameterizedType)fieldDefType), schemaFieldDef)).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)setField).append((BytecodeNode)srcVar.invoke(DESCEND, new BytecodeExpression[]{thisVar.getField(schemaFieldDef)}))));
        } else {
            codeBlock.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)srcVar)).ifTrue((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, this.cgen.newNamedListNode(schemaField), schemaFieldDef)).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, thisVar.getField(schemaFieldDef).invoke(COPY, new BytecodeExpression[0]).cast(schemaFieldDef.getType()), schemaFieldDef)).append((BytecodeNode)srcVar.invoke(DESCEND, new BytecodeExpression[]{thisVar.getField(schemaFieldDef)}))));
        }
        return codeBlock;
    }

    private void addNodeConstructDefaultMethod(Map<Class<?>, FieldDefinition> specFields, Map<String, FieldDefinition> fieldDefs, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition constructDfltMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "constructDefault", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"key", String.class)}).addException(NoSuchElementException.class);
        this.addAssertMutabilityMethodCall(this.innerNodeClassDef, constructDfltMtd, constructDfltMtd.getBody());
        Variable keyVar = constructDfltMtd.getScope().getVariable("key");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(constructDfltMtd.getScope()).expression((BytecodeExpression)keyVar);
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
            if (ConfigurationUtil.isInjectedName(schemaField) || !ConfigurationUtil.isValue(schemaField) && !ConfigurationUtil.isPolymorphicId(schemaField)) continue;
            String fieldName = schemaField.getName();
            String publicName = ConfigurationAsmGenerator.publicName(schemaField);
            if (ConfigurationUtil.isValue(schemaField) && !ConfigurationUtil.hasDefault(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) && !schemaField.getAnnotation(PolymorphicId.class).hasDefault()) {
                switchBuilder.addCase(publicName, (BytecodeNode)new BytecodeBlock().ret());
                for (String string : ConfigurationAsmGenerator.legacyNames(schemaField)) {
                    switchBuilder.addCase(string, (BytecodeNode)new BytecodeBlock().ret());
                }
                continue;
            }
            FieldDefinition fieldDef = fieldDefs.get(fieldName);
            Class<?> fieldType = schemaField.getDeclaringClass();
            FieldDefinition specFieldDef = fieldType.isAnnotationPresent(AbstractConfiguration.class) ? specFields.get(this.schemaClass) : specFields.get(fieldType);
            switchBuilder.addCase(publicName, (BytecodeNode)InnerNodeAsmGenerator.addNodeConstructDefault(constructDfltMtd, schemaField, fieldDef, specFieldDef).ret());
            for (String legacyName3 : ConfigurationAsmGenerator.legacyNames(schemaField)) {
                switchBuilder.addCase(legacyName3, (BytecodeNode)InnerNodeAsmGenerator.addNodeConstructDefault(constructDfltMtd, schemaField, fieldDef, specFieldDef).ret());
            }
        }
        if (!polymorphicFieldsByExtension.isEmpty()) {
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(constructDfltMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry<Class<?>, List<Field>> e : polymorphicFieldsByExtension.entrySet()) {
                StringSwitchBuilder switchBuilderPolymorphicExtension = new StringSwitchBuilder(constructDfltMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
                for (Field polymorphicField : e.getValue()) {
                    if (!ConfigurationUtil.isValue(polymorphicField)) continue;
                    String publicName = ConfigurationAsmGenerator.publicName(polymorphicField);
                    if (!ConfigurationUtil.hasDefault(polymorphicField)) {
                        switchBuilderPolymorphicExtension.addCase(publicName, (BytecodeNode)new BytecodeBlock().ret());
                        for (String legacyName : ConfigurationAsmGenerator.legacyNames(polymorphicField)) {
                            switchBuilderPolymorphicExtension.addCase(legacyName, (BytecodeNode)new BytecodeBlock().ret());
                        }
                        continue;
                    }
                    FieldDefinition fieldDefinition = fieldDefs.get(ConfigurationAsmGenerator.fieldName(polymorphicField));
                    FieldDefinition specFieldDef = specFields.get(polymorphicField.getDeclaringClass());
                    switchBuilderPolymorphicExtension.addCase(publicName, (BytecodeNode)InnerNodeAsmGenerator.addNodeConstructDefault(constructDfltMtd, polymorphicField, fieldDefinition, specFieldDef).ret());
                    for (String legacyName : ConfigurationAsmGenerator.legacyNames(polymorphicField)) {
                        switchBuilderPolymorphicExtension.addCase(legacyName, (BytecodeNode)InnerNodeAsmGenerator.addNodeConstructDefault(constructDfltMtd, polymorphicField, fieldDefinition, specFieldDef).ret());
                    }
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(e.getKey()), (BytecodeNode)switchBuilderPolymorphicExtension.build());
            }
            constructDfltMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock()).build()).append((BytecodeNode)switchBuilderTypeId.build()).ret();
        } else {
            constructDfltMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build()).ret();
        }
    }

    private static BytecodeBlock addNodeConstructDefault(MethodDefinition constructDfltMtd, Field schemaField, FieldDefinition schemaFieldDef, FieldDefinition specFieldDef) {
        Variable thisVar = constructDfltMtd.getThis();
        BytecodeExpression defaultValue = thisVar.getField(specFieldDef).getField(schemaField);
        Class<?> schemaFieldType = schemaField.getType();
        if (schemaFieldType.isPrimitive()) {
            defaultValue = BytecodeExpressions.invokeStatic((ParameterizedType)schemaFieldDef.getType(), (String)"valueOf", (ParameterizedType)schemaFieldDef.getType(), Collections.singleton(defaultValue));
        }
        if (schemaFieldType.isArray()) {
            defaultValue = defaultValue.invoke("clone", Object.class, new BytecodeExpression[0]).cast(schemaFieldType);
        }
        return new BytecodeBlock().append((BytecodeNode)thisVar.setField(schemaFieldDef, defaultValue));
    }

    private void addInjectedNameFieldMethods(FieldDefinition injectedNameFieldDef) {
        MethodDefinition getInjectedNameFieldValueMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "getInjectedNameFieldValue", ParameterizedType.type(String.class), new Parameter[0]);
        getInjectedNameFieldValueMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(getInjectedNameFieldValueMtd, injectedNameFieldDef)).retObject();
        MethodDefinition setInjectedNameFieldValueMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "setInjectedNameFieldValue", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"value", String.class)});
        this.addAssertMutabilityMethodCall(this.innerNodeClassDef, setInjectedNameFieldValueMtd, setInjectedNameFieldValueMtd.getBody());
        Variable valueVar = setInjectedNameFieldValueMtd.getScope().getVariable("value");
        setInjectedNameFieldValueMtd.getBody().append((BytecodeNode)BytecodeExpressions.invokeStatic((Method)REQUIRE_NON_NULL, (BytecodeExpression[])new BytecodeExpression[]{valueVar, BytecodeExpressions.constantString((String)"value")})).append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(setInjectedNameFieldValueMtd, (BytecodeExpression)valueVar, injectedNameFieldDef)).ret();
    }

    private void implementInjectedValueFieldNameMethod(Field injectedValueField) {
        MethodDefinition method = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), INJECTED_VALUE_FIELD_NAME_MTD_NAME, ParameterizedType.type(String.class), new Parameter[0]);
        method.getBody().append((BytecodeNode)BytecodeExpressions.constantString((String)ConfigurationAsmGenerator.publicName(injectedValueField))).retObject();
    }

    private void addIsPolymorphicMethod() {
        MethodDefinition mtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), IS_POLYMORPHIC_MTD.getName(), ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        mtd.getBody().push(true).retBoolean();
    }

    private void addExtensionSchemaTypesMethod(FieldDefinition schemaTypesFieldDef) {
        MethodDefinition mtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), EXTENSION_SCHEMA_TYPES_MTD.getName(), ParameterizedType.type(Class[].class), new Parameter[0]);
        mtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(mtd, schemaTypesFieldDef)).retObject();
    }

    private void addIsExtendAbstractConfigurationMethod() {
        MethodDefinition mtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "extendsAbstractConfiguration", ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        mtd.getBody().push(true).retBoolean();
    }

    private ClassDefinition createPolymorphicExtensionNodeClass(Class<?> polymorphicExtension, Collection<Field> polymorphicFields) {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        SchemaClassesInfo polymorphicExtensionClassInfo = this.cgen.schemaInfo(polymorphicExtension);
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(polymorphicExtensionClassInfo.nodeClassName), ParameterizedType.type(Object.class), (ParameterizedType[])ArrayUtils.concat((Object[])ConfigurationAsmGenerator.nodeClassInterfaces(polymorphicExtension, Set.of()), (Object[])new ParameterizedType[]{ParameterizedType.type(ConstructableTreeNode.class)}));
        FieldDefinition parentInnerNodeFieldDef = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "this$0", ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.nodeClassName));
        MethodDefinition constructorMtd = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[]{Parameter.arg((String)"delegate", (ParameterizedType)ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.nodeClassName))});
        Variable delegateVar = constructorMtd.getScope().getVariable("delegate");
        constructorMtd.getBody().append((BytecodeNode)constructorMtd.getThis()).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)constructorMtd.getThis().setField(parentInnerNodeFieldDef, (BytecodeExpression)delegateVar)).ret();
        Map fieldDefs = this.innerNodeClassDef.getFields().stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
        if (this.internalIdField != null) {
            this.addNodeViewMethod(classDef, this.internalIdField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef).invoke(INTERNAL_ID, new BytecodeExpression[0]), null);
        }
        for (Object schemaField : this.schemaFields) {
            FieldDefinition schemaFieldDef = (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName((Field)schemaField));
            this.addNodeViewMethod(classDef, (Field)schemaField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef, schemaFieldDef), null);
            if (ConfigurationUtil.isReadOnly((Field)schemaField)) continue;
            List<MethodDefinition> changeMethods = this.addNodeChangeMethod(classDef, (Field)schemaField, changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, parentInnerNodeFieldDef, schemaFieldDef), (changeMtd, newValue) -> ConfigurationAsmGenerator.setThisFieldCode(changeMtd, newValue, parentInnerNodeFieldDef, schemaFieldDef), null);
            InnerNodeAsmGenerator.addNodeChangeBridgeMethod(classDef, schemaClassInfo.changeClassName, changeMethods.get(0));
        }
        FieldDefinition polymorphicTypeIdFieldDef = (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.polymorphicIdField(this.schemaClass).getName());
        for (Field polymorphicField : polymorphicFields) {
            FieldDefinition polymorphicFieldDef = (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(polymorphicField));
            this.addNodeViewMethod(classDef, polymorphicField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef, polymorphicFieldDef), viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef, polymorphicTypeIdFieldDef));
            List<MethodDefinition> changeMethods = this.addNodeChangeMethod(classDef, polymorphicField, changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, parentInnerNodeFieldDef, polymorphicFieldDef), (changeMtd, newValue) -> ConfigurationAsmGenerator.setThisFieldCode(changeMtd, newValue, parentInnerNodeFieldDef, polymorphicFieldDef), changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, parentInnerNodeFieldDef, polymorphicTypeIdFieldDef));
            InnerNodeAsmGenerator.addNodeChangeBridgeMethod(classDef, polymorphicExtensionClassInfo.changeClassName, changeMethods.get(0));
        }
        ParameterizedType returnType = ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.changeClassName);
        MethodDefinition convertByChangeClassMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, returnType, new Parameter[]{Parameter.arg((String)"changeClass", Class.class)});
        convertByChangeClassMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(convertByChangeClassMtd, parentInnerNodeFieldDef)).append((BytecodeNode)convertByChangeClassMtd.getScope().getVariable("changeClass")).invokeVirtual(this.innerNodeClassDef.getType(), CONVERT_MTD_NAME, returnType, new ParameterizedType[]{ParameterizedType.type(Class.class)}).retObject();
        MethodDefinition convertByPolymorphicTypeIdMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, returnType, new Parameter[]{Parameter.arg((String)"polymorphicTypeId", String.class)});
        convertByPolymorphicTypeIdMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(convertByPolymorphicTypeIdMtd, parentInnerNodeFieldDef)).append((BytecodeNode)convertByPolymorphicTypeIdMtd.getScope().getVariable("polymorphicTypeId")).invokeVirtual(this.innerNodeClassDef.getType(), CONVERT_MTD_NAME, returnType, new ParameterizedType[]{ParameterizedType.type(String.class)}).retObject();
        MethodDefinition constructMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONSTRUCT_MTD_NAME, ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"key", (ParameterizedType)ParameterizedType.type(String.class)), Parameter.arg((String)"src", (ParameterizedType)ParameterizedType.type(ConfigurationSource.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        constructMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(constructMtd, parentInnerNodeFieldDef)).append((BytecodeNode)constructMtd.getScope().getVariable("key")).append((BytecodeNode)constructMtd.getScope().getVariable("src")).append((BytecodeNode)constructMtd.getScope().getVariable("includeInternal")).invokeVirtual(this.innerNodeClassDef.getType(), CONSTRUCT_MTD_NAME, ParameterizedType.type(Void.TYPE), new ParameterizedType[]{ParameterizedType.type(String.class), ParameterizedType.type(ConfigurationSource.class), ParameterizedType.type(Boolean.TYPE)}).ret();
        MethodDefinition copyMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "copy", ParameterizedType.type(ConstructableTreeNode.class), new Parameter[0]);
        copyMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(copyMtd, parentInnerNodeFieldDef)).invokeVirtual(this.innerNodeClassDef.getType(), "copy", ParameterizedType.type(ConstructableTreeNode.class), new ParameterizedType[0]).retObject();
        return classDef;
    }

    private void addNodeSpecificNodeMethod(FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition specificNodeMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), SPECIFIC_NODE_MTD.getName(), ParameterizedType.type(Object.class), new Parameter[0]);
        StringSwitchBuilder switchBuilder = ConfigurationAsmGenerator.typeIdSwitchBuilder(specificNodeMtd, polymorphicTypeIdFieldDef);
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            SchemaClassesInfo polymorphicExtensionClassInfo = this.cgen.schemaInfo(polymorphicExtension);
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)polymorphicExtensionClassInfo.nodeClassName), (BytecodeExpression[])new BytecodeExpression[]{specificNodeMtd.getThis()}).ret());
        }
        specificNodeMtd.getBody().append((BytecodeNode)switchBuilder.build());
    }

    private void addNodeConvertMethods(MethodDefinition changePolymorphicTypeIdMtd) {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        MethodDefinition convertByChangeClassMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.changeClassName), new Parameter[]{Parameter.arg((String)"changeClass", Class.class)});
        MethodDefinition convertByPolymorphicTypeIdMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.changeClassName), new Parameter[]{Parameter.arg((String)"polymorphicTypeId", String.class)});
        BytecodeExpression changeClassName = convertByChangeClassMtd.getScope().getVariable("changeClass").invoke(CLASS_GET_NAME_MTD, new BytecodeExpression[0]);
        StringSwitchBuilder switchByChangeClassBuilder = new StringSwitchBuilder(convertByChangeClassMtd.getScope()).expression(changeClassName).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, changeClassName));
        Variable polymorphicTypeId = convertByPolymorphicTypeIdMtd.getScope().getVariable("polymorphicTypeId");
        StringSwitchBuilder switchByPolymorphicTypeIdBuilder = new StringSwitchBuilder(convertByPolymorphicTypeIdMtd.getScope()).expression((BytecodeExpression)polymorphicTypeId).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{polymorphicTypeId}));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            SchemaClassesInfo polymorphicExtensionClassInfo = this.cgen.schemaInfo(polymorphicExtension);
            String polymorphicInstanceId = ConfigurationUtil.polymorphicInstanceId(polymorphicExtension);
            switchByChangeClassBuilder.addCase(polymorphicExtensionClassInfo.changeClassName, (BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.constantString((String)polymorphicInstanceId)).invokeVirtual(changePolymorphicTypeIdMtd).append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)polymorphicExtensionClassInfo.nodeClassName), (BytecodeExpression[])new BytecodeExpression[]{convertByChangeClassMtd.getThis()})).retObject());
            switchByPolymorphicTypeIdBuilder.addCase(polymorphicInstanceId, (BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.constantString((String)polymorphicInstanceId)).invokeVirtual(changePolymorphicTypeIdMtd).append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)polymorphicExtensionClassInfo.nodeClassName), (BytecodeExpression[])new BytecodeExpression[]{convertByPolymorphicTypeIdMtd.getThis()})).retObject());
        }
        convertByChangeClassMtd.getBody().append((BytecodeNode)convertByChangeClassMtd.getThis()).append((BytecodeNode)switchByChangeClassBuilder.build()).ret();
        convertByPolymorphicTypeIdMtd.getBody().append((BytecodeNode)convertByPolymorphicTypeIdMtd.getThis()).append((BytecodeNode)switchByPolymorphicTypeIdBuilder.build()).ret();
    }

    private MethodDefinition addNodeChangePolymorphicTypeIdMethod(Map<String, FieldDefinition> fieldDefs, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition changePolymorphicTypeIdMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), ConfigurationAsmGenerator.changeMethodName(polymorphicTypeIdFieldDef.getName()), ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"typeId", String.class)});
        Variable typeIdVar = changePolymorphicTypeIdMtd.getScope().getVariable("typeId");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(changePolymorphicTypeIdMtd.getScope()).expression((BytecodeExpression)typeIdVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{typeIdVar}));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection resetFields = this.polymorphicFields.stream().filter(f -> !polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList());
            BytecodeBlock codeBlock = new BytecodeBlock().append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(changePolymorphicTypeIdMtd, (BytecodeExpression)typeIdVar, polymorphicTypeIdFieldDef));
            for (Field resetField : resetFields) {
                FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(resetField));
                if (ConfigurationUtil.isValue(resetField) || ConfigurationUtil.isConfigValue(resetField)) {
                    codeBlock.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(changePolymorphicTypeIdMtd, BytecodeExpressions.constantNull((ParameterizedType)fieldDef.getType()), fieldDef));
                    continue;
                }
                codeBlock.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(changePolymorphicTypeIdMtd, this.cgen.newNamedListNode(resetField), fieldDef));
            }
            codeBlock.append((BytecodeNode)changePolymorphicTypeIdMtd.getThis()).invokeStatic(ADD_DEFAULTS_MTD);
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)codeBlock);
        }
        changePolymorphicTypeIdMtd.getBody().append((BytecodeNode)typeIdVar).append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(changePolymorphicTypeIdMtd, polymorphicTypeIdFieldDef)).append((BytecodeNode)new IfStatement().condition((BytecodeNode)new BytecodeBlock().invokeVirtual(STRING_EQUALS_MTD)).ifTrue((BytecodeNode)new BytecodeBlock().ret()).ifFalse((BytecodeNode)switchBuilder.build().ret()));
        return changePolymorphicTypeIdMtd;
    }

    private static String polymorphicTypeNotDefinedErrorMessage(Field polymorphicIdField) {
        return "Polymorphic configuration type is not defined: " + polymorphicIdField.getDeclaringClass().getName() + ". See @" + PolymorphicConfig.class.getSimpleName() + " documentation.";
    }

    static {
        try {
            ACCEPT = Consumer.class.getDeclaredMethod("accept", Object.class);
            VISIT_LEAF = ConfigurationVisitor.class.getDeclaredMethod("visitLeafNode", Field.class, String.class, Serializable.class);
            VISIT_INNER = ConfigurationVisitor.class.getDeclaredMethod("visitInnerNode", Field.class, String.class, InnerNode.class);
            VISIT_NAMED = ConfigurationVisitor.class.getDeclaredMethod("visitNamedListNode", Field.class, String.class, NamedListNode.class);
            UNWRAP = ConfigurationSource.class.getDeclaredMethod("unwrap", Class.class);
            DESCEND = ConfigurationSource.class.getDeclaredMethod("descend", ConstructableTreeNode.class);
            INTERNAL_ID = InnerNode.class.getDeclaredMethod("internalId", new Class[0]);
            REQUIRE_NON_NULL = Objects.class.getDeclaredMethod("requireNonNull", Object.class, String.class);
            CLASS_GET_NAME_MTD = Class.class.getDeclaredMethod("getName", new Class[0]);
            STRING_EQUALS_MTD = String.class.getDeclaredMethod("equals", Object.class);
            POLYMORPHIC_TYPE_ID_MTD = ConfigurationSource.class.getDeclaredMethod("polymorphicTypeId", String.class);
            CONSTRUCT_DEFAULT_MTD = InnerNode.class.getDeclaredMethod("constructDefault", String.class);
            SPECIFIC_NODE_MTD = InnerNode.class.getDeclaredMethod("specificNode", new Class[0]);
            ADD_DEFAULTS_MTD = ConfigurationUtil.class.getDeclaredMethod("addDefaults", InnerNode.class);
            SET_INJECTED_NAME_FIELD_VALUE_MTD = InnerNode.class.getDeclaredMethod("setInjectedNameFieldValue", String.class);
            IS_POLYMORPHIC_MTD = InnerNode.class.getDeclaredMethod("isPolymorphic", new Class[0]);
            EXTENSION_SCHEMA_TYPES_MTD = InnerNode.class.getDeclaredMethod("extensionSchemaTypes", new Class[0]);
            ASSERT_MUTABILITY_MTD = InnerNode.class.getDeclaredMethod("assertMutability", new Class[0]);
            GET_DECLARED_FIELD_MTD = Class.class.getDeclaredMethod("getDeclaredField", String.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }
}

