/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.raft.configuration.LogStorageBudgetView;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.LogStorageFactoryCreator;
import org.apache.ignite.internal.raft.storage.impl.VolatileLogStorageFactory;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.raft.jraft.util.ExecutorServiceHelper;
import org.apache.ignite.raft.jraft.util.Platform;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.Options;
import org.rocksdb.Priority;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class VolatileLogStorageFactoryCreator
implements LogStorageFactoryCreator,
IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(VolatileLogStorageFactoryCreator.class);
    private final Path spillOutPath;
    private DBOptions dbOptions;
    private RocksDB db;
    private ColumnFamilyHandle columnFamily;
    private final ExecutorService executorService;

    public VolatileLogStorageFactoryCreator(String nodeName, Path spillOutPath) {
        this.spillOutPath = Objects.requireNonNull(spillOutPath);
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"raft-volatile-log-rocksdb-spillout-pool", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        try {
            Files.createDirectories(this.spillOutPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create directory: " + String.valueOf(this.spillOutPath), e);
        }
        this.wipeOutDb();
        this.dbOptions = VolatileLogStorageFactoryCreator.createDbOptions();
        ColumnFamilyOptions cfOption = VolatileLogStorageFactoryCreator.createColumnFamilyOptions();
        ArrayList columnFamilyHandles = new ArrayList();
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = List.of(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, cfOption));
        try {
            this.db = RocksDB.open((DBOptions)this.dbOptions, (String)this.spillOutPath.toString(), columnFamilyDescriptors, columnFamilyHandles);
            Env env = this.db.getEnv();
            env.setBackgroundThreads(Runtime.getRuntime().availableProcessors(), Priority.HIGH);
            env.setBackgroundThreads(Runtime.getRuntime().availableProcessors(), Priority.LOW);
            assert (columnFamilyHandles.size() == 1);
            this.columnFamily = (ColumnFamilyHandle)columnFamilyHandles.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private void wipeOutDb() {
        try (Options options = new Options();){
            RocksDB.destroyDB((String)this.spillOutPath.toString(), (Options)options);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException("Cannot destroy spill-out RocksDB at " + String.valueOf(this.spillOutPath), (Throwable)e);
        }
    }

    private static DBOptions createDbOptions() {
        return new DBOptions().setMaxBackgroundJobs(Runtime.getRuntime().availableProcessors() * 2).setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
    }

    private static ColumnFamilyOptions createColumnFamilyOptions() {
        ColumnFamilyOptions opts = new ColumnFamilyOptions();
        opts.setWriteBufferSize(0x4000000L);
        opts.setMaxWriteBufferNumber(5);
        opts.setMinWriteBufferNumberToMerge(1);
        opts.setLevel0FileNumCompactionTrigger(50);
        opts.setLevel0SlowdownWritesTrigger(100);
        opts.setLevel0StopWritesTrigger(200);
        opts.setMaxBytesForLevelBase(0xC8000000L);
        opts.setTargetFileSizeBase(0x14000000L);
        if (!Platform.isWindows()) {
            opts.setCompressionType(CompressionType.LZ4_COMPRESSION).setCompactionStyle(CompactionStyle.LEVEL).optimizeLevelStyleCompaction();
        }
        return opts;
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        ExecutorServiceHelper.shutdownAndAwaitTermination(this.executorService);
        try {
            IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.columnFamily, this.db, this.dbOptions});
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public LogStorageFactory factory(LogStorageBudgetView budgetView) {
        return new VolatileLogStorageFactory(budgetView, this.db, this.columnFamily, this.executorService);
    }
}

