/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.sql.engine.exec.SharedState;
import org.apache.ignite.internal.sql.engine.message.QueryBatchRequestMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchRequestMessageBuilder;
import org.apache.ignite.internal.sql.engine.message.QueryBatchRequestMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class QueryBatchRequestMessageImpl
implements QueryBatchRequestMessage,
Cloneable {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final int amountOfBatches;
    @IgniteToStringInclude
    private final long exchangeId;
    @IgniteToStringInclude
    private final int executionToken;
    @IgniteToStringInclude
    private final long fragmentId;
    @IgniteToStringInclude
    private final UUID queryId;
    @IgniteToStringInclude
    private SharedState sharedState;
    private byte[] sharedStateByteArray;

    private QueryBatchRequestMessageImpl(int amountOfBatches, long exchangeId, int executionToken, long fragmentId, UUID queryId, SharedState sharedState, byte[] sharedStateByteArray) {
        this.amountOfBatches = amountOfBatches;
        this.exchangeId = exchangeId;
        this.executionToken = executionToken;
        this.fragmentId = fragmentId;
        this.queryId = queryId;
        this.sharedState = sharedState;
        this.sharedStateByteArray = sharedStateByteArray;
    }

    @Override
    public int amountOfBatches() {
        return this.amountOfBatches;
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    @Override
    public int executionToken() {
        return this.executionToken;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    byte[] sharedStateByteArray() {
        return this.sharedStateByteArray;
    }

    @Override
    public SharedState sharedState() {
        return this.sharedState;
    }

    public MessageSerializer serializer() {
        return QueryBatchRequestMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(QueryBatchRequestMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryBatchRequestMessageImpl otherMessage = (QueryBatchRequestMessageImpl)other;
        return Objects.equals(this.queryId, otherMessage.queryId) && Objects.equals(this.sharedState, otherMessage.sharedState) && this.amountOfBatches == otherMessage.amountOfBatches && this.exchangeId == otherMessage.exchangeId && this.executionToken == otherMessage.executionToken && this.fragmentId == otherMessage.fragmentId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.amountOfBatches, this.exchangeId, this.executionToken, this.fragmentId, this.queryId, this.sharedState);
        return result;
    }

    public QueryBatchRequestMessageImpl clone() {
        try {
            return (QueryBatchRequestMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static QueryBatchRequestMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject sharedStateByteArraymo = marshaller.marshal((Object)this.sharedState);
        usedDescriptors.addAll((IntCollection)sharedStateByteArraymo.usedDescriptorIds());
        this.sharedStateByteArray = sharedStateByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.sharedState = (SharedState)marshaller.unmarshal(this.sharedStateByteArray, descriptorsObj);
        this.sharedStateByteArray = null;
    }

    private static class Builder
    implements QueryBatchRequestMessageBuilder {
        private int amountOfBatches;
        private long exchangeId;
        private int executionToken;
        private long fragmentId;
        private UUID queryId;
        private SharedState sharedState;
        private byte[] sharedStateByteArray;

        private Builder() {
        }

        @Override
        public QueryBatchRequestMessageBuilder amountOfBatches(int amountOfBatches) {
            this.amountOfBatches = amountOfBatches;
            return this;
        }

        @Override
        public QueryBatchRequestMessageBuilder exchangeId(long exchangeId) {
            this.exchangeId = exchangeId;
            return this;
        }

        @Override
        public QueryBatchRequestMessageBuilder executionToken(int executionToken) {
            this.executionToken = executionToken;
            return this;
        }

        @Override
        public QueryBatchRequestMessageBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public QueryBatchRequestMessageBuilder queryId(UUID queryId) {
            Objects.requireNonNull(queryId, "queryId is not marked @Nullable");
            this.queryId = queryId;
            return this;
        }

        @Override
        public QueryBatchRequestMessageBuilder sharedState(SharedState sharedState) {
            this.sharedState = sharedState;
            return this;
        }

        @Override
        public QueryBatchRequestMessageBuilder sharedStateByteArray(byte[] sharedStateByteArray) {
            this.sharedStateByteArray = sharedStateByteArray;
            return this;
        }

        @Override
        public int amountOfBatches() {
            return this.amountOfBatches;
        }

        @Override
        public long exchangeId() {
            return this.exchangeId;
        }

        @Override
        public int executionToken() {
            return this.executionToken;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public SharedState sharedState() {
            return this.sharedState;
        }

        @Override
        public byte[] sharedStateByteArray() {
            return this.sharedStateByteArray;
        }

        @Override
        public QueryBatchRequestMessage build() {
            return new QueryBatchRequestMessageImpl(this.amountOfBatches, this.exchangeId, this.executionToken, this.fragmentId, Objects.requireNonNull(this.queryId, "queryId is not marked @Nullable"), this.sharedState, this.sharedStateByteArray);
        }
    }
}

