/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.valuemapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.valuemapper.ValueMapper;
import org.apache.hop.pipeline.transforms.valuemapper.ValueMapperData;
import org.apache.hop.pipeline.transforms.valuemapper.Values;

@Transform(id="ValueMapper", image="valuemapper.svg", name="i18n::ValueMapper.Name", description="i18n::ValueMapper.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::ValueMapperMeta.keyword"}, documentationUrl="/pipeline/transforms/valuemapper.html")
public class ValueMapperMeta
extends BaseTransformMeta<ValueMapper, ValueMapperData> {
    private static final Class<?> PKG = ValueMapperMeta.class;
    @HopMetadataProperty(key="field_to_use", injectionKey="FIELDNAME", injectionKeyDescription="ValueMapper.Injection.FIELDNAME")
    private String fieldToUse;
    @HopMetadataProperty(key="target_field", injectionKey="TARGET_FIELDNAME", injectionKeyDescription="ValueMapper.Injection.TARGET_FIELDNAME")
    private String targetField;
    @HopMetadataProperty(key="non_match_default", injectionKey="NON_MATCH_DEFAULT", injectionKeyDescription="ValueMapper.Injection.NON_MATCH_DEFAULT")
    private String nonMatchDefault;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="VALUES", injectionGroupDescription="ValueMapper.Injection.VALUES")
    private List<Values> values = new ArrayList<Values>();

    public ValueMapperMeta() {
    }

    public ValueMapperMeta(ValueMapperMeta meta) {
        this();
        for (Values v : meta.values) {
            this.values.add(new Values(v));
        }
        this.fieldToUse = meta.fieldToUse;
        this.targetField = meta.targetField;
        this.nonMatchDefault = meta.nonMatchDefault;
    }

    public List<Values> getValues() {
        return this.values;
    }

    public void setValues(List<Values> values) {
        this.values = values;
    }

    public Object clone() {
        return new ValueMapperMeta(this);
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValueMetaString extra = null;
        if (!Utils.isEmpty((CharSequence)this.getTargetField())) {
            extra = new ValueMetaString(this.getTargetField());
            int maxlen = -1;
            for (Values v : this.values) {
                if (v.getTarget() == null || v.getTarget().length() <= maxlen) continue;
                maxlen = v.getTarget().length();
            }
            if (this.nonMatchDefault != null && this.nonMatchDefault.length() > maxlen) {
                maxlen = this.nonMatchDefault.length();
            }
            extra.setLength(maxlen);
            extra.setOrigin(name);
            r.addValueMeta((IValueMeta)extra);
        } else if (!Utils.isEmpty((CharSequence)this.getFieldToUse())) {
            extra = r.searchValueMeta(this.getFieldToUse());
        }
        if (extra != null) {
            extra.setStorageType(0);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.isEmpty()) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.NotReceivingFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.ReceivingFieldsFromPreviousTransforms", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ValueMapperMeta.CheckResult.NotReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getFieldToUse() {
        return this.fieldToUse;
    }

    public void setFieldToUse(String fieldToUse) {
        this.fieldToUse = fieldToUse;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public void setTargetField(String targetField) {
        this.targetField = targetField;
    }

    public String getNonMatchDefault() {
        return this.nonMatchDefault;
    }

    public void setNonMatchDefault(String nonMatchDefault) {
        this.nonMatchDefault = nonMatchDefault;
    }
}

