/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.MemberAddV2Result;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class MembersAddJobStatusV2Result {
    public static final MembersAddJobStatusV2Result IN_PROGRESS = new MembersAddJobStatusV2Result().withTag(Tag.IN_PROGRESS);
    public static final MembersAddJobStatusV2Result OTHER = new MembersAddJobStatusV2Result().withTag(Tag.OTHER);
    private Tag _tag;
    private List<MemberAddV2Result> completeValue;
    private String failedValue;

    private MembersAddJobStatusV2Result() {
    }

    private MembersAddJobStatusV2Result withTag(Tag _tag) {
        MembersAddJobStatusV2Result result = new MembersAddJobStatusV2Result();
        result._tag = _tag;
        return result;
    }

    private MembersAddJobStatusV2Result withTagAndComplete(Tag _tag, List<MemberAddV2Result> completeValue) {
        MembersAddJobStatusV2Result result = new MembersAddJobStatusV2Result();
        result._tag = _tag;
        result.completeValue = completeValue;
        return result;
    }

    private MembersAddJobStatusV2Result withTagAndFailed(Tag _tag, String failedValue) {
        MembersAddJobStatusV2Result result = new MembersAddJobStatusV2Result();
        result._tag = _tag;
        result.failedValue = failedValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInProgress() {
        return this._tag == Tag.IN_PROGRESS;
    }

    public boolean isComplete() {
        return this._tag == Tag.COMPLETE;
    }

    public static MembersAddJobStatusV2Result complete(List<MemberAddV2Result> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (MemberAddV2Result x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new MembersAddJobStatusV2Result().withTagAndComplete(Tag.COMPLETE, value);
    }

    public List<MemberAddV2Result> getCompleteValue() {
        if (this._tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this._tag.name());
        }
        return this.completeValue;
    }

    public boolean isFailed() {
        return this._tag == Tag.FAILED;
    }

    public static MembersAddJobStatusV2Result failed(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MembersAddJobStatusV2Result().withTagAndFailed(Tag.FAILED, value);
    }

    public String getFailedValue() {
        if (this._tag != Tag.FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILED, but was Tag." + this._tag.name());
        }
        return this.failedValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.completeValue, this.failedValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MembersAddJobStatusV2Result) {
            MembersAddJobStatusV2Result other = (MembersAddJobStatusV2Result)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case IN_PROGRESS: {
                    return true;
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
                case FAILED: {
                    return this.failedValue == other.failedValue || this.failedValue.equals(other.failedValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MembersAddJobStatusV2Result> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersAddJobStatusV2Result value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case IN_PROGRESS: {
                    g.writeString("in_progress");
                    break;
                }
                case COMPLETE: {
                    g.writeStartObject();
                    this.writeTag("complete", g);
                    g.writeFieldName("complete");
                    StoneSerializers.list(MemberAddV2Result.Serializer.INSTANCE).serialize((List<MemberAddV2Result>)value.completeValue, g);
                    g.writeEndObject();
                    break;
                }
                case FAILED: {
                    g.writeStartObject();
                    this.writeTag("failed", g);
                    g.writeFieldName("failed");
                    StoneSerializers.string().serialize(value.failedValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public MembersAddJobStatusV2Result deserialize(JsonParser p) throws IOException, JsonParseException {
            MembersAddJobStatusV2Result value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("in_progress".equals(tag)) {
                value = IN_PROGRESS;
            } else if ("complete".equals(tag)) {
                List<MemberAddV2Result> fieldValue = null;
                Serializer.expectField("complete", p);
                fieldValue = StoneSerializers.list(MemberAddV2Result.Serializer.INSTANCE).deserialize(p);
                value = MembersAddJobStatusV2Result.complete(fieldValue);
            } else if ("failed".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("failed", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MembersAddJobStatusV2Result.failed(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        IN_PROGRESS,
        COMPLETE,
        FAILED,
        OTHER;

    }
}

