/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.io.util.File;

public class FileOutputStreamPlus
extends BufferedDataOutputStreamPlus {
    public FileOutputStreamPlus(String path) throws NoSuchFileException {
        this(path, File.WriteMode.OVERWRITE);
    }

    public FileOutputStreamPlus(String path, File.WriteMode mode) throws NoSuchFileException {
        this(new File(path), mode);
    }

    public FileOutputStreamPlus(File file) throws NoSuchFileException {
        this(file, File.WriteMode.OVERWRITE);
    }

    public FileOutputStreamPlus(File file, File.WriteMode mode) throws NoSuchFileException {
        super(file.newWriteChannel(mode));
    }

    public FileOutputStreamPlus(Path path) throws NoSuchFileException {
        this(path, File.WriteMode.OVERWRITE);
    }

    public FileOutputStreamPlus(Path path, File.WriteMode mode) throws NoSuchFileException {
        this(new File(path), mode);
    }

    public void sync() throws IOException {
        ((FileChannel)this.channel).force(true);
    }

    public FileChannel getChannel() {
        return (FileChannel)this.channel;
    }
}

