/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.functions.FromJsonFct;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.OperationFcts;
import org.apache.cassandra.cql3.functions.ToJsonFct;
import org.apache.cassandra.cql3.functions.TokenFct;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.Schema;

public final class FunctionResolver {
    private static final FunctionName TOKEN_FUNCTION_NAME = FunctionName.nativeFunction("token");

    private FunctionResolver() {
    }

    public static ColumnSpecification makeArgSpec(String receiverKs, String receiverCf, Function fun, int i) {
        return new ColumnSpecification(receiverKs, receiverCf, new ColumnIdentifier("arg" + i + '(' + fun.name().toString().toLowerCase() + ')', true), fun.argTypes().get(i));
    }

    public static Function get(String keyspace, FunctionName name, List<? extends AssignmentTestable> providedArgs, String receiverKs, String receiverCf, AbstractType<?> receiverType) throws InvalidRequestException {
        Collection<Function> candidates = FunctionResolver.collectCandidates(keyspace, name, receiverKs, receiverCf, receiverType);
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            Function fun = candidates.iterator().next();
            FunctionResolver.validateTypes(keyspace, fun, providedArgs, receiverKs, receiverCf);
            return fun;
        }
        return FunctionResolver.pickBestMatch(keyspace, name, providedArgs, receiverKs, receiverCf, receiverType, candidates);
    }

    private static Collection<Function> collectCandidates(String keyspace, FunctionName name, String receiverKs, String receiverCf, AbstractType<?> receiverType) {
        ArrayList<Function> candidates = new ArrayList<Function>();
        if (name.equalsNativeFunction(TOKEN_FUNCTION_NAME)) {
            candidates.add(new TokenFct(Schema.instance.getTableMetadata(receiverKs, receiverCf)));
        }
        if (name.equalsNativeFunction(ToJsonFct.NAME)) {
            throw new InvalidRequestException("toJson() may only be used within the selection clause of SELECT statements");
        }
        if (name.equalsNativeFunction(FromJsonFct.NAME)) {
            if (receiverType == null) {
                throw new InvalidRequestException("fromJson() cannot be used in the selection clause of a SELECT statement");
            }
            candidates.add(FromJsonFct.getInstance(receiverType));
        }
        if (!name.hasKeyspace()) {
            candidates.addAll(Schema.instance.getFunctions(name.asNativeFunction()));
            candidates.addAll(Schema.instance.getFunctions(new FunctionName(keyspace, name.name)));
        } else {
            candidates.addAll(Schema.instance.getFunctions(name));
        }
        return candidates;
    }

    private static Function pickBestMatch(String keyspace, FunctionName name, List<? extends AssignmentTestable> providedArgs, String receiverKs, String receiverCf, AbstractType<?> receiverType, Collection<Function> candidates) {
        ArrayList<Function> compatibles = null;
        for (Function toTest : candidates) {
            if (!FunctionResolver.matchReturnType(toTest, receiverType)) continue;
            AssignmentTestable.TestResult r = FunctionResolver.matchAguments(keyspace, toTest, providedArgs, receiverKs, receiverCf);
            switch (r) {
                case EXACT_MATCH: {
                    return toTest;
                }
                case WEAKLY_ASSIGNABLE: {
                    if (compatibles == null) {
                        compatibles = new ArrayList<Function>();
                    }
                    compatibles.add(toTest);
                }
            }
        }
        if (compatibles == null) {
            if (OperationFcts.isOperation(name)) {
                throw RequestValidations.invalidRequest("the '%s' operation is not supported between %s and %s", Character.valueOf(OperationFcts.getOperator(name)), providedArgs.get(0), providedArgs.get(1));
            }
            throw RequestValidations.invalidRequest("Invalid call to function %s, none of its type signatures match (known type signatures: %s)", name, FunctionResolver.format(candidates));
        }
        if (compatibles.size() > 1) {
            if (OperationFcts.isOperation(name)) {
                if (receiverType != null && !FunctionResolver.containsMarkers(providedArgs)) {
                    for (Function toTest : compatibles) {
                        List<AbstractType<?>> argTypes = toTest.argTypes();
                        if (!receiverType.equals(argTypes.get(0)) || !receiverType.equals(argTypes.get(1))) continue;
                        return toTest;
                    }
                }
                throw RequestValidations.invalidRequest("Ambiguous '%s' operation with args %s and %s: use type hint to disambiguate, example '(int) ?'", Character.valueOf(OperationFcts.getOperator(name)), providedArgs.get(0), providedArgs.get(1));
            }
            if (OperationFcts.isNegation(name)) {
                throw RequestValidations.invalidRequest("Ambiguous negation: use type casts to disambiguate");
            }
            throw RequestValidations.invalidRequest("Ambiguous call to function %s (can be matched by following signatures: %s): use type casts to disambiguate", name, FunctionResolver.format((Collection<Function>)compatibles));
        }
        return (Function)compatibles.get(0);
    }

    private static boolean containsMarkers(List<? extends AssignmentTestable> args) {
        return args.stream().anyMatch(AbstractMarker.Raw.class::isInstance);
    }

    private static boolean matchReturnType(Function fun, AbstractType<?> receiverType) {
        return receiverType == null || fun.returnType().testAssignment(receiverType.udfType()).isAssignable();
    }

    private static void validateTypes(String keyspace, Function fun, List<? extends AssignmentTestable> providedArgs, String receiverKs, String receiverCf) {
        if (providedArgs.size() != fun.argTypes().size()) {
            throw RequestValidations.invalidRequest("Invalid number of arguments in call to function %s: %d required but %d provided", fun.name(), fun.argTypes().size(), providedArgs.size());
        }
        for (int i = 0; i < providedArgs.size(); ++i) {
            ColumnSpecification expected;
            AssignmentTestable provided = providedArgs.get(i);
            if (provided == null || provided.testAssignment(keyspace, expected = FunctionResolver.makeArgSpec(receiverKs, receiverCf, fun, i)).isAssignable()) continue;
            throw RequestValidations.invalidRequest("Type error: %s cannot be passed as argument %d of function %s of type %s", provided, i, fun.name(), expected.type.asCQL3Type());
        }
    }

    private static AssignmentTestable.TestResult matchAguments(String keyspace, Function fun, List<? extends AssignmentTestable> providedArgs, String receiverKs, String receiverCf) {
        if (providedArgs.size() != fun.argTypes().size()) {
            return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
        }
        AssignmentTestable.TestResult res = AssignmentTestable.TestResult.EXACT_MATCH;
        for (int i = 0; i < providedArgs.size(); ++i) {
            AssignmentTestable provided = providedArgs.get(i);
            if (provided == null) {
                res = AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                continue;
            }
            ColumnSpecification expected = FunctionResolver.makeArgSpec(receiverKs, receiverCf, fun, i);
            AssignmentTestable.TestResult argRes = provided.testAssignment(keyspace, expected);
            if (argRes == AssignmentTestable.TestResult.NOT_ASSIGNABLE) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            if (argRes != AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE) continue;
            res = AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        return res;
    }

    private static String format(Collection<Function> funs) {
        return funs.stream().map(Object::toString).collect(Collectors.joining(", "));
    }
}

