/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.AS400JDBCSQLXMLLocator;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLLocatorBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBlobLocator
extends SQLLocatorBase {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private SQLConversionSettings settings_;
    private int truncated_;
    private boolean outOfBounds_ = false;
    private int columnIndex_;
    private byte[] value_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;
    private Object savedValue_;
    private boolean inputStreamRead_ = false;

    SQLBlobLocator(AS400JDBCConnection connection, int id, int maxLength, SQLConversionSettings settings, ConvTable converter, int columnIndex) {
        this.connection_ = connection;
        this.id_ = id;
        this.locator_ = new JDLobLocator(connection, id, maxLength, false);
        this.maxLength_ = maxLength == 0 ? Integer.MAX_VALUE : maxLength;
        this.settings_ = settings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.converter_ = converter;
        this.columnIndex_ = columnIndex;
    }

    @Override
    public Object clone() {
        return new SQLBlobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    @Override
    public void setHandle(int handle) {
        this.locator_.setHandle(handle);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
        this.value_ = null;
        this.savedValue_ = null;
    }

    @Override
    public int getHandle() {
        return this.locator_.getHandle();
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable converter) throws SQLException {
        this.convertFromRawBytes(rawBytes, offset, converter, false);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int locatorHandle = BinaryConverter.byteArrayToInt(rawBytes, offset);
        this.locator_.setHandle(locatorHandle);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
        this.value_ = null;
        this.savedValue_ = null;
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), rawBytes, offset);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null || this.value_ != null) {
            this.writeToServer();
        }
    }

    @Override
    public void validateRawTruncatedData(byte[] rawBytes, int offset, ConvTable ccsidConverter) {
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            this.truncated_ = bytes.length > this.maxLength_ ? bytes.length - this.maxLength_ : 0;
        } else if (object instanceof String) {
            byte[] bytes = null;
            try {
                bytes = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
            }
            object = bytes;
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        } else if (object instanceof Reader) {
            object = new HexReaderInputStream((Reader)object);
        } else if (!(object instanceof String || object instanceof Blob || object instanceof Reader || object instanceof InputStream)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.savedObjectWrittenToServer_ = false;
        if (scale != -1) {
            this.scale_ = scale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        Object object = this.savedObject_;
        if (object instanceof byte[]) {
            this.value_ = (byte[])object;
            int objectLength = this.value_.length;
            if (this.value_.length > this.maxLength_) {
                byte[] newValue = new byte[this.maxLength_];
                System.arraycopy(this.value_, 0, newValue, 0, this.maxLength_);
                this.value_ = newValue;
            }
            this.truncated_ = objectLength - this.value_.length;
        } else if (object instanceof Blob) {
            int blobLength;
            int lengthToUse;
            Blob blob;
            if (this.savedObject_ instanceof AS400JDBCBlobLocator) {
                Blob newValue = blob = (AS400JDBCBlobLocator)this.savedObject_;
                synchronized (newValue) {
                    if (((AS400JDBCBlobLocator)blob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCBlobLocator)blob).savedObject_;
                        this.savedObjectWrittenToServer_ = false;
                        this.scale_ = ((AS400JDBCBlobLocator)blob).savedScale_;
                        ((AS400JDBCBlobLocator)blob).savedObject_ = null;
                        if (!(this.savedObject_ instanceof AS400JDBCBlobLocator)) {
                            this.doConversion();
                            return;
                        }
                    }
                }
            }
            int n = lengthToUse = (blobLength = (int)(blob = (Blob)object).length()) < 0 ? Integer.MAX_VALUE : blobLength;
            if (lengthToUse > this.maxLength_) {
                lengthToUse = this.maxLength_;
            }
            this.value_ = blob.getBytes(1L, lengthToUse);
            this.truncated_ = blobLength - lengthToUse;
        } else if (object instanceof InputStream) {
            if (!this.inputStreamRead_) {
                int length = this.scale_;
                if (length >= 0) {
                    this.value_ = SQLBlobLocator.readInputStream((InputStream)object, length, null, false);
                    if (this.value_.length < length) {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    int objectLength = this.value_.length;
                    if (this.value_.length > this.maxLength_) {
                        byte[] newValue = new byte[this.maxLength_];
                        System.arraycopy(this.value_, 0, newValue, 0, this.maxLength_);
                        this.value_ = newValue;
                    }
                    this.truncated_ = objectLength - this.value_.length;
                } else if (length == -2) {
                    this.value_ = SQLBlobLocator.readInputStream((InputStream)object, length, null, false);
                    this.inputStreamRead_ = true;
                    int objectLength = this.value_.length;
                    if (this.value_.length > this.maxLength_) {
                        byte[] newValue = new byte[this.maxLength_];
                        System.arraycopy(this.value_, 0, newValue, 0, this.maxLength_);
                        this.value_ = newValue;
                    }
                    this.truncated_ = objectLength - this.value_.length;
                } else {
                    JDError.throwSQLException("07006");
                }
            }
        } else {
            JDError.throwSQLException("07006");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToServer() throws SQLException {
        if (this.value_ != null) {
            this.locator_.writeData(0L, this.value_, true);
        } else if (this.savedObject_ instanceof byte[]) {
            byte[] bytes = (byte[])this.savedObject_;
            this.locator_.writeData(0L, bytes, true);
        } else if (this.savedObject_ instanceof InputStream) {
            int length = this.scale_;
            if (length == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (length > 0) {
                this.value_ = SQLBlobLocator.readInputStream((InputStream)this.savedObject_, length, this.locator_, false);
                if (this.value_.length < length) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (length == -2) {
                this.value_ = SQLBlobLocator.readInputStream((InputStream)this.savedObject_, length, this.locator_, false);
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (this.savedObject_ instanceof Blob) {
            Blob blob;
            boolean set = false;
            if (this.savedObject_ instanceof AS400JDBCBlobLocator) {
                blob = (AS400JDBCBlobLocator)this.savedObject_;
                AS400JDBCBlobLocator aS400JDBCBlobLocator = blob;
                synchronized (aS400JDBCBlobLocator) {
                    if (((AS400JDBCBlobLocator)blob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCBlobLocator)blob).savedObject_;
                        this.savedObjectWrittenToServer_ = false;
                        this.scale_ = ((AS400JDBCBlobLocator)blob).savedScale_;
                        ((AS400JDBCBlobLocator)blob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!set) {
                blob = (Blob)this.savedObject_;
                int length = (int)blob.length();
                byte[] data = blob.getBytes(1L, length);
                this.locator_.writeData(0L, data, 0, length, true);
            }
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    @Override
    public int getSQLType() {
        return 4;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        return this.maxLength_;
    }

    @Override
    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCBlobLocator";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "BLOB";
    }

    @Override
    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 960;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 2004;
    }

    @Override
    public String getTypeName() {
        return "BLOB";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.maxLength_;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public void clearTruncated() {
        this.truncated_ = 0;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCInputStream(new JDLobLocator(this.locator_));
    }

    @Override
    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCBlob(this.value_, this.maxLength_);
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCBlobLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        int locatorLength = (int)this.locator_.getLength();
        if (locatorLength == 0) {
            return new byte[0];
        }
        DBLobData data = this.locator_.retrieveData(0L, locatorLength);
        int actualLength = data.getLength();
        byte[] bytes = new byte[actualLength];
        System.arraycopy(data.getRawBytes(), data.getOffset(), bytes, 0, actualLength);
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return bytes;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    @Override
    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCClob(string, string.length());
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCBlobLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    @Override
    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    @Override
    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCNClob(string, string.length());
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCSQLXML(this.value_, (long)this.value_.length);
        }
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCSQLXMLLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    @Override
    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void updateSettings(SQLConversionSettings settings) {
        this.settings_ = settings;
    }

    @Override
    public void saveValue() throws SQLException {
        if (this.value_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }

    @Override
    public Object getSavedValue() {
        return this.savedValue_;
    }
}

