/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPData;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.NPCPSplFHandle;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObjectTransformedInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.SpooledFileImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class PrintObjectTransformedInputStreamImplRemote
implements PrintObjectTransformedInputStreamImpl {
    private NPConversation conversation_;
    private NPCPAttribute cpCPFMsg_;
    private NPCodePoint cpObjHndl_;
    private NPCPID cpObjID_;
    private NPSystem npSystem_;
    private int numBytes_ = 0;
    private int objectType_;
    private int offset_ = 0;
    private boolean cidConv = false;
    private String convSource = null;
    private String convTarget = null;

    PrintObjectTransformedInputStreamImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createPrintObjectTransformedInputStream(SpooledFileImpl spooledFile, PrintParameterList transformOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        AS400ImplRemote system = ((SpooledFileImplRemote)spooledFile).getSystem();
        int ccsid = system.getCcsid();
        this.objectType_ = 1;
        this.npSystem_ = NPSystem.getSystem(((SpooledFileImplRemote)spooledFile).getSystem());
        this.cpObjID_ = ((SpooledFileImplRemote)spooledFile).getIDCodePoint();
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjHndl_ = new NPCPSplFHandle();
        NPDataStream openReq = new NPDataStream(this.objectType_);
        openReq.setAction(26);
        openReq.addCodePoint(this.cpObjID_);
        NPCPSelection selectionCP = new NPCPSelection();
        if (transformOptions != null) {
            selectionCP.addUpdateAttributes(transformOptions.getAttrCodePoint());
            String tempTarget = transformOptions.getStringParameter(264);
            if (tempTarget != null) {
                this.cidConv = true;
                this.convTarget = tempTarget.replace('P', 'p');
                switch (ccsid) {
                    case 37: 
                    case 836: {
                        this.convSource = "Cp437";
                        break;
                    }
                    case 420: {
                        this.convSource = "Cp864";
                        break;
                    }
                    case 423: {
                        this.convSource = "Cp1253";
                        break;
                    }
                    case 424: {
                        this.convSource = "Cp856";
                        break;
                    }
                    case 838: 
                    case 1130: 
                    case 1132: 
                    case 1164: {
                        this.convSource = "Cp874";
                        break;
                    }
                    case 870: {
                        this.convSource = "Cp852";
                        break;
                    }
                    case 875: {
                        this.convSource = "Cp869";
                        break;
                    }
                    case 905: 
                    case 1026: {
                        this.convSource = "Cp857";
                        break;
                    }
                    case 1097: {
                        this.convSource = "Cp1097";
                        break;
                    }
                    case 1112: {
                        this.convSource = "Cp921";
                        break;
                    }
                    case 1122: {
                        this.convSource = "Cp922";
                        break;
                    }
                    case 1153: {
                        this.convSource = "Cp1250";
                        break;
                    }
                    case 1154: 
                    case 1158: {
                        this.convSource = "Cp1251";
                        break;
                    }
                    case 1155: {
                        this.convSource = "Cp1254";
                        break;
                    }
                    case 1156: 
                    case 1157: {
                        this.convSource = "Cp1257";
                        break;
                    }
                    case 1160: {
                        this.convSource = "Cp874";
                        break;
                    }
                    case 1390: 
                    case 1399: 
                    case 5026: 
                    case 5035: {
                        this.convSource = "Cp942";
                        break;
                    }
                    case 933: 
                    case 1364: {
                        this.convSource = "Cp949";
                        break;
                    }
                    case 937: 
                    case 1371: 
                    case 1388: {
                        this.convSource = "Cp950";
                        break;
                    }
                    case 935: {
                        this.convSource = "Cp1381";
                        break;
                    }
                    default: {
                        this.convSource = "Cp850";
                    }
                }
                transformOptions.setParameter(263, this.convSource);
            }
        }
        openReq.addCodePoint(selectionCP);
        NPDataStream openRep = new NPDataStream(this.objectType_);
        openRep.addCodePoint(this.cpObjHndl_);
        openRep.addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean fOpenOK = false;
        try {
            int rc = this.conversation_.makeRequest(openReq, openRep);
            if (rc != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + rc);
                throw new ErrorCompletingRequestException(1);
            }
            this.retrieveNumberOfBytes();
            fOpenOK = true;
        }
        finally {
            if (!fOpenOK) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
    }

    @Override
    public int available() throws IOException {
        return this.numBytes_ - this.offset_;
    }

    @Override
    public void close() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream closeReq = new NPDataStream(this.objectType_);
        closeReq.setAction(5);
        closeReq.addCodePoint(this.cpObjHndl_);
        NPDataStream closeRep = new NPDataStream(this.objectType_);
        closeRep.addCodePoint(this.cpCPFMsg_);
        try {
            int rc = this.conversation_.makeRequest(closeReq, closeRep);
            if (rc != 0) {
                Trace.log(2, "Error closing SpooledFile; rc = " + rc);
                this.npSystem_.returnConversation(this.conversation_);
            }
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
        finally {
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.conversation_ != null) {
            NPDataStream closeReq = new NPDataStream(this.objectType_);
            closeReq.setAction(5);
            closeReq.addCodePoint(this.cpObjHndl_);
            AS400Server server = this.conversation_.getServer();
            if (server != null) {
                closeReq.setConverter(this.conversation_.getConverter());
                server.sendAndDiscardReply(closeReq);
            }
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
        super.finalize();
    }

    @Override
    public int read(byte[] data, int dataOffset, int length) throws IOException {
        int bytesRead = 0;
        int bytesToRead = 0;
        Integer sizeTarget = data.length;
        byte[] dataSource = new byte[length];
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPCPAttribute cpAttr = new NPCPAttribute();
        cpAttr.setAttrValue(125, length);
        NPDataStream readReq = new NPDataStream(this.objectType_);
        readReq.setAction(3);
        readReq.addCodePoint(this.cpObjHndl_);
        readReq.addCodePoint(cpAttr);
        NPCPData cpData = new NPCPData();
        cpData.setDataBuffer(data, 0, dataOffset);
        NPDataStream readRep = new NPDataStream(this.objectType_);
        readRep.addCodePoint(cpData);
        readRep.addCodePoint(this.cpCPFMsg_);
        try {
            int iRC = this.conversation_.makeRequest(readReq, readRep);
            if (this.cidConv) {
                String convString = new String(data, dataOffset, length, this.convSource);
                dataSource = convString.getBytes(this.convTarget);
                Integer sizeSource = dataSource.length;
                bytesToRead = sizeSource.compareTo(sizeTarget) >= 0 ? sizeTarget.intValue() : sizeSource.intValue();
                System.arraycopy(dataSource, 0, data, 0, bytesToRead);
            }
            switch (iRC) {
                case 0: 
                case 18: {
                    bytesRead = cpData.getDataLength();
                    this.offset_ += bytesRead;
                    if (readRep.get32bit(22) == 0x20000000) {
                        this.retrieveNumberOfBytes();
                        this.offset_ = 0;
                    }
                    break;
                }
                case 19: {
                    bytesRead = -1;
                    break;
                }
                default: {
                    Trace.log(2, "Error received on read : " + Integer.toString(iRC));
                    throw new IOException(Integer.toString(iRC));
                }
            }
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
        return bytesRead;
    }

    private void retrieveNumberOfBytes() throws IOException, RequestNotSupportedException {
        NPCPAttributeIDList cpAttrsToRetrieve = new NPCPAttributeIDList();
        cpAttrsToRetrieve.addAttrID(125);
        NPDataStream tellReq = new NPDataStream(this.objectType_);
        tellReq.addCodePoint(this.cpObjHndl_);
        tellReq.addCodePoint(cpAttrsToRetrieve);
        tellReq.setAction(24);
        NPDataStream tellRep = new NPDataStream(this.objectType_);
        NPCPAttribute cpAttrs = new NPCPAttribute();
        tellRep.addCodePoint(cpAttrs);
        try {
            Integer numBytes;
            int rc = this.conversation_.makeRequest(tellReq, tellRep);
            if (rc == 0) {
                numBytes = cpAttrs.getIntValue(125);
                if (numBytes == null) {
                    Trace.log(2, "Network Print Server does not support retrieving data block length.");
                    throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
                }
            } else {
                Trace.log(2, "Network Print Server error retrieving data block length. RC =" + rc);
                throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
            }
            this.numBytes_ = numBytes;
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
    }

    private void seekFromCur(int offset) throws IOException {
        NPCPAttribute cpAttr = new NPCPAttribute();
        cpAttr.setAttrValue(127, 2);
        cpAttr.setAttrValue(126, offset);
        NPDataStream seekReq = new NPDataStream(this.objectType_);
        seekReq.setAction(23);
        seekReq.addCodePoint(this.cpObjHndl_);
        seekReq.addCodePoint(cpAttr);
        NPDataStream seekRep = new NPDataStream(this.objectType_);
        seekRep.addCodePoint(this.cpCPFMsg_);
        try {
            int iRC = this.conversation_.makeRequest(seekReq, seekRep);
            switch (iRC) {
                case 0: {
                    this.offset_ += offset;
                    break;
                }
                default: {
                    Trace.log(2, "Seek from cur error " + Integer.toString(iRC));
                    throw new IOException(Integer.toString(iRC));
                }
            }
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        int maxSkip = this.numBytes_ - this.offset_;
        if (bytesToSkip > (long)maxSkip) {
            bytesToSkip = maxSkip;
        }
        this.seekFromCur((int)bytesToSkip);
        return bytesToSkip;
    }
}

