/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandraoutput;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.databases.cassandra.datastax.DriverConnection;
import org.apache.hop.databases.cassandra.datastax.DriverCqlRowHandler;
import org.apache.hop.databases.cassandra.metadata.CassandraConnection;
import org.apache.hop.databases.cassandra.spi.CqlRowHandler;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.CassandraUtils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cassandraoutput.CassandraOutputData;
import org.apache.hop.pipeline.transforms.cassandraoutput.CassandraOutputMeta;

public class CassandraOutput
extends BaseTransform<CassandraOutputMeta, CassandraOutputData> {
    protected CqlRowHandler cqlHandler = null;
    protected ITableMetaData cassandraMeta;
    protected StringBuilder batchInsertCql;
    protected List<Object[]> batch;
    protected int rowsSeen;
    protected int batchSize = 100;
    protected String consistency = null;
    protected String tableName;
    protected String keyspaceName;
    protected List<Integer> keyIndexes = null;
    protected int cqlBatchInsertTimeout = 0;
    protected int batchSplitFactor = 10;
    protected String consistencyLevel;
    protected Map<String, String> options;

    public CassandraOutput(TransformMeta transformMeta, CassandraOutputMeta meta, CassandraOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws HopException {
        this.rowsSeen = 0;
        String connectionName = this.resolve(((CassandraOutputMeta)this.getMeta()).getConnectionName());
        if (StringUtils.isEmpty((String)connectionName)) {
            throw new HopException("Please specify a Cassandra connection to use");
        }
        CassandraConnection cassandraConnection = (CassandraConnection)this.metadataProvider.getSerializer(CassandraConnection.class).load(connectionName);
        if (cassandraConnection == null) {
            throw new HopException("Cassandra connection '" + connectionName + "' couldn't be found in the metadata");
        }
        String batchTimeoutS = this.resolve(((CassandraOutputMeta)this.getMeta()).getCqlBatchInsertTimeout());
        String batchSplitFactor = this.resolve(((CassandraOutputMeta)this.getMeta()).getBatchSize());
        this.keyspaceName = this.resolve(cassandraConnection.getKeyspace());
        this.tableName = CassandraUtils.cql3MixedCaseQuote(this.resolve(((CassandraOutputMeta)this.getMeta()).getTableName()));
        this.consistencyLevel = this.resolve(((CassandraOutputMeta)this.getMeta()).getConsistency());
        String keyField = this.resolve(((CassandraOutputMeta)this.getMeta()).getKeyField());
        try {
            if (!Utils.isEmpty((CharSequence)batchTimeoutS)) {
                try {
                    this.cqlBatchInsertTimeout = Integer.parseInt(batchTimeoutS);
                    if (this.cqlBatchInsertTimeout < 500) {
                        this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.MinimumTimeout", (String[])new String[0]));
                        this.cqlBatchInsertTimeout = 500;
                    }
                }
                catch (NumberFormatException e) {
                    this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseTimeout", (String[])new String[0]));
                    this.cqlBatchInsertTimeout = 10000;
                }
            }
            if (!Utils.isEmpty((CharSequence)batchSplitFactor)) {
                try {
                    this.batchSplitFactor = Integer.parseInt(batchSplitFactor);
                }
                catch (NumberFormatException e) {
                    this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseSubBatchSize", (String[])new String[0]));
                }
            }
            if (Utils.isEmpty((CharSequence)this.keyspaceName)) {
                throw new HopException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.MissingConnectionDetails", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)this.tableName)) {
                throw new HopException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NoTableSpecified", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)keyField)) {
                throw new HopException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NoIncomingKeySpecified", (String[])new String[0]));
            }
            String[] keyParts = keyField.split(",");
            this.keyIndexes = new ArrayList<Integer>();
            for (String keyPart : keyParts) {
                int index = this.getInputRowMeta().indexOfValue(keyPart.trim());
                if (index < 0) {
                    throw new HopException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantFindKeyField", (String[])new String[]{keyField}));
                }
                this.keyIndexes.add(index);
            }
            this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.ConnectingForSchemaOperations", (String[])new String[]{cassandraConnection.getSchemaHostname(), cassandraConnection.getSchemaPort(), this.keyspaceName}));
            DriverConnection connection = null;
            try {
                connection = cassandraConnection.createConnection((IVariables)this, true);
                connection.open();
                Keyspace keyspace = connection.getKeyspace(this.keyspaceName);
                if (!keyspace.tableExists(this.tableName)) {
                    if (((CassandraOutputMeta)this.getMeta()).isCreateTable()) {
                        boolean result = keyspace.createTable(this.tableName, this.getInputRowMeta(), this.keyIndexes, this.resolve(((CassandraOutputMeta)this.getMeta()).getCreateTableWithClause()), this.getLogChannel());
                        if (!result) {
                            throw new HopException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NeedAtLeastOneFieldAppartFromKey", (String[])new String[0]));
                        }
                        keyspace = connection.getKeyspace(this.keyspaceName);
                    } else {
                        throw new HopException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.TableDoesNotExist", (String[])new String[]{this.tableName, this.keyspaceName}));
                    }
                }
                if (((CassandraOutputMeta)this.getMeta()).isUpdateCassandraMeta()) {
                    keyspace.updateTableCQL3(this.tableName, this.getInputRowMeta(), this.keyIndexes, this.getLogChannel());
                }
                this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.GettingMetaData", (String[])new String[]{this.tableName}));
                this.cassandraMeta = keyspace.getTableMetaData(this.tableName);
                ((CassandraOutputData)this.data).outputRowMeta = this.getInputRowMeta();
                String batchSize = this.resolve(((CassandraOutputMeta)this.getMeta()).getBatchSize());
                if (!Utils.isEmpty((CharSequence)batchSize)) {
                    try {
                        this.batchSize = Integer.parseInt(batchSize);
                    }
                    catch (NumberFormatException e) {
                        this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseBatchSize", (String[])new String[0]));
                        this.batchSize = 100;
                    }
                } else {
                    throw new HopException(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.NoBatchSizeSet", (String[])new String[0]));
                }
                if (((CassandraOutputMeta)this.getMeta()).isTruncateTable()) {
                    keyspace.truncateTable(this.tableName, this.getLogChannel());
                }
            }
            finally {
                if (connection != null) {
                    this.closeConnection(connection);
                    ((CassandraOutputData)this.data).connection = null;
                }
            }
            this.consistency = this.resolve(((CassandraOutputMeta)this.getMeta()).getConsistency());
            this.batchInsertCql = CassandraUtils.newCQLBatch(this.batchSize, ((CassandraOutputMeta)this.getMeta()).isUseUnloggedBatch());
            this.batch = new ArrayList<Object[]>();
            this.openConnection(false);
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.InitializationProblem", (String[])new String[0]), ex);
        }
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.rowsSeen > 0 && !this.isStopped()) {
                this.doBatch();
            }
            this.batchInsertCql = null;
            this.batch = null;
            this.closeConnection(((CassandraOutputData)this.data).connection);
            ((CassandraOutputData)this.data).connection = null;
            ((CassandraOutputData)this.data).keyspace = null;
            this.cqlHandler = null;
            this.setOutputDone();
            return false;
        }
        if (!this.isStopped()) {
            if (this.first) {
                this.first = false;
                this.initialize();
            }
            this.batch.add(r);
            ++this.rowsSeen;
            if (this.rowsSeen == this.batchSize) {
                this.doBatch();
            }
        } else {
            this.closeConnection(((CassandraOutputData)this.data).connection);
            return false;
        }
        return true;
    }

    protected void doBatch() throws HopException {
        try {
            this.doBatch(this.batch);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CommitFailed", (Object[])new Object[]{this.batchInsertCql.toString(), e}));
            throw new HopException(e.fillInStackTrace());
        }
        this.batch.clear();
        this.rowsSeen = 0;
    }

    protected void doBatch(List<Object[]> batch) throws Exception {
        if (this.isStopped()) {
            this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.StoppedSkippingBatch", (String[])new String[0]));
            return;
        }
        if (Utils.isEmpty(batch)) {
            this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.SkippingEmptyBatch", (String[])new String[0]));
            return;
        }
        int size = batch.size();
        try {
            this.batchInsertCql = CassandraUtils.newCQLBatch(this.batchSize, ((CassandraOutputMeta)this.getMeta()).isUseUnloggedBatch());
            int rowsAdded = 0;
            batch = CassandraUtils.fixBatchMismatchedTypes(batch, this.getInputRowMeta(), this.cassandraMeta);
            DriverCqlRowHandler handler = (DriverCqlRowHandler)this.cqlHandler;
            this.validateTtlField(handler, this.options.get("TTL"));
            handler.setUnloggedBatch(((CassandraOutputMeta)this.getMeta()).isUseUnloggedBatch());
            handler.batchInsert(this.getInputRowMeta(), batch, this.cassandraMeta, this.consistencyLevel, ((CassandraOutputMeta)this.getMeta()).isInsertFieldsNotInMeta());
            if (((CassandraOutputData)this.data).connection == null) {
                this.openConnection(false);
            }
            this.logDetailed(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.CommittingBatch", (String[])new String[]{this.tableName, "" + rowsAdded}));
        }
        catch (Exception e) {
            ArrayList<Object[]> subBatch;
            this.logError(e.getLocalizedMessage(), e);
            this.setErrors(this.getErrors() + 1L);
            this.closeConnection(((CassandraOutputData)this.data).connection);
            ((CassandraOutputData)this.data).connection = null;
            this.logDetailed(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.FailedToInsertBatch", (String[])new String[]{"" + size}), new Object[]{e});
            this.logDetailed(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.WillNowTrySplittingIntoSubBatches", (String[])new String[0]));
            if (size == 1) {
                if (this.getTransformMeta().isDoingErrorHandling()) {
                    this.putError(this.getInputRowMeta(), batch.get(0), 1L, e.getMessage(), null, "ERR_INSERT01");
                }
            }
            if (size > this.batchSplitFactor) {
                subBatch = new ArrayList<Object[]>();
                while (batch.size() > this.batchSplitFactor) {
                    while (subBatch.size() < this.batchSplitFactor && !batch.isEmpty()) {
                        subBatch.add(batch.remove(batch.size() - 1));
                    }
                    this.doBatch(subBatch);
                    subBatch.clear();
                }
                this.doBatch(batch);
            }
            subBatch = new ArrayList();
            while (!batch.isEmpty()) {
                subBatch.clear();
                subBatch.add(batch.remove(batch.size() - 1));
                this.doBatch(subBatch);
            }
        }
        for (Object[] row : batch) {
            this.putRow(this.getInputRowMeta(), row);
        }
    }

    @VisibleForTesting
    void validateTtlField(DriverCqlRowHandler handler, String ttl) {
        if (!Utils.isEmpty((CharSequence)ttl)) {
            try {
                handler.setTtlSec(Integer.parseInt(ttl));
            }
            catch (NumberFormatException e) {
                this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseTTL", (String[])new String[]{ttl}));
            }
        }
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
    }

    protected DriverConnection openConnection(boolean forSchemaChanges) throws HopException {
        String connectionName = this.resolve(((CassandraOutputMeta)this.meta).getConnectionName());
        if (StringUtils.isEmpty((String)connectionName)) {
            throw new HopException("Please specify a Cassandra connection to use");
        }
        CassandraConnection cassandraConnection = (CassandraConnection)this.metadataProvider.getSerializer(CassandraConnection.class).load(connectionName);
        if (cassandraConnection == null) {
            throw new HopException("Cassandra connection '" + connectionName + "' couldn't be found in the metadata");
        }
        this.options = cassandraConnection.getOptionsMap((IVariables)this);
        this.options.put("batchTimeout", "" + this.cqlBatchInsertTimeout);
        this.setTTLIfSpecified();
        if (!this.options.isEmpty()) {
            this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.UsingConnectionOptions", (String[])new String[]{CassandraUtils.optionsToString(this.options)}));
        }
        String hostS = this.resolve(cassandraConnection.getHostname());
        String portS = this.resolve(cassandraConnection.getPort());
        String localDS = this.resolve(cassandraConnection.getLocalDataCenter());
        String userS = this.resolve(cassandraConnection.getUsername());
        String passS = this.resolve(cassandraConnection.getPassword());
        String schemaHostS = this.resolve(((CassandraOutputMeta)this.getMeta()).getSchemaHost());
        String schemaPortS = this.resolve(((CassandraOutputMeta)this.getMeta()).getSchemaPort());
        if (Utils.isEmpty((CharSequence)schemaHostS)) {
            schemaHostS = hostS;
        }
        if (Utils.isEmpty((CharSequence)schemaPortS)) {
            schemaPortS = portS;
        }
        String actualHostToUse = forSchemaChanges ? schemaHostS : hostS;
        String actualPortToUse = forSchemaChanges ? schemaPortS : portS;
        DriverConnection connection = null;
        try {
            connection = CassandraUtils.getCassandraConnection(actualHostToUse, Const.toInt((String)actualPortToUse, (int)-1), localDS, userS, passS, this.options);
            if (!forSchemaChanges) {
                ((CassandraOutputData)this.data).connection = connection;
                ((CassandraOutputData)this.data).keyspace = ((CassandraOutputData)this.data).connection.getKeyspace(this.keyspaceName);
                this.cqlHandler = ((CassandraOutputData)this.data).keyspace.getCQLRowHandler();
            }
        }
        catch (Exception ex) {
            this.closeConnection(connection);
            throw new HopException(ex.getMessage(), (Throwable)ex);
        }
        return connection;
    }

    @VisibleForTesting
    void setTTLIfSpecified() {
        String ttl = ((CassandraOutputMeta)this.getMeta()).getTtl();
        if (!Utils.isEmpty((CharSequence)(ttl = this.resolve(ttl))) && !ttl.startsWith("-")) {
            CassandraOutputMeta.TtlUnits ttlUnit = ((CassandraOutputMeta)this.getMeta()).getTtlUnit();
            long value = -1L;
            try {
                value = Integer.parseInt(ttl);
                value = ttlUnit.convertToSeconds((int)value);
                this.options.put("TTL", "" + value);
            }
            catch (NumberFormatException e) {
                this.logDebug(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Error.CantParseTTL", (String[])new String[]{ttl}));
            }
        }
    }

    public void dispose() {
        try {
            this.closeConnection(((CassandraOutputData)this.data).connection);
        }
        catch (HopException e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    protected void closeConnection(DriverConnection conn) throws HopException {
        if (conn != null) {
            this.logBasic(BaseMessages.getString(CassandraOutputMeta.PKG, (String)"CassandraOutput.Message.ClosingConnection", (String[])new String[0]));
            try {
                conn.close();
            }
            catch (Exception e) {
                throw new HopException((Throwable)e);
            }
        }
    }
}

