/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;

public class JsonUtil {
    private static final ObjectReader jsonReader = ((JsonMapper)JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES}).build()).reader();
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static ObjectReader jsonReader() {
        return jsonReader;
    }

    public static ObjectMapper jsonMapper() {
        return jsonMapper;
    }

    public static JsonNode parse(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return jsonReader.readTree(bytes);
    }

    public static JsonNode parse(CharSequence text) throws JsonProcessingException {
        if (text == null) {
            return null;
        }
        return jsonReader.readTree(text.toString());
    }

    public static JsonNode parse(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return jsonReader.readTree(in);
    }

    public static JsonNode parseTextValue(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            byte[] b = (byte[])value;
            return JsonUtil.parse(b);
        }
        if (value instanceof CharSequence) {
            CharSequence cs = (CharSequence)value;
            return JsonUtil.parse(cs);
        }
        if (value instanceof InputStream) {
            InputStream is = (InputStream)value;
            return JsonUtil.parse(is);
        }
        return JsonUtil.parse(value.toString());
    }

    public static JsonNode mapObjectToJson(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JsonNode) {
            JsonNode node = (JsonNode)object;
            return node;
        }
        return jsonMapper.valueToTree(object);
    }

    public static String mapJsonToString(JsonNode jsonNode, boolean prettyPrinting) throws JsonProcessingException {
        if (jsonNode == null) {
            return null;
        }
        if (prettyPrinting) {
            return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        return jsonMapper.writeValueAsString((Object)jsonNode);
    }

    public static byte[] mapJsonToBytes(JsonNode jsonNode) throws JsonProcessingException {
        if (jsonNode == null) {
            return null;
        }
        return jsonMapper.writeValueAsBytes((Object)jsonNode);
    }
}

