/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodbinput;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.mongo.wrapper.field.MongoField;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mongodb.MongoDbMeta;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInput;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputData;
import org.w3c.dom.Node;

@Transform(id="MongoDbInput", image="mongodb-input.svg", name="i18n::MongoDbInput.Name", description="i18n::MongoDbInput.Description", documentationUrl="/pipeline/transforms/mongodbinput.html", keywords={"i18n::MongoDbInputMeta.keyword"}, categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input")
@InjectionSupported(localizationPrefix="MongoDbInput.Injection.", groups={"FIELDS"})
public class MongoDbInputMeta
extends MongoDbMeta<MongoDbInput, MongoDbInputData> {
    protected static final Class<?> PKG = MongoDbInputMeta.class;
    public static final String CONST_FIELDS = "mongo_fields";
    public static final String CONST_SPACES = "\n        ";
    public static final String CONST_FIELD = "mongo_field";
    @Injection(name="JSON_OUTPUT_FIELD")
    private String jsonFieldName;
    @Injection(name="JSON_FIELD")
    private String jsonField;
    @Injection(name="JSON_QUERY")
    private String jsonQuery;
    @Injection(name="AGG_PIPELINE")
    private boolean aggPipeline = false;
    @Injection(name="OUTPUT_JSON")
    private boolean outputJson = true;
    @InjectionDeep
    private List<MongoField> fields;
    @Injection(name="EXECUTE_FOR_EACH_ROW")
    private boolean executeForEachIncomingRow = false;

    public void setMongoFields(List<MongoField> fields) {
        this.fields = fields;
    }

    public List<MongoField> getMongoFields() {
        return this.fields;
    }

    public void setExecuteForEachIncomingRow(boolean e) {
        this.executeForEachIncomingRow = e;
    }

    public boolean getExecuteForEachIncomingRow() {
        return this.executeForEachIncomingRow;
    }

    public void loadXml(Node node, IHopMetadataProvider metaStore) throws HopXmlException {
        try {
            Node mongoFields;
            String executeForEachR;
            String queryIsPipe;
            this.connectionName = XmlHandler.getTagValue((Node)node, (String)"connection");
            this.jsonField = XmlHandler.getTagValue((Node)node, (String)"fields_name");
            this.collection = XmlHandler.getTagValue((Node)node, (String)"collection");
            this.jsonFieldName = XmlHandler.getTagValue((Node)node, (String)"json_field_name");
            this.jsonQuery = XmlHandler.getTagValue((Node)node, (String)"json_query");
            this.outputJson = true;
            String outputJson = XmlHandler.getTagValue((Node)node, (String)"output_json");
            if (!StringUtils.isEmpty((String)outputJson)) {
                this.outputJson = outputJson.equalsIgnoreCase("Y");
            }
            if (!StringUtils.isEmpty((String)(queryIsPipe = XmlHandler.getTagValue((Node)node, (String)"query_is_pipeline")))) {
                this.aggPipeline = queryIsPipe.equalsIgnoreCase("Y");
            }
            if (!StringUtils.isEmpty((String)(executeForEachR = XmlHandler.getTagValue((Node)node, (String)"execute_for_each_row")))) {
                this.executeForEachIncomingRow = executeForEachR.equalsIgnoreCase("Y");
            }
            if ((mongoFields = XmlHandler.getSubNode((Node)node, (String)CONST_FIELDS)) != null && XmlHandler.countNodes((Node)mongoFields, (String)CONST_FIELD) > 0) {
                int nrFields = XmlHandler.countNodes((Node)mongoFields, (String)CONST_FIELD);
                this.fields = new ArrayList<MongoField>();
                for (int i = 0; i < nrFields; ++i) {
                    Node fieldNode = XmlHandler.getSubNodeByNr((Node)mongoFields, (String)CONST_FIELD, (int)i);
                    MongoField newField = new MongoField();
                    newField.fieldName = XmlHandler.getTagValue((Node)fieldNode, (String)"field_name");
                    newField.fieldPath = XmlHandler.getTagValue((Node)fieldNode, (String)"field_path");
                    newField.hopType = XmlHandler.getTagValue((Node)fieldNode, (String)"field_type");
                    String indexedVals = XmlHandler.getTagValue((Node)fieldNode, (String)"indexed_vals");
                    if (!Utils.isEmpty((CharSequence)indexedVals)) {
                        newField.indexedValues = MongoDbInputData.indexedValsList(indexedVals);
                    }
                    this.fields.add(newField);
                }
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnableToLoadTransformInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public Object clone() {
        MongoDbInputMeta meta = (MongoDbInputMeta)((Object)super.clone());
        return meta;
    }

    public void setDefault() {
        this.jsonFieldName = "json";
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            if (this.outputJson || Utils.isEmpty(this.fields)) {
                IValueMeta jsonValueMeta = ValueMetaFactory.createValueMeta((String)this.jsonFieldName, (int)2);
                jsonValueMeta.setOrigin(origin);
                rowMeta.addValueMeta(jsonValueMeta);
            } else {
                for (MongoField f : this.fields) {
                    int type = ValueMetaFactory.getIdForValueMeta((String)f.hopType);
                    IValueMeta vm = ValueMetaFactory.createValueMeta((String)f.fieldName, (int)type);
                    vm.setOrigin(origin);
                    if (f.indexedValues != null) {
                        vm.setIndex(f.indexedValues.toArray());
                    }
                    rowMeta.addValueMeta(vm);
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error processing output fields of transform", (Throwable)e);
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(300);
        xml.append("    ").append(XmlHandler.addTagValue((String)"connection", (String)this.connectionName));
        xml.append("    ").append(XmlHandler.addTagValue((String)"fields_name", (String)this.jsonField));
        xml.append("    ").append(XmlHandler.addTagValue((String)"collection", (String)this.collection));
        xml.append("    ").append(XmlHandler.addTagValue((String)"json_field_name", (String)this.jsonFieldName));
        xml.append("    ").append(XmlHandler.addTagValue((String)"json_query", (String)this.jsonQuery));
        xml.append("    ").append(XmlHandler.addTagValue((String)"output_json", (boolean)this.outputJson));
        xml.append("    ").append(XmlHandler.addTagValue((String)"query_is_pipeline", (boolean)this.aggPipeline));
        xml.append("    ").append(XmlHandler.addTagValue((String)"execute_for_each_row", (boolean)this.executeForEachIncomingRow));
        if (!Utils.isEmpty(this.fields)) {
            xml.append("\n    ").append(XmlHandler.openTag((String)CONST_FIELDS));
            for (MongoField f : this.fields) {
                xml.append("\n      ").append(XmlHandler.openTag((String)CONST_FIELD));
                xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"field_name", (String)f.fieldName));
                xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"field_path", (String)f.fieldPath));
                xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"field_type", (String)f.hopType));
                if (!Utils.isEmpty(f.indexedValues)) {
                    xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"indexed_vals", (String)MongoDbInputData.indexedValsList(f.indexedValues)));
                }
                xml.append("\n      ").append(XmlHandler.closeTag((String)CONST_FIELD));
            }
            xml.append("\n    ").append(XmlHandler.closeTag((String)CONST_FIELDS));
        }
        return xml.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        super.check(remarks, pipelineMeta, transformMeta, prev, input, output, info, variables, metadataProvider);
    }

    public String getFieldsName() {
        return this.jsonField;
    }

    public void setFieldsName(String fields) {
        this.jsonField = fields;
    }

    public String getJsonFieldName() {
        return this.jsonFieldName;
    }

    public void setJsonFieldName(String jsonFieldName) {
        this.jsonFieldName = jsonFieldName;
    }

    public String getJsonQuery() {
        return this.jsonQuery;
    }

    public void setJsonQuery(String jsonQuery) {
        this.jsonQuery = jsonQuery;
    }

    public void setOutputJson(boolean outputJson) {
        this.outputJson = outputJson;
    }

    public boolean isOutputJson() {
        return this.outputJson;
    }

    public void setQueryIsPipeline(boolean q) {
        this.aggPipeline = q;
    }

    public boolean isQueryIsPipeline() {
        return this.aggPipeline;
    }
}

