/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.context;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.plugin.IGuiActionLambda;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.ui.core.dialog.ContextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.ISingletonProvider;
import org.apache.hop.ui.hopgui.ImplementationLoader;
import org.apache.hop.ui.hopgui.context.GuiContextHandler;
import org.apache.hop.ui.hopgui.context.IActionContextHandlersProvider;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.util.SwtErrorHandler;
import org.eclipse.swt.widgets.Shell;

public class GuiContextUtil {
    private final Map<String, ContextDialog> shellDialogMap = new HashMap<String, ContextDialog>();
    private static final ISingletonProvider PROVIDER = (ISingletonProvider)ImplementationLoader.newInstance(GuiContextUtil.class);

    public static final GuiContextUtil getInstance() {
        return (GuiContextUtil)PROVIDER.getInstanceInternal();
    }

    public final List<GuiAction> getContextActions(IActionContextHandlersProvider provider, GuiActionType actionType, String contextId) {
        return this.filterHandlerActions(provider.getContextHandlers(), actionType, contextId);
    }

    public final List<GuiAction> filterActions(List<GuiAction> guiActions, GuiActionType actionType) {
        ArrayList<GuiAction> filtered = new ArrayList<GuiAction>();
        for (GuiAction guiAction : guiActions) {
            if (!guiAction.getType().equals((Object)actionType)) continue;
            filtered.add(guiAction);
        }
        return filtered;
    }

    public final List<GuiAction> filterHandlerActions(List<IGuiContextHandler> handlers, GuiActionType actionType, String contextId) {
        ArrayList<GuiAction> filtered = new ArrayList<GuiAction>();
        for (IGuiContextHandler handler : handlers) {
            filtered.addAll(this.filterActions(handler.getSupportedActions(), actionType));
        }
        return filtered;
    }

    public final void handleActionSelection(Shell parent, String message, IActionContextHandlersProvider provider, GuiActionType actionType, String contextId) {
        this.handleActionSelection(parent, message, null, provider, actionType, contextId);
    }

    public final void handleActionSelection(Shell parent, String message, Point clickLocation, IActionContextHandlersProvider provider, GuiActionType actionType, String contextId) {
        this.handleActionSelection(parent, message, clickLocation, provider, actionType, contextId, false);
    }

    public final void handleActionSelection(Shell parent, String message, Point clickLocation, IActionContextHandlersProvider provider, GuiActionType actionType, String contextId, boolean sortByName) {
        List<GuiAction> actions = this.getContextActions(provider, actionType, contextId);
        if (actions.isEmpty()) {
            return;
        }
        if (sortByName) {
            Collections.sort(actions, Comparator.comparing(GuiAction::getName));
        }
        this.handleActionSelection(parent, message, clickLocation, new GuiContextHandler(contextId, actions));
    }

    public boolean handleActionSelection(Shell parent, String message, IGuiContextHandler contextHandler) {
        return this.handleActionSelection(parent, message, null, contextHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean handleActionSelection(Shell parent, String message, Point clickLocation, IGuiContextHandler contextHandler) {
        List<GuiAction> actions = contextHandler.getSupportedActions();
        if (actions.isEmpty()) {
            return false;
        }
        try {
            Shell shell = parent;
            synchronized (shell) {
                ContextDialog contextDialog = this.shellDialogMap.get(parent.getText());
                if (contextDialog != null) {
                    if (!contextDialog.isDisposed()) {
                        contextDialog.dispose();
                    }
                    this.shellDialogMap.remove(parent.getText());
                    return true;
                }
                ArrayList<CallSite> fileTypes = new ArrayList<CallSite>();
                for (GuiAction action : actions) {
                    fileTypes.add((CallSite)((Object)(action.getType().name() + " - " + action.getName() + " : " + action.getTooltip())));
                }
                contextDialog = new ContextDialog(parent, message, clickLocation, actions, contextHandler.getContextId());
                this.shellDialogMap.put(parent.getText(), contextDialog);
                GuiAction selectedAction = contextDialog.open();
                this.shellDialogMap.remove(parent.getText());
                if (selectedAction == null) {
                    return contextDialog.isFocusLost();
                }
                ContextDialog dialog = contextDialog;
                HopGui.getInstance().getDisplay().asyncExec(() -> {
                    block2: {
                        try {
                            IGuiActionLambda actionLambda = selectedAction.getActionLambda();
                            actionLambda.executeAction(dialog.isShiftClicked(), dialog.isCtrlClicked(), new Object[0]);
                        }
                        catch (Exception e) {
                            if (SwtErrorHandler.handleException(e)) break block2;
                            new ErrorDialog(parent, "Error", "An error occurred executing action", e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent, "Error", "An error occurred handling action selection", e);
        }
        return false;
    }
}

