/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogLevel;

public class ConfigurableStreamLogger
implements Runnable {
    private InputStream is;
    private String type;
    private LogLevel logLevel;
    private ILogChannel log;

    public ConfigurableStreamLogger(ILogChannel logChannel, InputStream in, LogLevel logLevel, String type) {
        this.log = logChannel;
        this.is = in;
        this.type = type;
        this.logLevel = logLevel;
    }

    @Override
    public void run() {
        block11: {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    String logEntry = this.type + " " + line;
                    switch (this.logLevel) {
                        case MINIMAL: {
                            this.log.logMinimal(logEntry);
                            break;
                        }
                        case BASIC: {
                            this.log.logBasic(logEntry);
                            break;
                        }
                        case DETAILED: {
                            this.log.logDetailed(logEntry);
                            break;
                        }
                        case DEBUG: {
                            this.log.logDebug(logEntry);
                            break;
                        }
                        case ROWLEVEL: {
                            this.log.logRowlevel(logEntry);
                            break;
                        }
                        case ERROR: {
                            this.log.logError(logEntry);
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                if (!this.log.isError()) break block11;
                this.log.logError(this.type + " " + Const.getStackTracker((Throwable)ioe));
            }
        }
    }
}

