/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.shortestpath;

import java.util.Comparator;
import org.psjava.algo.graph.shortestpath.Relax;
import org.psjava.algo.graph.shortestpath.SingleSourceShortestPathAlgorithm;
import org.psjava.algo.graph.shortestpath.SingleSourceShortestPathResult;
import org.psjava.algo.graph.shortestpath.SingleSourceShortestPathResultFactory;
import org.psjava.ds.graph.DirectedWeightedEdge;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.heap.Heap;
import org.psjava.ds.heap.HeapFactory;
import org.psjava.ds.heap.HeapNode;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.map.MutableMapFactory;
import org.psjava.ds.numbersystrem.AddableNumberSystem;
import org.psjava.ds.numbersystrem.InfinitableAddableNumberSystem;
import org.psjava.ds.numbersystrem.InfinitableNumber;
import org.psjava.goods.GoodMutableMapFactory;

public class DijkstraAlgorithm
implements SingleSourceShortestPathAlgorithm {
    private static final MutableMapFactory MF = GoodMutableMapFactory.getInstance();
    private HeapFactory factory;

    public static DijkstraAlgorithm getInstance(HeapFactory heapFactory) {
        return new DijkstraAlgorithm(heapFactory);
    }

    private DijkstraAlgorithm(HeapFactory heapFactory) {
        this.factory = heapFactory;
    }

    @Override
    public <V, W, E extends DirectedWeightedEdge<V, W>> SingleSourceShortestPathResult<V, W, E> calc(Graph<V, E> graph, V start, AddableNumberSystem<W> weightSystem) {
        final InfinitableAddableNumberSystem<W> ns = InfinitableAddableNumberSystem.wrap(weightSystem);
        final MutableMap<Object, Object> distance = MF.create();
        MutableMap previous = MF.create();
        for (Object v : graph.getVertices()) {
            distance.add(v, ns.getInfinity());
        }
        distance.replace(start, ns.getZero());
        Heap heap = this.factory.create(new Comparator<V>(){

            @Override
            public int compare(V o1, V o2) {
                return ns.compare((InfinitableNumber)distance.get(o1), (InfinitableNumber)distance.get(o2));
            }
        });
        MutableMap node = MF.create();
        for (Object v : graph.getVertices()) {
            node.add(v, heap.insert(v));
        }
        while (!heap.isEmpty()) {
            Object current = heap.extractMinimum();
            for (DirectedWeightedEdge edge : graph.getEdges(current)) {
                boolean relaxed = Relax.relax(distance, previous, edge, ns);
                if (!relaxed) continue;
                ((HeapNode)node.get(edge.to())).decreaseKey(edge.to());
            }
        }
        return SingleSourceShortestPathResultFactory.create(start, distance, previous);
    }
}

