/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.IntersectingIterator;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedDocIterator
extends IntersectingIterator {
    private static final Logger log = LoggerFactory.getLogger(IndexedDocIterator.class);
    public static final Text DEFAULT_INDEX_COLF = new Text("i");
    public static final Text DEFAULT_DOC_COLF = new Text("e");
    private static final String indexFamilyOptionName = "indexFamily";
    private static final String docFamilyOptionName = "docFamily";
    private Text indexColf = DEFAULT_INDEX_COLF;
    private Text docColf = DEFAULT_DOC_COLF;
    private Set<ByteSequence> indexColfSet;
    private Set<ByteSequence> docColfSet;
    private static final byte[] nullByte = new byte[]{0};
    public SortedKeyValueIterator<Key, Value> docSource;

    @Override
    protected Key buildKey(Text partition, Text term, Text docID) {
        Text colq = new Text(term);
        colq.append(nullByte, 0, 1);
        colq.append(docID.getBytes(), 0, docID.getLength());
        colq.append(nullByte, 0, 1);
        return new Key(partition, this.indexColf, colq);
    }

    @Override
    protected Key buildKey(Text partition, Text term) {
        Text colq = new Text(term);
        return new Key(partition, this.indexColf, colq);
    }

    @Override
    protected Text getDocID(Key key) {
        return IndexedDocIterator.parseDocID(key);
    }

    public static Text parseDocID(Key key) {
        Text colq = key.getColumnQualifier();
        int firstZeroIndex = colq.find("\u0000");
        if (firstZeroIndex < 0) {
            throw new IllegalArgumentException("bad docid: " + key.toString());
        }
        int secondZeroIndex = colq.find("\u0000", firstZeroIndex + 1);
        if (secondZeroIndex < 0) {
            throw new IllegalArgumentException("bad docid: " + key.toString());
        }
        int thirdZeroIndex = colq.find("\u0000", secondZeroIndex + 1);
        if (thirdZeroIndex < 0) {
            throw new IllegalArgumentException("bad docid: " + key.toString());
        }
        Text docID = new Text();
        try {
            docID.set(colq.getBytes(), firstZeroIndex + 1, thirdZeroIndex - 1 - firstZeroIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("bad indices for docid: " + key.toString() + " " + firstZeroIndex + " " + secondZeroIndex + " " + thirdZeroIndex);
        }
        return docID;
    }

    @Override
    protected Text getTerm(Key key) {
        if (this.indexColf.compareTo(key.getColumnFamily().getBytes(), 0, this.indexColf.getLength()) < 0) {
            return new Text("\ufffd");
        }
        Text colq = key.getColumnQualifier();
        int zeroIndex = colq.find("\u0000");
        Text term = new Text();
        term.set(colq.getBytes(), 0, zeroIndex);
        return term;
    }

    @Override
    public synchronized void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        if (options.containsKey(indexFamilyOptionName)) {
            this.indexColf = new Text(options.get(indexFamilyOptionName));
        }
        if (options.containsKey(docFamilyOptionName)) {
            this.docColf = new Text(options.get(docFamilyOptionName));
        }
        this.docSource = source.deepCopy(env);
        this.indexColfSet = Collections.singleton(new ArrayByteSequence(this.indexColf.getBytes(), 0, this.indexColf.getLength()));
        for (IntersectingIterator.TermSource ts : this.sources) {
            ts.seekColfams = this.indexColfSet;
        }
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> seekColumnFamilies, boolean inclusive) throws IOException {
        super.seek(range, null, true);
    }

    @Override
    protected void advanceToIntersection() throws IOException {
        super.advanceToIntersection();
        if (this.topKey == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("using top key to seek for doc: " + this.topKey.toString());
        }
        Key docKey = this.buildDocKey();
        this.docSource.seek(new Range(docKey, true, null, false), this.docColfSet, true);
        log.debug("got doc key: " + this.docSource.getTopKey().toString());
        if (this.docSource.hasTop() && docKey.equals(this.docSource.getTopKey(), PartialKey.ROW_COLFAM_COLQUAL)) {
            this.value = this.docSource.getTopValue();
        }
        log.debug("got doc value: " + this.value.toString());
    }

    protected Key buildDocKey() {
        int zeroIndex;
        if (log.isTraceEnabled()) {
            log.trace("building doc key for " + this.currentPartition + " " + this.currentDocID);
        }
        if ((zeroIndex = this.currentDocID.find("\u0000")) < 0) {
            throw new IllegalArgumentException("bad current docID");
        }
        Text colf = new Text(this.docColf);
        colf.append(nullByte, 0, 1);
        colf.append(this.currentDocID.getBytes(), 0, zeroIndex);
        this.docColfSet = Collections.singleton(new ArrayByteSequence(colf.getBytes(), 0, colf.getLength()));
        if (log.isTraceEnabled()) {
            log.trace(zeroIndex + " " + this.currentDocID.getLength());
        }
        Text colq = new Text();
        colq.set(this.currentDocID.getBytes(), zeroIndex + 1, this.currentDocID.getLength() - zeroIndex - 1);
        Key k = new Key(this.currentPartition, colf, colq);
        if (log.isTraceEnabled()) {
            log.trace("built doc key for seek: " + k.toString());
        }
        return k;
    }

    public static void setIndexColf(IteratorSetting is, String indexColf) {
        is.addOption(indexFamilyOptionName, indexColf);
    }

    public static void setDocColfPrefix(IteratorSetting is, String docColfPrefix) {
        is.addOption(docFamilyOptionName, docColfPrefix);
    }

    public static void setColfs(IteratorSetting is, String indexColf, String docColfPrefix) {
        IndexedDocIterator.setIndexColf(is, indexColf);
        IndexedDocIterator.setDocColfPrefix(is, docColfPrefix);
    }
}

