/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinator;
import org.apache.accumulo.core.replication.thrift.ReplicationServicer;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationClient {
    private static final Logger log = LoggerFactory.getLogger(ReplicationClient.class);

    public static ReplicationCoordinator.Client getCoordinatorConnectionWithRetry(ClientContext context) throws AccumuloException {
        Objects.requireNonNull(context);
        Instance instance = context.getInstance();
        for (int attempts = 1; attempts <= 10; ++attempts) {
            ReplicationCoordinator.Client result = ReplicationClient.getCoordinatorConnection(context);
            if (result != null) {
                return result;
            }
            log.debug("Could not get ReplicationCoordinator connection to {}, will retry", (Object)instance.getInstanceName());
            try {
                Thread.sleep(attempts * 250);
                continue;
            }
            catch (InterruptedException e) {
                throw new AccumuloException(e);
            }
        }
        throw new AccumuloException("Timed out trying to communicate with master from " + instance.getInstanceName());
    }

    public static ReplicationCoordinator.Client getCoordinatorConnection(ClientContext context) {
        String replCoordinatorAddr;
        Instance instance = context.getInstance();
        List<String> locations = instance.getMasterLocations();
        if (locations.size() == 0) {
            log.debug("No masters for replication to instance {}", (Object)instance.getInstanceName());
            return null;
        }
        String masterThriftService = locations.get(0);
        if (masterThriftService.endsWith(":0")) {
            log.warn("Master found for {} did not have real location {}", (Object)instance.getInstanceName(), (Object)masterThriftService);
            return null;
        }
        String zkPath = ZooUtil.getRoot(instance) + "/masters/repl_coord_addr";
        log.debug("Using ZooKeeper quorum at {} with path {} to find peer Master information", (Object)instance.getZooKeepers(), (Object)zkPath);
        try {
            ZooReader reader = new ZooReader(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut());
            replCoordinatorAddr = new String(reader.getData(zkPath, null), StandardCharsets.UTF_8);
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Could not fetch remote coordinator port", e);
            return null;
        }
        HostAndPort coordinatorAddr = HostAndPort.fromString(replCoordinatorAddr);
        log.debug("Connecting to master at {}", (Object)coordinatorAddr);
        try {
            ReplicationCoordinator.Client client = ThriftUtil.getClientNoTimeout(new ReplicationCoordinator.Client.Factory(), coordinatorAddr, context);
            return client;
        }
        catch (TTransportException tte) {
            log.debug("Failed to connect to master coordinator service ({})", (Object)coordinatorAddr, (Object)tte);
            return null;
        }
    }

    public static ReplicationServicer.Client getServicerConnection(ClientContext context, HostAndPort server, long timeout) throws TTransportException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(server);
        try {
            return ThriftUtil.getClient(new ReplicationServicer.Client.Factory(), server, context, timeout);
        }
        catch (TTransportException tte) {
            log.debug("Failed to connect to servicer ({}), will retry...", (Object)server, (Object)tte);
            throw tte;
        }
    }

    public static void close(ReplicationCoordinator.Iface iface) {
        TServiceClient client = (TServiceClient)iface;
        if (client != null && client.getInputProtocol() != null && client.getInputProtocol().getTransport() != null) {
            ThriftTransportPool.getInstance().returnTransport(client.getInputProtocol().getTransport());
        } else {
            log.debug("Attempt to close null connection to the remote system", (Throwable)new Exception());
        }
    }

    public static void close(ReplicationServicer.Iface iface) {
        TServiceClient client = (TServiceClient)iface;
        if (client != null && client.getInputProtocol() != null && client.getInputProtocol().getTransport() != null) {
            ThriftTransportPool.getInstance().returnTransport(client.getInputProtocol().getTransport());
        } else {
            log.debug("Attempt to close null connection to the remote system", (Throwable)new Exception());
        }
    }

    public static <T> T executeCoordinatorWithReturn(ClientContext context, ClientExecReturn<T, ReplicationCoordinator.Client> exec) throws AccumuloException, AccumuloSecurityException {
        ReplicationCoordinator.Client client = null;
        for (int i = 0; i < 10; ++i) {
            try {
                client = ReplicationClient.getCoordinatorConnectionWithRetry(context);
                T t = exec.execute(client);
                return t;
            }
            catch (TTransportException tte) {
                log.debug("ReplicationClient coordinator request failed, retrying ... ", (Throwable)tte);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new AccumuloException(e);
                }
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (AccumuloException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client != null) {
                    ReplicationClient.close(client);
                }
            }
        }
        throw new AccumuloException("Could not connect to ReplicationCoordinator at " + context.getInstance().getInstanceName());
    }

    public static <T> T executeServicerWithReturn(ClientContext context, HostAndPort tserver, ClientExecReturn<T, ReplicationServicer.Client> exec, long timeout) throws AccumuloException, AccumuloSecurityException, TTransportException {
        ReplicationServicer.Client client = null;
        try {
            client = ReplicationClient.getServicerConnection(context, tserver, timeout);
            T t = exec.execute(client);
            return t;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
        finally {
            if (client != null) {
                ReplicationClient.close(client);
            }
        }
    }
}

