/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import javax.imageio.ImageIO;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobImpl;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.types.converters.ArrayConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public abstract class AbstractLargeBinaryColumnMapping
extends AbstractColumnMapping {
    public AbstractLargeBinaryColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    protected void initialize() {
        this.initTypeInfo();
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        if (value == null) {
            try {
                if (this.useDefaultWhenNull()) {
                    ps.setBytes(param, this.column.getDefaultValue().toString().trim().getBytes());
                }
                ps.setNull(param, this.getJDBCType());
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + param, this.column, sqle.getMessage()}), (Throwable)sqle);
            }
        } else {
            try {
                if (this.getJavaTypeMapping().isSerialised()) {
                    if (!(value instanceof Serializable)) {
                        throw new NucleusDataStoreException(Localiser.msg((String)"055005", (Object[])new Object[]{value.getClass().getName()}));
                    }
                    BlobImpl b = new BlobImpl(value);
                    ps.setBytes(param, b.getBytes(0L, (int)b.length()));
                } else if (value instanceof boolean[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromBooleanArray((boolean[])((boolean[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof char[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromCharArray((char[])((char[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof double[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromDoubleArray((double[])((double[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof float[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromFloatArray((float[])((float[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof int[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromIntArray((int[])((int[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof long[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromLongArray((long[])((long[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof short[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromShortArray((short[])((short[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof Boolean[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromBooleanObjectArray((Boolean[])((Boolean[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof Byte[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromByteObjectArray((Byte[])((Byte[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof Character[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromCharObjectArray((Character[])((Character[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof Double[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromDoubleObjectArray((Double[])((Double[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof Float[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromFloatObjectArray((Float[])((Float[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof Integer[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromIntObjectArray((Integer[])((Integer[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof Long[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromLongObjectArray((Long[])((Long[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof Short[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromShortObjectArray((Short[])((Short[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof BigDecimal[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromBigDecimalArray((BigDecimal[])((BigDecimal[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof BigInteger[]) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromBigIntegerArray((BigInteger[])((BigInteger[])value));
                    ps.setBytes(param, data);
                } else if (value instanceof byte[]) {
                    ps.setBytes(param, (byte[])value);
                } else if (value instanceof BitSet) {
                    byte[] data = ArrayConversionHelper.getByteArrayFromBooleanArray((boolean[])ArrayConversionHelper.getBooleanArrayFromBitSet((BitSet)((BitSet)value)));
                    ps.setBytes(param, data);
                } else if (value instanceof BufferedImage) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                    ImageIO.write((RenderedImage)((BufferedImage)value), "jpg", baos);
                    byte[] buffer = baos.toByteArray();
                    baos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                    ps.setBytes(param, buffer);
                    bais.close();
                } else {
                    if (!(value instanceof Serializable)) {
                        throw new NucleusDataStoreException(Localiser.msg((String)"055005", (Object[])new Object[]{value.getClass().getName()}));
                    }
                    BlobImpl b = new BlobImpl(value);
                    ps.setBytes(param, b.getBytes(0L, (int)b.length()));
                }
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
            }
        }
    }

    protected Object getObjectForBytes(byte[] bytes, int param) {
        BlobImpl blob;
        String typeName = this.getJavaTypeMapping().getType();
        if (this.getJavaTypeMapping() instanceof TypeConverterMapping) {
            TypeConverter conv = ((TypeConverterMapping)this.getJavaTypeMapping()).getTypeConverter();
            Class datastoreType = this.storeMgr.getNucleusContext().getTypeManager().getDatastoreTypeForTypeConverter(conv, this.getJavaTypeMapping().getJavaType());
            typeName = datastoreType.getName();
        }
        if (this.getJavaTypeMapping().isSerialised()) {
            try {
                blob = new BlobImpl(bytes);
                return blob.getObject();
            }
            catch (SQLException sqle) {
                return null;
            }
        }
        if (typeName.equals(ClassNameConstants.BOOLEAN_ARRAY)) {
            return ArrayConversionHelper.getBooleanArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.BYTE_ARRAY)) {
            return bytes;
        }
        if (typeName.equals(ClassNameConstants.CHAR_ARRAY)) {
            return ArrayConversionHelper.getCharArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.DOUBLE_ARRAY)) {
            return ArrayConversionHelper.getDoubleArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.FLOAT_ARRAY)) {
            return ArrayConversionHelper.getFloatArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.INT_ARRAY)) {
            return ArrayConversionHelper.getIntArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.LONG_ARRAY)) {
            return ArrayConversionHelper.getLongArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.SHORT_ARRAY)) {
            return ArrayConversionHelper.getShortArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.JAVA_LANG_BOOLEAN_ARRAY)) {
            return ArrayConversionHelper.getBooleanObjectArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.JAVA_LANG_BYTE_ARRAY)) {
            return ArrayConversionHelper.getByteObjectArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.JAVA_LANG_CHARACTER_ARRAY)) {
            return ArrayConversionHelper.getCharObjectArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.JAVA_LANG_DOUBLE_ARRAY)) {
            return ArrayConversionHelper.getDoubleObjectArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.JAVA_LANG_FLOAT_ARRAY)) {
            return ArrayConversionHelper.getFloatObjectArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.JAVA_LANG_INTEGER_ARRAY)) {
            return ArrayConversionHelper.getIntObjectArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.JAVA_LANG_LONG_ARRAY)) {
            return ArrayConversionHelper.getLongObjectArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(ClassNameConstants.JAVA_LANG_SHORT_ARRAY)) {
            return ArrayConversionHelper.getShortObjectArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(BigDecimal[].class.getName())) {
            return ArrayConversionHelper.getBigDecimalArrayFromByteArray((byte[])bytes);
        }
        if (typeName.equals(BigInteger[].class.getName())) {
            return ArrayConversionHelper.getBigIntegerArrayFromByteArray((byte[])bytes);
        }
        if (this.getJavaTypeMapping().getJavaType() != null && this.getJavaTypeMapping().getJavaType().getName().equals("java.util.BitSet")) {
            return ArrayConversionHelper.getBitSetFromBooleanArray((boolean[])ArrayConversionHelper.getBooleanArrayFromByteArray((byte[])bytes));
        }
        if (this.getJavaTypeMapping().getJavaType() != null && this.getJavaTypeMapping().getJavaType().getName().equals("java.awt.image.BufferedImage")) {
            try {
                return ImageIO.read(new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
            }
        }
        try {
            blob = new BlobImpl(bytes);
            return blob.getObject();
        }
        catch (SQLException sqle) {
            return null;
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        byte[] bytes = null;
        try {
            bytes = rs.getBytes(param);
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, sqle.getMessage()}), (Throwable)sqle);
        }
        if (bytes == null) {
            return null;
        }
        return this.getObjectForBytes(bytes, param);
    }

    @Override
    public void setString(PreparedStatement ps, int exprIndex, String value) {
        this.setObject(ps, exprIndex, value);
    }

    @Override
    public String getString(ResultSet resultSet, int exprIndex) {
        return (String)this.getObject(resultSet, exprIndex);
    }
}

