/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import com.google.common.base.Joiner;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.streaming.AbstractRecordWriter;
import org.apache.hive.streaming.SerializationError;

public class StrictDelimitedInputWriter
extends AbstractRecordWriter {
    private char fieldDelimiter;
    private char collectionDelimiter;
    private char mapKeyDelimiter;
    private LazySimpleSerDe serde;

    private StrictDelimitedInputWriter(Builder builder) {
        super(builder.lineDelimiter);
        this.fieldDelimiter = builder.fieldDelimiter;
        this.collectionDelimiter = builder.collectionDelimiter;
        this.mapKeyDelimiter = builder.mapKeyDelimiter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Object encode(byte[] record) throws SerializationError {
        try {
            BytesWritable blob = new BytesWritable();
            blob.set(record, 0, record.length);
            return this.serde.deserialize((Writable)blob);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to convert byte[] record into Object", (Exception)((Object)e));
        }
    }

    public LazySimpleSerDe createSerde() throws SerializationError {
        try {
            Properties tableProps = this.table.getMetadata();
            tableProps.setProperty("columns", Joiner.on((String)",").join((Iterable)this.inputColumns));
            tableProps.setProperty("columns.types", Joiner.on((String)":").join((Iterable)this.inputTypes));
            tableProps.setProperty("field.delim", String.valueOf(this.fieldDelimiter));
            tableProps.setProperty("collection.delim", String.valueOf(this.collectionDelimiter));
            tableProps.setProperty("mapkey.delim", String.valueOf(this.mapKeyDelimiter));
            LazySimpleSerDe serde = new LazySimpleSerDe();
            serde.initialize((Configuration)this.conf, tableProps, null);
            this.serde = serde;
            return serde;
        }
        catch (SerDeException e) {
            throw new SerializationError("Error initializing serde", (Exception)((Object)e));
        }
    }

    public static class Builder {
        private char fieldDelimiter = (char)LazySerDeParameters.DefaultSeparators[0];
        private char collectionDelimiter = (char)LazySerDeParameters.DefaultSeparators[1];
        private char mapKeyDelimiter = (char)LazySerDeParameters.DefaultSeparators[2];
        private String lineDelimiter;

        public Builder withFieldDelimiter(char fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public Builder withCollectionDelimiter(char collectionDelimiter) {
            this.collectionDelimiter = collectionDelimiter;
            return this;
        }

        public Builder withMapKeyDelimiter(char mapKeyDelimiter) {
            this.mapKeyDelimiter = mapKeyDelimiter;
            return this;
        }

        public Builder withLineDelimiterPattern(String lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            return this;
        }

        public StrictDelimitedInputWriter build() {
            return new StrictDelimitedInputWriter(this);
        }
    }
}

