/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.EnsureValidTxnFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class HeartbeatTxnFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatTxnFunction.class);
    private final long txnId;

    public HeartbeatTxnFunction(long txnId) {
        this.txnId = txnId;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException, NoSuchTxnException, TxnAbortedException, NoSuchLockException {
        if (this.txnId == 0L) {
            return null;
        }
        int rc = jdbcResource.getJdbcTemplate().update("UPDATE \"TXNS\" SET \"TXN_LAST_HEARTBEAT\" = " + TxnUtils.getEpochFn(jdbcResource.getDatabaseProduct()) + " WHERE \"TXN_ID\" = :txnId AND \"TXN_STATE\" = :state", (SqlParameterSource)new MapSqlParameterSource().addValue("txnId", (Object)this.txnId).addValue("state", (Object)TxnStatus.OPEN.getSqlConst(), 1));
        if (rc < 1) {
            new EnsureValidTxnFunction(this.txnId).execute(jdbcResource);
            LOG.error("Can neither heartbeat txn (txnId={}) nor confirm it as invalid.", (Object)this.txnId);
            throw new NoSuchTxnException("No such txn: " + this.txnId);
        }
        LOG.debug("Successfully heartbeated for txnId={}", (Object)this.txnId);
        jdbcResource.getTransactionManager().getActiveTransaction().createSavepoint();
        return null;
    }
}

