/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class EnsureValidTxnFunction
implements TransactionalFunction<Void> {
    private final long txnId;

    public EnsureValidTxnFunction(long txnId) {
        this.txnId = txnId;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException, NoSuchTxnException, TxnAbortedException {
        MapSqlParameterSource paramSource = new MapSqlParameterSource().addValue("txnId", (Object)this.txnId);
        TxnStatus status = (TxnStatus)((Object)jdbcResource.getJdbcTemplate().query("SELECT \"TXN_STATE\" FROM \"TXNS\" WHERE \"TXN_ID\" = :txnId", (SqlParameterSource)paramSource, rs -> rs.next() ? TxnStatus.fromString(rs.getString("TXN_STATE")) : null));
        if (status == null) {
            boolean alreadyCommitted = Boolean.TRUE.equals(jdbcResource.getJdbcTemplate().query("SELECT COUNT(*) FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_TXNID\" = :txnId", (SqlParameterSource)paramSource, rs -> rs.next() && rs.getInt(1) > 0));
            if (alreadyCommitted) {
                throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString((long)this.txnId) + " is already committed.");
            }
            throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString((long)this.txnId));
        }
        if (status == TxnStatus.ABORTED) {
            throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString((long)this.txnId) + " already aborted");
        }
        return null;
    }
}

