/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.MetaToolObjectStore;
import org.apache.hadoop.hive.metastore.tools.metatool.HiveMetaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTask;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskDiffExtTblLocs;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskExecuteJDOQLQuery;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskListExtTblLocs;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskListFSRoot;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskMetadataSummary;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskUpdateLocation;
import org.apache.hadoop.util.ExitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveMetaTool {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HiveMetaTool.class.getName());

    private HiveMetaTool() {
        throw new UnsupportedOperationException("HiveMetaTool should not be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String[] args) throws Exception {
        HiveMetaToolCommandLine cl = HiveMetaToolCommandLine.parseArguments(args);
        MetaToolObjectStore objectStore = new MetaToolObjectStore();
        objectStore.setConf(MetastoreConf.newMetastoreConf());
        MetaToolTask task = null;
        try {
            if (cl.isListFSRoot()) {
                task = new MetaToolTaskListFSRoot();
            } else if (cl.isExecuteJDOQL()) {
                task = new MetaToolTaskExecuteJDOQLQuery();
            } else if (cl.isUpdateLocation()) {
                task = new MetaToolTaskUpdateLocation();
            } else if (cl.isListExtTblLocs()) {
                task = new MetaToolTaskListExtTblLocs();
            } else if (cl.isDiffExtTblLocs()) {
                task = new MetaToolTaskDiffExtTblLocs();
            } else if (cl.isMetadataSummary()) {
                task = new MetaToolTaskMetadataSummary();
            } else {
                throw new IllegalArgumentException("No task was specified!");
            }
            task.setObjectStore(objectStore);
            task.setCommandLine(cl);
            task.execute();
        }
        finally {
            objectStore.shutdown();
        }
    }

    public static void main(String[] args) {
        int status = 0;
        try {
            HiveMetaTool.execute(args);
        }
        catch (Exception e) {
            status = -1;
            LOGGER.error("Exception occured", (Throwable)e);
        }
        finally {
            ExitUtil.terminate((int)status);
        }
    }
}

