/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONDropPartitionMessage
extends DropPartitionMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    String tableType;
    @JsonProperty
    String tableObjJson;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    List<Map<String, String>> partitions;

    public JSONDropPartitionMessage() {
    }

    public JSONDropPartitionMessage(String server, String servicePrincipal, String db, String table, List<Map<String, String>> partitions, Long timestamp) {
        this(server, servicePrincipal, db, table, null, partitions, timestamp);
    }

    public JSONDropPartitionMessage(String server, String servicePrincipal, String db, String table, String tableType, List<Map<String, String>> partitions, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = db;
        this.table = table;
        this.tableType = tableType;
        this.partitions = partitions;
        this.timestamp = timestamp;
        this.checkValid();
    }

    public JSONDropPartitionMessage(String server, String servicePrincipal, Table tableObj, List<Map<String, String>> partitionKeyValues, long timestamp) {
        this(server, servicePrincipal, tableObj.getDbName(), tableObj.getTableName(), tableObj.getTableType(), partitionKeyValues, timestamp);
        try {
            this.tableObjJson = MessageBuilder.createTableObjJson(tableObj);
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getTableType() {
        if (this.tableType != null) {
            return this.tableType;
        }
        return "";
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<Map<String, String>> getPartitions() {
        return this.partitions;
    }

    @Override
    public Table getTableObj() throws Exception {
        return (Table)MessageBuilder.getTObj(this.tableObjJson, Table.class);
    }

    public String getTableObjJson() {
        return this.tableObjJson;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

