/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Objects;
import java.util.Optional;

public class ConsumerGroupMetadata {
    private final String groupId;
    private final int generationId;
    private final String memberId;
    private final Optional<String> groupInstanceId;

    public ConsumerGroupMetadata(String groupId, int generationId, String memberId, Optional<String> groupInstanceId) {
        this.groupId = Objects.requireNonNull(groupId, "group.id can't be null");
        this.generationId = generationId;
        this.memberId = Objects.requireNonNull(memberId, "member.id can't be null");
        this.groupInstanceId = Objects.requireNonNull(groupInstanceId, "group.instance.id can't be null");
    }

    public ConsumerGroupMetadata(String groupId) {
        this(groupId, -1, "", Optional.empty());
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public Optional<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    public String toString() {
        return String.format("GroupMetadata(groupId = %s, generationId = %d, memberId = %s, groupInstanceId = %s)", this.groupId, this.generationId, this.memberId, this.groupInstanceId.orElse(""));
    }
}

