/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.hive.iceberg.org.apache.avro.Schema;
import org.apache.hive.iceberg.org.apache.avro.generic.IndexedRecord;
import org.apache.hive.iceberg.org.apache.avro.specific.SpecificData;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.SupportsIndexProjection;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;

public class GenericManifestFile
extends SupportsIndexProjection
implements ManifestFile,
StructLike,
IndexedRecord,
SpecificData.SchemaConstructable,
Serializable {
    private static final Schema AVRO_SCHEMA = AvroSchemaUtil.convert(ManifestFile.schema(), "manifest_file");
    private static final ManifestContent[] MANIFEST_CONTENT_VALUES = ManifestContent.values();
    private transient Schema avroSchema;
    private InputFile file = null;
    private String manifestPath = null;
    private Long length = null;
    private int specId = -1;
    private ManifestContent content = ManifestContent.DATA;
    private long sequenceNumber = 0L;
    private long minSequenceNumber = 0L;
    private Long snapshotId = null;
    private Integer addedFilesCount = null;
    private Integer existingFilesCount = null;
    private Integer deletedFilesCount = null;
    private Long addedRowsCount = null;
    private Long existingRowsCount = null;
    private Long deletedRowsCount = null;
    private ManifestFile.PartitionFieldSummary[] partitions = null;
    private byte[] keyMetadata = null;
    private Long firstRowId = null;

    public GenericManifestFile(Schema avroSchema) {
        super(ManifestFile.schema().asStruct(), AvroSchemaUtil.convert(avroSchema).asStructType());
        this.avroSchema = avroSchema;
    }

    GenericManifestFile(Types.StructType projectedSchema) {
        super(ManifestFile.schema().asStruct(), projectedSchema);
        this.avroSchema = AVRO_SCHEMA;
    }

    GenericManifestFile(InputFile file, int specId, long snapshotId) {
        super(ManifestFile.schema().columns().size());
        this.avroSchema = AVRO_SCHEMA;
        this.file = file;
        this.manifestPath = file.location();
        this.length = null;
        this.specId = specId;
        this.sequenceNumber = 0L;
        this.minSequenceNumber = 0L;
        this.snapshotId = snapshotId;
        this.addedFilesCount = null;
        this.addedRowsCount = null;
        this.existingFilesCount = null;
        this.existingRowsCount = null;
        this.deletedFilesCount = null;
        this.deletedRowsCount = null;
        this.partitions = null;
        this.keyMetadata = null;
        this.firstRowId = null;
    }

    GenericManifestFile(String path, long length, int specId, ManifestContent content, long sequenceNumber, long minSequenceNumber, Long snapshotId, List<ManifestFile.PartitionFieldSummary> partitions, ByteBuffer keyMetadata, Integer addedFilesCount, Long addedRowsCount, Integer existingFilesCount, Long existingRowsCount, Integer deletedFilesCount, Long deletedRowsCount, Long firstRowId) {
        super(ManifestFile.schema().columns().size());
        this.avroSchema = AVRO_SCHEMA;
        this.manifestPath = path;
        this.length = length;
        this.specId = specId;
        this.content = content;
        this.sequenceNumber = sequenceNumber;
        this.minSequenceNumber = minSequenceNumber;
        this.snapshotId = snapshotId;
        this.addedFilesCount = addedFilesCount;
        this.addedRowsCount = addedRowsCount;
        this.existingFilesCount = existingFilesCount;
        this.existingRowsCount = existingRowsCount;
        this.deletedFilesCount = deletedFilesCount;
        this.deletedRowsCount = deletedRowsCount;
        this.partitions = partitions == null ? null : partitions.toArray(new ManifestFile.PartitionFieldSummary[0]);
        this.keyMetadata = ByteBuffers.toByteArray(keyMetadata);
        this.firstRowId = firstRowId;
    }

    @Deprecated
    public GenericManifestFile(String path, long length, int specId, ManifestContent content, long sequenceNumber, long minSequenceNumber, Long snapshotId, int addedFilesCount, long addedRowsCount, int existingFilesCount, long existingRowsCount, int deletedFilesCount, long deletedRowsCount, List<ManifestFile.PartitionFieldSummary> partitions, ByteBuffer keyMetadata) {
        super(ManifestFile.schema().columns().size());
        this.avroSchema = AVRO_SCHEMA;
        this.manifestPath = path;
        this.length = length;
        this.specId = specId;
        this.content = content;
        this.sequenceNumber = sequenceNumber;
        this.minSequenceNumber = minSequenceNumber;
        this.snapshotId = snapshotId;
        this.addedFilesCount = addedFilesCount;
        this.addedRowsCount = addedRowsCount;
        this.existingFilesCount = existingFilesCount;
        this.existingRowsCount = existingRowsCount;
        this.deletedFilesCount = deletedFilesCount;
        this.deletedRowsCount = deletedRowsCount;
        this.partitions = partitions == null ? null : partitions.toArray(new ManifestFile.PartitionFieldSummary[0]);
        this.keyMetadata = ByteBuffers.toByteArray(keyMetadata);
    }

    private GenericManifestFile(GenericManifestFile toCopy) {
        super(toCopy);
        this.avroSchema = toCopy.avroSchema;
        this.manifestPath = toCopy.manifestPath;
        try {
            this.length = toCopy.length();
        }
        catch (UnsupportedOperationException e) {
            this.length = null;
        }
        this.specId = toCopy.specId;
        this.content = toCopy.content;
        this.sequenceNumber = toCopy.sequenceNumber;
        this.minSequenceNumber = toCopy.minSequenceNumber;
        this.snapshotId = toCopy.snapshotId;
        this.addedFilesCount = toCopy.addedFilesCount;
        this.addedRowsCount = toCopy.addedRowsCount;
        this.existingFilesCount = toCopy.existingFilesCount;
        this.existingRowsCount = toCopy.existingRowsCount;
        this.deletedFilesCount = toCopy.deletedFilesCount;
        this.deletedRowsCount = toCopy.deletedRowsCount;
        this.partitions = toCopy.partitions != null ? (ManifestFile.PartitionFieldSummary[])Stream.of(toCopy.partitions).map(ManifestFile.PartitionFieldSummary::copy).toArray(ManifestFile.PartitionFieldSummary[]::new) : null;
        this.keyMetadata = toCopy.keyMetadata == null ? null : Arrays.copyOf(toCopy.keyMetadata, toCopy.keyMetadata.length);
        this.firstRowId = toCopy.firstRowId;
    }

    GenericManifestFile() {
        super(ManifestFile.schema().columns().size());
    }

    @Override
    public String path() {
        return this.manifestPath;
    }

    public Long lazyLength() {
        if (this.length == null) {
            if (this.file != null) {
                this.length = this.file.getLength();
            } else {
                return null;
            }
        }
        return this.length;
    }

    @Override
    public long length() {
        return this.lazyLength();
    }

    @Override
    public int partitionSpecId() {
        return this.specId;
    }

    @Override
    public ManifestContent content() {
        return this.content;
    }

    @Override
    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public long minSequenceNumber() {
        return this.minSequenceNumber;
    }

    @Override
    public Long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Integer addedFilesCount() {
        return this.addedFilesCount;
    }

    @Override
    public Long addedRowsCount() {
        return this.addedRowsCount;
    }

    @Override
    public Integer existingFilesCount() {
        return this.existingFilesCount;
    }

    @Override
    public Long existingRowsCount() {
        return this.existingRowsCount;
    }

    @Override
    public Integer deletedFilesCount() {
        return this.deletedFilesCount;
    }

    @Override
    public Long deletedRowsCount() {
        return this.deletedRowsCount;
    }

    @Override
    public List<ManifestFile.PartitionFieldSummary> partitions() {
        return this.partitions == null ? null : Arrays.asList(this.partitions);
    }

    @Override
    public ByteBuffer keyMetadata() {
        return this.keyMetadata == null ? null : ByteBuffer.wrap(this.keyMetadata);
    }

    @Override
    public Long firstRowId() {
        return this.firstRowId;
    }

    @Override
    public int size() {
        return ManifestFile.schema().columns().size();
    }

    @Override
    public Object get(int pos) {
        return this.internalGet(pos, Object.class);
    }

    @Override
    protected <T> T internalGet(int pos, Class<T> javaClass) {
        return javaClass.cast(this.getByPos(pos));
    }

    private Object getByPos(int basePos) {
        switch (basePos) {
            case 0: {
                return this.manifestPath;
            }
            case 1: {
                return this.lazyLength();
            }
            case 2: {
                return this.specId;
            }
            case 3: {
                return this.content.id();
            }
            case 4: {
                return this.sequenceNumber;
            }
            case 5: {
                return this.minSequenceNumber;
            }
            case 6: {
                return this.snapshotId;
            }
            case 7: {
                return this.addedFilesCount;
            }
            case 8: {
                return this.existingFilesCount;
            }
            case 9: {
                return this.deletedFilesCount;
            }
            case 10: {
                return this.addedRowsCount;
            }
            case 11: {
                return this.existingRowsCount;
            }
            case 12: {
                return this.deletedRowsCount;
            }
            case 13: {
                return this.partitions();
            }
            case 14: {
                return this.keyMetadata();
            }
            case 15: {
                return this.firstRowId();
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + basePos);
    }

    @Override
    protected <T> void internalSet(int basePos, T value) {
        switch (basePos) {
            case 0: {
                this.manifestPath = value.toString();
                return;
            }
            case 1: {
                this.length = (Long)value;
                return;
            }
            case 2: {
                this.specId = (Integer)value;
                return;
            }
            case 3: {
                this.content = value != null ? MANIFEST_CONTENT_VALUES[(Integer)value] : ManifestContent.DATA;
                return;
            }
            case 4: {
                this.sequenceNumber = value != null ? (Long)value : 0L;
                return;
            }
            case 5: {
                this.minSequenceNumber = value != null ? (Long)value : 0L;
                return;
            }
            case 6: {
                this.snapshotId = (Long)value;
                return;
            }
            case 7: {
                this.addedFilesCount = (Integer)value;
                return;
            }
            case 8: {
                this.existingFilesCount = (Integer)value;
                return;
            }
            case 9: {
                this.deletedFilesCount = (Integer)value;
                return;
            }
            case 10: {
                this.addedRowsCount = (Long)value;
                return;
            }
            case 11: {
                this.existingRowsCount = (Long)value;
                return;
            }
            case 12: {
                this.deletedRowsCount = (Long)value;
                return;
            }
            case 13: {
                this.partitions = value == null ? null : ((List)value).toArray(new ManifestFile.PartitionFieldSummary[0]);
                return;
            }
            case 14: {
                this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)value);
                return;
            }
            case 15: {
                this.firstRowId = (Long)value;
                return;
            }
        }
    }

    @Override
    public void put(int i, Object v) {
        this.set(i, v);
    }

    @Override
    public ManifestFile copy() {
        return new GenericManifestFile(this);
    }

    @Override
    public Schema getSchema() {
        return this.avroSchema;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenericManifestFile)) {
            return false;
        }
        GenericManifestFile that = (GenericManifestFile)other;
        return Objects.equal(this.manifestPath, that.manifestPath);
    }

    public int hashCode() {
        return Objects.hashCode(this.manifestPath);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("content", (Object)this.content).add("path", this.manifestPath).add("length", this.length).add("partition_spec_id", this.specId).add("added_snapshot_id", this.snapshotId).add("added_data_files_count", this.addedFilesCount).add("added_rows_count", this.addedRowsCount).add("existing_data_files_count", this.existingFilesCount).add("existing_rows_count", this.existingRowsCount).add("deleted_data_files_count", this.deletedFilesCount).add("deleted_rows_count", this.deletedRowsCount).add("partitions", this.partitions).add("key_metadata", this.keyMetadata == null ? "null" : "(redacted)").add("sequence_number", this.sequenceNumber).add("min_sequence_number", this.minSequenceNumber).add("first_row_id", this.firstRowId).toString();
    }

    public static CopyBuilder copyOf(ManifestFile manifestFile) {
        return new CopyBuilder(manifestFile);
    }

    private static <E, R> List<R> copyList(List<E> list, Function<E, R> transform) {
        if (list != null) {
            ArrayList<R> copy = Lists.newArrayListWithExpectedSize(list.size());
            for (E element : list) {
                copy.add(transform.apply(element));
            }
            return copy;
        }
        return null;
    }

    public static class CopyBuilder {
        private final GenericManifestFile manifestFile;

        private CopyBuilder(ManifestFile toCopy) {
            this.manifestFile = toCopy instanceof GenericManifestFile ? new GenericManifestFile((GenericManifestFile)toCopy) : new GenericManifestFile(toCopy.path(), toCopy.length(), toCopy.partitionSpecId(), toCopy.content(), toCopy.sequenceNumber(), toCopy.minSequenceNumber(), toCopy.snapshotId(), GenericManifestFile.copyList(toCopy.partitions(), ManifestFile.PartitionFieldSummary::copy), toCopy.keyMetadata(), toCopy.addedFilesCount(), toCopy.addedRowsCount(), toCopy.existingFilesCount(), toCopy.existingRowsCount(), toCopy.deletedFilesCount(), toCopy.deletedRowsCount(), toCopy.firstRowId());
        }

        public CopyBuilder withSnapshotId(Long newSnapshotId) {
            this.manifestFile.snapshotId = newSnapshotId;
            return this;
        }

        public ManifestFile build() {
            return this.manifestFile;
        }
    }
}

