/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hive.hcatalog.api.HCatPartition;
import org.apache.hive.hcatalog.api.HCatPartitionSpec;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.api.MetadataSerializer;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetadataJSONSerializer
extends MetadataSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataJSONSerializer.class);

    MetadataJSONSerializer() throws HCatException {
    }

    @Override
    public String serializeTable(HCatTable hcatTable) throws HCatException {
        try {
            return new TSerializer((TProtocolFactory)new TJSONProtocol.Factory()).toString((TBase)hcatTable.toHiveTable());
        }
        catch (TException exception) {
            throw new HCatException("Could not serialize HCatTable: " + String.valueOf(hcatTable), (Throwable)exception);
        }
    }

    @Override
    public HCatTable deserializeTable(String hcatTableStringRep) throws HCatException {
        try {
            Table table = new Table();
            new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory()).deserialize((TBase)table, hcatTableStringRep, "UTF-8");
            return new HCatTable(table);
        }
        catch (TException exception) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not de-serialize from: " + hcatTableStringRep);
            }
            throw new HCatException("Could not de-serialize HCatTable.", (Throwable)exception);
        }
    }

    @Override
    public String serializePartition(HCatPartition hcatPartition) throws HCatException {
        try {
            return new TSerializer((TProtocolFactory)new TJSONProtocol.Factory()).toString((TBase)hcatPartition.toHivePartition());
        }
        catch (TException exception) {
            throw new HCatException("Could not serialize HCatPartition: " + String.valueOf(hcatPartition), (Throwable)exception);
        }
    }

    @Override
    public HCatPartition deserializePartition(String hcatPartitionStringRep) throws HCatException {
        try {
            Partition partition = new Partition();
            new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory()).deserialize((TBase)partition, hcatPartitionStringRep, "UTF-8");
            return new HCatPartition(null, partition);
        }
        catch (TException exception) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not de-serialize partition from: " + hcatPartitionStringRep);
            }
            throw new HCatException("Could not de-serialize HCatPartition.", (Throwable)exception);
        }
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Evolving
    public List<String> serializePartitionSpec(HCatPartitionSpec hcatPartitionSpec) throws HCatException {
        try {
            ArrayList<String> stringReps = new ArrayList<String>();
            TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
            for (PartitionSpec partitionSpec : hcatPartitionSpec.partitionSpecProxy.toPartitionSpec()) {
                stringReps.add(serializer.toString((TBase)partitionSpec));
            }
            return stringReps;
        }
        catch (TException serializationException) {
            throw new HCatException("Failed to serialize!", (Throwable)serializationException);
        }
    }

    @Override
    public HCatPartitionSpec deserializePartitionSpec(List<String> hcatPartitionSpecStrings) throws HCatException {
        try {
            ArrayList<PartitionSpec> partitionSpecList = new ArrayList<PartitionSpec>();
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory());
            for (String stringRep : hcatPartitionSpecStrings) {
                PartitionSpec partSpec = new PartitionSpec();
                deserializer.deserialize((TBase)partSpec, stringRep, "UTF-8");
                partitionSpecList.add(partSpec);
            }
            return new HCatPartitionSpec(null, PartitionSpecProxy.Factory.get(partitionSpecList));
        }
        catch (TException deserializationException) {
            throw new HCatException("Failed to deserialize!", (Throwable)deserializationException);
        }
    }
}

