/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import java.util.Map;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hive.hcatalog.common.HCatException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HCatCreateDBDesc {
    private String dbName;
    private String locationUri;
    private String comment;
    private Map<String, String> dbProperties;
    private boolean ifNotExits = false;

    public Map<String, String> getDatabaseProperties() {
        return this.dbProperties;
    }

    public boolean getIfNotExists() {
        return this.ifNotExits;
    }

    public String getComments() {
        return this.comment;
    }

    public String getLocation() {
        return this.locationUri;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    private HCatCreateDBDesc(String dbName) {
        this.dbName = dbName;
    }

    public String toString() {
        return "HCatCreateDBDesc [" + (String)(this.dbName != null ? "dbName=" + this.dbName + ", " : "dbName=null") + (String)(this.locationUri != null ? "location=" + this.locationUri + ", " : "location=null") + (String)(this.comment != null ? "comment=" + this.comment + ", " : "comment=null") + (String)(this.dbProperties != null ? "dbProperties=" + String.valueOf(this.dbProperties) + ", " : "dbProperties=null") + "ifNotExits=" + this.ifNotExits + "]";
    }

    public static Builder create(String dbName) {
        return new Builder(dbName);
    }

    Database toHiveDb() {
        Database hiveDB = new Database();
        hiveDB.setDescription(this.comment);
        hiveDB.setLocationUri(this.locationUri);
        hiveDB.setName(this.dbName);
        hiveDB.setParameters(this.dbProperties);
        return hiveDB;
    }

    public static class Builder {
        private String innerLoc;
        private String innerComment;
        private Map<String, String> innerDBProps;
        private String dbName;
        private boolean ifNotExists = false;

        private Builder(String dbName) {
            this.dbName = dbName;
        }

        public Builder location(String value) {
            this.innerLoc = value;
            return this;
        }

        public Builder comment(String value) {
            this.innerComment = value;
            return this;
        }

        public Builder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        public Builder databaseProperties(Map<String, String> dbProps) {
            this.innerDBProps = dbProps;
            return this;
        }

        public HCatCreateDBDesc build() throws HCatException {
            if (this.dbName == null) {
                throw new HCatException("Database name cannot be null.");
            }
            HCatCreateDBDesc desc = new HCatCreateDBDesc(this.dbName);
            desc.comment = this.innerComment;
            desc.locationUri = this.innerLoc;
            desc.dbProperties = this.innerDBProps;
            desc.ifNotExits = this.ifNotExists;
            return desc;
        }
    }
}

