/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.tool.HiveJobIDParser;
import org.apache.hive.hcatalog.templeton.tool.JarJobIDParser;
import org.apache.hive.hcatalog.templeton.tool.JobIDParser;
import org.apache.hive.hcatalog.templeton.tool.PigJobIDParser;

public class LogRetriever {
    String statusDir;
    LauncherDelegator.JobType jobType;
    private static final String attemptDetailPatternInString = "<a href=\"(taskdetails.jsp\\?.*?)\">";
    private static Pattern attemptDetailPattern = null;
    private static final String attemptLogPatternInString = "Last 8KB</a><br/><a href=\"(.*?tasklog\\?attemptid=.*?)\">All</a>";
    private static Pattern attemptLogPattern = null;
    private static final String attemptIDPatternInString = "attemptid=(.*)?&";
    private static Pattern attemptIDPattern = null;
    private static final String attemptStartTimePatternInString = "<td>(\\d{1,2}-[A-Za-z]{3}-\\d{4} \\d{2}:\\d{2}:\\d{2})(<br/>)?</td>";
    private static Pattern attemptStartTimePattern = null;
    private static final String attemptEndTimePatternInString = "<td>(\\d{1,2}-[A-Za-z]{3}-\\d{4} \\d{2}:\\d{2}:\\d{2}) \\(.*\\)(<br/>)?</td>";
    private static Pattern attemptEndTimePattern = null;
    private FileSystem fs;
    private JobClient jobClient = null;
    private Configuration conf = null;

    public LogRetriever(String statusDir, LauncherDelegator.JobType jobType, Configuration conf) throws IOException {
        this.statusDir = statusDir;
        this.jobType = jobType;
        attemptDetailPattern = Pattern.compile(attemptDetailPatternInString);
        attemptLogPattern = Pattern.compile(attemptLogPatternInString);
        attemptIDPattern = Pattern.compile(attemptIDPatternInString);
        attemptStartTimePattern = Pattern.compile(attemptStartTimePatternInString);
        attemptEndTimePattern = Pattern.compile(attemptEndTimePatternInString);
        Path statusPath = new Path(statusDir);
        this.fs = statusPath.getFileSystem(conf);
        this.jobClient = new JobClient(new JobConf(conf));
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        String logDir = this.statusDir + "/logs";
        this.fs.mkdirs(new Path(logDir));
        JobIDParser jobIDParser = null;
        switch (this.jobType) {
            case PIG: {
                jobIDParser = new PigJobIDParser(this.statusDir, this.conf);
                break;
            }
            case HIVE: {
                jobIDParser = new HiveJobIDParser(this.statusDir, this.conf);
                break;
            }
            case SQOOP: 
            case JAR: 
            case STREAMING: {
                jobIDParser = new JarJobIDParser(this.statusDir, this.conf);
                break;
            }
            default: {
                System.err.println("Unknown job type:" + String.valueOf((Object)this.jobType) != null ? this.jobType.toString() : "null, only pig/hive/jar/streaming/sqoop are supported, skip logs");
                return;
            }
        }
        List<Object> jobs = new ArrayList();
        try {
            jobs = jobIDParser.parseJobID();
        }
        catch (IOException e) {
            System.err.println("Cannot retrieve jobid from log file");
            e.printStackTrace();
        }
        try (PrintWriter listWriter = null;){
            listWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.fs.create(new Path(logDir, "list.txt"))));
            for (String string : jobs) {
                try {
                    this.logJob(logDir, string, listWriter);
                }
                catch (IOException e) {
                    System.err.println("Cannot retrieve log for " + string);
                    e.printStackTrace();
                }
            }
        }
    }

    private void logJob(String logDir, String jobID, PrintWriter listWriter) throws IOException {
        RunningJob rj = this.jobClient.getJob(JobID.forName((String)jobID));
        String jobURLString = rj.getTrackingURL();
        Path jobDir = new Path(logDir, jobID);
        this.fs.mkdirs(jobDir);
        try {
            this.logJobConf(jobID, jobURLString, jobDir.toString());
        }
        catch (IOException e) {
            System.err.println("Cannot retrieve job.xml.html for " + jobID);
            e.printStackTrace();
        }
        listWriter.println("job: " + jobID + "(name=" + rj.getJobName() + ",status=" + JobStatus.getJobRunState((int)rj.getJobState()) + ")");
        ArrayList<AttemptInfo> attempts = new ArrayList<AttemptInfo>();
        for (String type : new String[]{"map", "reduce", "setup", "cleanup"}) {
            try {
                List<AttemptInfo> successAttempts = this.getCompletedAttempts(jobID, jobURLString, type);
                attempts.addAll(successAttempts);
            }
            catch (IOException e) {
                System.err.println("Cannot retrieve " + type + " tasks for " + jobID);
                e.printStackTrace();
            }
        }
        try {
            List<AttemptInfo> failedAttempts = this.getFailedAttempts(jobID, jobURLString);
            attempts.addAll(failedAttempts);
        }
        catch (IOException e) {
            System.err.println("Cannot retrieve failed attempts for " + jobID);
            e.printStackTrace();
        }
        for (AttemptInfo attempt : attempts) {
            try {
                this.logAttempt(jobID, attempt, jobDir.toString());
                listWriter.println("  attempt:" + attempt.id + "(type=" + attempt.type + ",status=" + String.valueOf((Object)attempt.status) + ",starttime=" + attempt.startTime + ",endtime=" + attempt.endTime + ")");
            }
            catch (IOException e) {
                System.err.println("Cannot log attempt " + attempt.id);
                e.printStackTrace();
            }
        }
        listWriter.println();
    }

    private List<String>[] getMatches(URL url, Pattern[] pattern) throws IOException {
        String line;
        ArrayList[] results = new ArrayList[pattern.length];
        for (int i = 0; i < pattern.length; ++i) {
            results[i] = new ArrayList();
        }
        URLConnection urlConnection = url.openConnection();
        BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        while ((line = reader.readLine()) != null) {
            for (int i = 0; i < pattern.length; ++i) {
                Matcher matcher = pattern[i].matcher(line);
                if (!matcher.find()) continue;
                results[i].add(matcher.group(1));
            }
        }
        reader.close();
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logJobConf(String job, String jobURLInString, String jobDir) throws IOException {
        URL jobURL = new URL(jobURLInString);
        String fileInURL = "/jobconf.jsp?jobid=" + job;
        URL jobTasksURL = new URL(jobURL.getProtocol(), jobURL.getHost(), jobURL.getPort(), fileInURL);
        URLConnection urlConnection = jobTasksURL.openConnection();
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.fs.create(new Path(jobDir, "job.xml.html"))));
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private List<AttemptInfo> getCompletedAttempts(String job, String jobURLInString, String type) throws IOException {
        String fileInURL = "/jobtasks.jsp?jobid=" + job + "&type=" + type + "&pagenum=1&state=completed";
        URL jobURL = new URL(jobURLInString);
        URL jobTasksURL = new URL(jobURL.getProtocol(), jobURL.getHost(), jobURL.getPort(), fileInURL);
        List<String>[] taskAttemptURLAndTimestamp = this.getMatches(jobTasksURL, new Pattern[]{attemptDetailPattern, attemptStartTimePattern, attemptEndTimePattern});
        ArrayList<AttemptInfo> results = new ArrayList<AttemptInfo>();
        for (int i = 0; i < taskAttemptURLAndTimestamp[0].size(); ++i) {
            String taskString = taskAttemptURLAndTimestamp[0].get(i);
            URL taskDetailsURL = new URL(jobURL.getProtocol(), jobURL.getHost(), jobURL.getPort(), "/" + taskString);
            List<String>[] attemptLogStrings = this.getMatches(taskDetailsURL, new Pattern[]{attemptLogPattern});
            for (String attemptLogString : attemptLogStrings[0]) {
                AttemptInfo attempt = new AttemptInfo();
                attempt.baseUrl = new URL(attemptLogString);
                attempt.startTime = taskAttemptURLAndTimestamp[1].get(i);
                attempt.endTime = taskAttemptURLAndTimestamp[2].get(i);
                attempt.type = type;
                Matcher matcher = attemptIDPattern.matcher(attemptLogString);
                if (matcher.find()) {
                    attempt.id = matcher.group(1);
                }
                attempt.status = AttemptInfo.AttemptStatus.COMPLETED;
                results.add(attempt);
            }
        }
        return results;
    }

    private List<AttemptInfo> getFailedAttempts(String job, String jobURLInString) throws IOException {
        String fileInURL = "/jobfailures.jsp?jobid=" + job + "&kind=all&cause=failed";
        URL jobURL = new URL(jobURLInString);
        URL url = new URL(jobURL.getProtocol(), jobURL.getHost(), jobURL.getPort(), fileInURL);
        List<String>[] attemptLogStrings = this.getMatches(url, new Pattern[]{attemptDetailPattern});
        ArrayList<String> failedTaskStrings = new ArrayList<String>();
        for (String attempt : attemptLogStrings[0]) {
            if (failedTaskStrings.contains(attempt)) continue;
            failedTaskStrings.add(attempt);
        }
        ArrayList<AttemptInfo> results = new ArrayList<AttemptInfo>();
        for (String taskString : failedTaskStrings) {
            URL taskDetailsURL = new URL(jobURL.getProtocol(), jobURL.getHost(), jobURL.getPort(), "/" + taskString);
            List<String>[] taskAttemptURLAndTimestamp = this.getMatches(taskDetailsURL, new Pattern[]{attemptLogPattern, attemptStartTimePattern, attemptEndTimePattern});
            for (int i = 0; i < taskAttemptURLAndTimestamp[0].size(); ++i) {
                String attemptLogString = taskAttemptURLAndTimestamp[0].get(i);
                AttemptInfo attempt = new AttemptInfo();
                attempt.baseUrl = new URL(attemptLogString);
                attempt.startTime = taskAttemptURLAndTimestamp[1].get(i);
                attempt.endTime = taskAttemptURLAndTimestamp[2].get(i);
                Matcher matcher = attemptIDPattern.matcher(attemptLogString);
                if (matcher.find()) {
                    attempt.id = matcher.group(1);
                }
                if (attempt.id.contains("_r_")) {
                    attempt.type = "reduce";
                }
                attempt.status = AttemptInfo.AttemptStatus.FAILED;
                results.add(attempt);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logAttempt(String job, AttemptInfo attemptInfo, String logDir) throws IOException {
        Path attemptDir = new Path(logDir, attemptInfo.id);
        this.fs.mkdirs(attemptDir);
        for (String type : new String[]{"stderr", "stdout", "syslog"}) {
            String fileInURL = "tasklog?attemptid=" + attemptInfo.id + "&plaintext=true&filter=" + type;
            URL url = new URL(attemptInfo.baseUrl.getProtocol(), attemptInfo.baseUrl.getHost(), attemptInfo.baseUrl.getPort(), "/" + fileInURL);
            URLConnection urlConnection = url.openConnection();
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.fs.create(new Path(attemptDir, type))));
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    static class AttemptInfo {
        public String id;
        public URL baseUrl;
        AttemptStatus status;
        public String startTime;
        public String endTime;
        public String type = "unknown";

        AttemptInfo() {
        }

        public String toString() {
            return this.id + "\t" + this.baseUrl.toString() + "\t" + this.status.toString() + "\t" + this.type + "\t" + this.startTime + "\t" + this.endTime + "\n";
        }

        public static enum AttemptStatus {
            COMPLETED,
            FAILED;

        }
    }
}

