/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueStatusBean;
import org.apache.hive.hcatalog.templeton.StatusDelegator;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDelegator
extends TempletonDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteDelegator.class);

    public DeleteDelegator(AppConfig appConf) {
        super(appConf);
    }

    private String runProgram(String[] cmd) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        HashSet<String> keys = new HashSet<String>(pb.environment().keySet());
        for (String key : keys) {
            pb.environment().remove(key);
        }
        Process p = pb.start();
        String stdout = IOUtils.toString((InputStream)p.getInputStream());
        String stderr = IOUtils.toString((InputStream)p.getErrorStream());
        int code = p.waitFor();
        if (code != 0) {
            throw new IOException("non-zero exit code " + code + " when running " + Arrays.toString(cmd) + "\nstdout: " + stdout + "\nstderr: " + stderr + "\n");
        }
        return stdout;
    }

    private void killHiveQuery(String user, String tag) throws IOException, InterruptedException {
        String[] urls;
        String[] cmd = new String[]{this.appConf.hivePath(), "--getUrlsFromBeelineSite"};
        String urlsString = this.runProgram(cmd);
        for (String url : urls = urlsString.substring(6).split(",")) {
            if (url == null || url.trim().isEmpty()) continue;
            cmd = new String[]{this.appConf.hivePath(), "-u", "jdbc:hive2://" + url, "-n", user, "-e", "kill query '" + tag + "'"};
            this.runProgram(cmd);
        }
    }

    public QueueStatusBean run(String user, String id) throws NotAuthorizedException, BadParam, IOException, InterruptedException {
        UserGroupInformation ugi = null;
        HadoopShims.WebHCatJTShim tracker = null;
        JobState state = null;
        try {
            ugi = UgiFactory.getUgi(user);
            tracker = ShimLoader.getHadoopShims().getWebHCatShim((Configuration)this.appConf, ugi);
            JobID jobid = StatusDelegator.StringToJobID(id);
            if (jobid == null) {
                throw new BadParam("Invalid jobid: " + id);
            }
            tracker.killJob(jobid);
            state = new JobState(id, Main.getAppConfigInstance());
            if (state.getJobType() != null) {
                LauncherDelegator.JobType jobType = LauncherDelegator.JobType.valueOf(state.getJobType());
                if (jobType == LauncherDelegator.JobType.HIVE) {
                    this.killHiveQuery(user, jobid.toString());
                } else {
                    List<JobState> children = state.getChildren();
                    if (children != null) {
                        for (JobState child : children) {
                            try {
                                tracker.killJob(StatusDelegator.StringToJobID(child.getId()));
                            }
                            catch (IOException e) {
                                LOG.warn("templeton: fail to kill job " + child.getId());
                            }
                        }
                    }
                }
            }
            QueueStatusBean queueStatusBean = StatusDelegator.makeStatus(tracker, jobid, state);
            return queueStatusBean;
        }
        catch (IllegalStateException e) {
            throw new BadParam(e.getMessage());
        }
        finally {
            if (tracker != null) {
                tracker.close();
            }
            if (state != null) {
                state.close();
            }
            if (ugi != null) {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
        }
    }
}

