/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.clients.admin;

import java.util.Map;
import java.util.Set;
import org.apache.kafkaesque.clients.admin.KafkaAdminClient;
import org.apache.kafkaesque.clients.admin.MemberToRemove;
import org.apache.kafkaesque.common.KafkaFuture;
import org.apache.kafkaesque.common.internals.KafkaFutureImpl;
import org.apache.kafkaesque.common.message.LeaveGroupRequestData;
import org.apache.kafkaesque.common.protocol.Errors;

public class RemoveMembersFromConsumerGroupResult {
    private final KafkaFuture<Map<LeaveGroupRequestData.MemberIdentity, Errors>> future;
    private final Set<MemberToRemove> memberInfos;

    RemoveMembersFromConsumerGroupResult(KafkaFuture<Map<LeaveGroupRequestData.MemberIdentity, Errors>> future, Set<MemberToRemove> memberInfos) {
        this.future = future;
        this.memberInfos = memberInfos;
    }

    public KafkaFuture<Void> all() {
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((memberErrors, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else {
                for (MemberToRemove memberToRemove : this.memberInfos) {
                    if (!this.maybeCompleteExceptionally((Map<LeaveGroupRequestData.MemberIdentity, Errors>)memberErrors, memberToRemove.toMemberIdentity(), result)) continue;
                    return;
                }
                result.complete(null);
            }
        });
        return result;
    }

    public KafkaFuture<Void> memberResult(MemberToRemove member) {
        if (!this.memberInfos.contains(member)) {
            throw new IllegalArgumentException("Member " + member + " was not included in the original request");
        }
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((memberErrors, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else if (!this.maybeCompleteExceptionally((Map<LeaveGroupRequestData.MemberIdentity, Errors>)memberErrors, member.toMemberIdentity(), result)) {
                result.complete(null);
            }
        });
        return result;
    }

    private boolean maybeCompleteExceptionally(Map<LeaveGroupRequestData.MemberIdentity, Errors> memberErrors, LeaveGroupRequestData.MemberIdentity member, KafkaFutureImpl<Void> result) {
        Throwable exception = KafkaAdminClient.getSubLevelError(memberErrors, member, "Member \"" + member + "\" was not included in the removal response");
        if (exception != null) {
            result.completeExceptionally(exception);
            return true;
        }
        return false;
    }
}

