/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.kafka.KafkaTableProperties;
import org.apache.hadoop.hive.kafka.KafkaUtils;
import org.apache.hadoop.hive.kafka.KafkaWritable;
import org.apache.hadoop.hive.kafka.MetadataColumn;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"columns", "columns.types"})
public class KafkaSerDe
extends AbstractSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSerDe.class);
    private AbstractSerDe delegateSerDe;
    private StructObjectInspector delegateDeserializerOI;
    private StructObjectInspector delegateSerializerOI;
    private ObjectInspector objectInspector;
    private final List<String> columnNames = new ArrayList<String>();
    private BytesConverter bytesConverter;
    private int metadataStartIndex;

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        String className = this.properties.getProperty(KafkaTableProperties.SERDE_CLASS_NAME.getName(), KafkaTableProperties.SERDE_CLASS_NAME.getDefaultValue());
        this.delegateSerDe = KafkaUtils.createDelegate(className);
        this.delegateSerDe.initialize(configuration, tableProperties, partitionProperties);
        if (!(this.delegateSerDe.getObjectInspector() instanceof StructObjectInspector)) {
            throw new SerDeException("Was expecting Struct Object Inspector but have " + this.delegateSerDe.getObjectInspector().getClass().getName());
        }
        this.delegateDeserializerOI = (StructObjectInspector)this.delegateSerDe.getObjectInspector();
        this.columnNames.addAll(this.delegateDeserializerOI.getAllStructFieldRefs().stream().map(StructField::getFieldName).collect(Collectors.toList()));
        this.columnNames.addAll(MetadataColumn.KAFKA_METADATA_COLUMN_NAMES);
        ArrayList<ObjectInspector> inspectors = new ArrayList<ObjectInspector>(this.columnNames.size());
        inspectors.addAll(this.delegateDeserializerOI.getAllStructFieldRefs().stream().map(StructField::getFieldObjectInspector).collect(Collectors.toList()));
        inspectors.addAll(MetadataColumn.KAFKA_METADATA_INSPECTORS);
        this.objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, inspectors);
        this.metadataStartIndex = this.columnNames.size() - MetadataColumn.values().length;
        if (this.delegateSerDe.getSerializedClass() == Text.class) {
            this.bytesConverter = new TextBytesConverter();
        } else if (this.delegateSerDe.getSerializedClass() == AvroGenericRecordWritable.class) {
            String schemaFromProperty = this.properties.getProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), "");
            Preconditions.checkArgument((!schemaFromProperty.isEmpty() ? 1 : 0) != 0, (Object)"Avro Schema is empty Can not go further");
            Schema schema = AvroSerdeUtils.getSchemaFor((String)schemaFromProperty);
            LOG.debug("Building Avro Reader with schema {}", (Object)schemaFromProperty);
            this.bytesConverter = this.getByteConverterForAvroDelegate(schema, this.properties);
        } else {
            this.bytesConverter = new BytesWritableConverter();
        }
    }

    BytesConverter getByteConverterForAvroDelegate(Schema schema, Properties tbl) throws SerDeException {
        String avroBytesConverterPropertyName = AvroSerdeUtils.AvroTableProperties.AVRO_SERDE_TYPE.getPropName();
        String avroBytesConverterProperty = tbl.getProperty(avroBytesConverterPropertyName, BytesConverterType.NONE.toString());
        BytesConverterType avroByteConverterType = BytesConverterType.fromString(avroBytesConverterProperty);
        switch (avroByteConverterType.ordinal()) {
            case 0: {
                String avroSkipBytesPropertyName = AvroSerdeUtils.AvroTableProperties.AVRO_SERDE_SKIP_BYTES.getPropName();
                Integer avroSkipBytes = 0;
                try {
                    avroSkipBytes = Integer.parseInt(tbl.getProperty(avroSkipBytesPropertyName));
                }
                catch (NumberFormatException e) {
                    String message = "Value of " + avroSkipBytesPropertyName + " could not be parsed into an integer properly.";
                    throw new SerDeException(message, (Throwable)e);
                }
                return new AvroSkipBytesConverter(schema, avroSkipBytes);
            }
            case 1: {
                return new AvroBytesConverter(schema);
            }
        }
        throw new SerDeException("Value of " + avroBytesConverterPropertyName + " was invalid.");
    }

    public Class<? extends Writable> getSerializedClass() {
        return this.delegateSerDe.getSerializedClass();
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (!(objInspector instanceof StructObjectInspector)) {
            throw new SerDeException("Object inspector has to be " + StructObjectInspector.class.getName() + " but got " + objInspector.getClass().getName());
        }
        StructObjectInspector structObjectInspector = (StructObjectInspector)objInspector;
        List data = structObjectInspector.getStructFieldsDataAsList(obj);
        int firstMetadataColumnIndex = data.size() - MetadataColumn.values().length;
        if (this.delegateSerializerOI == null) {
            this.delegateSerializerOI = new SubStructObjectInspector(structObjectInspector, firstMetadataColumnIndex);
        }
        List row = data.subList(0, firstMetadataColumnIndex);
        Object key = data.get(firstMetadataColumnIndex);
        Object partition = data.get(firstMetadataColumnIndex + 1);
        Object offset = data.get(firstMetadataColumnIndex + 2);
        Object timestamp = data.get(firstMetadataColumnIndex + 3);
        if (PrimitiveObjectInspectorUtils.getLong(offset, (PrimitiveObjectInspector)MetadataColumn.OFFSET.getObjectInspector()) != -1L) {
            throw new SerDeException("Can not insert values into `__offset` column, has to be [-1]");
        }
        byte[] keyBytes = key == null ? null : PrimitiveObjectInspectorFactory.writableBinaryObjectInspector.getPrimitiveJavaObject(key);
        long recordTs = timestamp == null ? -1L : PrimitiveObjectInspectorUtils.getLong(timestamp, (PrimitiveObjectInspector)MetadataColumn.TIMESTAMP.getObjectInspector());
        int recordPartition = partition == null ? -1 : PrimitiveObjectInspectorUtils.getInt(partition, (PrimitiveObjectInspector)MetadataColumn.PARTITION.getObjectInspector());
        return new KafkaWritable(recordPartition, recordTs, this.bytesConverter.getBytes(this.delegateSerDe.serialize(row, (ObjectInspector)this.delegateSerializerOI)), keyBytes);
    }

    public SerDeStats getSerDeStats() {
        return this.delegateSerDe.getSerDeStats();
    }

    public Object deserialize(Writable blob) throws SerDeException {
        Object[] rowBoat = new Object[this.columnNames.size()];
        this.deserializeKWritable((KafkaWritable)blob, rowBoat);
        return rowBoat;
    }

    void deserializeKWritable(KafkaWritable kafkaWritable, Object[] rowBoat) throws SerDeException {
        int i;
        Object row = this.delegateSerDe.deserialize(this.bytesConverter.getWritable(kafkaWritable.getValue()));
        for (i = 0; i < this.metadataStartIndex; ++i) {
            rowBoat[i] = this.delegateDeserializerOI.getStructFieldData(row, this.delegateDeserializerOI.getStructFieldRef(this.columnNames.get(i)));
        }
        for (i = this.metadataStartIndex; i < this.columnNames.size(); ++i) {
            MetadataColumn metadataColumn = MetadataColumn.forName(this.columnNames.get(i));
            rowBoat[i] = kafkaWritable.getHiveWritable(metadataColumn);
        }
    }

    public ObjectInspector getObjectInspector() {
        return this.objectInspector;
    }

    private static class TextBytesConverter
    implements BytesConverter<Text> {
        private final Text text = new Text();

        private TextBytesConverter() {
        }

        @Override
        public byte[] getBytes(Text writable) {
            try {
                return Text.decode((byte[])writable.getBytes(), (int)0, (int)writable.getLength()).getBytes(Charset.forName("UTF-8"));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Text getWritable(byte[] value) {
            this.text.set(value);
            return this.text;
        }
    }

    private static interface BytesConverter<K extends Writable> {
        public byte[] getBytes(K var1);

        public K getWritable(byte[] var1);
    }

    private static class BytesWritableConverter
    implements BytesConverter<BytesWritable> {
        private BytesWritableConverter() {
        }

        @Override
        public byte[] getBytes(BytesWritable writable) {
            return writable.getBytes();
        }

        @Override
        public BytesWritable getWritable(byte[] value) {
            return new BytesWritable(value);
        }
    }

    static enum BytesConverterType {
        SKIP,
        NONE;


        static BytesConverterType fromString(String value) {
            try {
                return BytesConverterType.valueOf(value.trim().toUpperCase());
            }
            catch (Exception e) {
                return NONE;
            }
        }
    }

    static class AvroSkipBytesConverter
    extends AvroBytesConverter {
        private final int skipBytes;

        AvroSkipBytesConverter(Schema schema, int skipBytes) {
            super(schema);
            this.skipBytes = skipBytes;
        }

        @Override
        Decoder getDecoder(byte[] value) throws SerDeException {
            try {
                return DecoderFactory.get().binaryDecoder(value, this.skipBytes, value.length - this.skipBytes, null);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SerDeException("Skip bytes value is larger than the message length.", (Throwable)e);
            }
        }
    }

    static class AvroBytesConverter
    implements BytesConverter<AvroGenericRecordWritable> {
        private final Schema schema;
        private final DatumReader<GenericRecord> dataReader;
        private final GenericDatumWriter<GenericRecord> gdw = new GenericDatumWriter();
        private final AvroGenericRecordWritable avroGenericRecordWritable = new AvroGenericRecordWritable();
        private final UID uid = new UID();

        AvroBytesConverter(Schema schema) {
            this.schema = schema;
            this.dataReader = new SpecificDatumReader(this.schema);
        }

        @Override
        public byte[] getBytes(AvroGenericRecordWritable writable) {
            GenericRecord record = writable.getRecord();
            byte[] valueBytes = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                BinaryEncoder be = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
                this.gdw.setSchema(record.getSchema());
                this.gdw.write((Object)record, (Encoder)be);
                out.flush();
                valueBytes = out.toByteArray();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)new SerDeException((Throwable)e));
            }
            return valueBytes;
        }

        Decoder getDecoder(byte[] value) throws SerDeException {
            return DecoderFactory.get().binaryDecoder(value, null);
        }

        @Override
        public AvroGenericRecordWritable getWritable(byte[] value) {
            GenericRecord avroRecord = null;
            try {
                avroRecord = (GenericRecord)this.dataReader.read(null, this.getDecoder(value));
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)new SerDeException((Throwable)e));
            }
            catch (SerDeException e) {
                Throwables.propagate((Throwable)e);
            }
            this.avroGenericRecordWritable.setRecord(avroRecord);
            this.avroGenericRecordWritable.setRecordReaderID(this.uid);
            this.avroGenericRecordWritable.setFileSchema(avroRecord.getSchema());
            return this.avroGenericRecordWritable;
        }
    }

    private static final class SubStructObjectInspector
    extends StructObjectInspector {
        private final StructObjectInspector baseOI;
        private final List<? extends StructField> structFields;

        private SubStructObjectInspector(StructObjectInspector baseOI, int toIndex) {
            this.baseOI = baseOI;
            this.structFields = baseOI.getAllStructFieldRefs().subList(0, toIndex);
        }

        public List<? extends StructField> getAllStructFieldRefs() {
            return this.structFields;
        }

        public StructField getStructFieldRef(String fieldName) {
            return this.getAllStructFieldRefs().stream().filter(ref -> ref.getFieldName().equals(fieldName)).findFirst().get();
        }

        public Object getStructFieldData(Object data, StructField fieldRef) {
            return this.baseOI.getStructFieldData(data, fieldRef);
        }

        public List<Object> getStructFieldsDataAsList(Object data) {
            if (data == null) {
                return null;
            }
            int size = this.getAllStructFieldRefs().size();
            ArrayList<Object> res = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                res.add(this.baseOI.getStructFieldData(data, this.getAllStructFieldRefs().get(i)));
            }
            return res;
        }

        public String getTypeName() {
            return this.baseOI.getTypeName();
        }

        public ObjectInspector.Category getCategory() {
            return this.baseOI.getCategory();
        }
    }
}

