/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.kafka.KafkaInputSplit;
import org.apache.hadoop.hive.kafka.MetadataColumn;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.kafkaesque.clients.consumer.KafkaConsumer;
import org.apache.kafkaesque.clients.consumer.OffsetAndTimestamp;
import org.apache.kafkaesque.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaScanTrimmer {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaScanTrimmer.class);
    private final Map<TopicPartition, KafkaInputSplit> fullHouse;
    private final KafkaConsumer kafkaConsumer;

    KafkaScanTrimmer(Map<TopicPartition, KafkaInputSplit> fullHouse, KafkaConsumer kafkaConsumer) {
        this.fullHouse = fullHouse;
        this.kafkaConsumer = kafkaConsumer;
    }

    Map<TopicPartition, KafkaInputSplit> computeOptimizedScan(ExprNodeGenericFuncDesc filterExpression) {
        Map<TopicPartition, KafkaInputSplit> optimizedScan = this.parseAndOptimize((ExprNodeDesc)filterExpression);
        if (LOG.isDebugEnabled()) {
            if (optimizedScan != null) {
                LOG.debug("Optimized scan:");
                optimizedScan.forEach((tp, input) -> LOG.debug("Topic-[{}] Partition-[{}] - Split startOffset [{}] :-> endOffset [{}]", new Object[]{tp.topic(), tp.partition(), input.getStartOffset(), input.getEndOffset()}));
            } else {
                LOG.debug("No optimization thus using full scan ");
                this.fullHouse.forEach((tp, input) -> LOG.debug("Topic-[{}] Partition-[{}] - Split startOffset [{}] :-> endOffset [{}]", new Object[]{tp.topic(), tp.partition(), input.getStartOffset(), input.getEndOffset()}));
            }
        }
        return optimizedScan == null ? this.fullHouse : optimizedScan;
    }

    @Nullable
    private Map<TopicPartition, KafkaInputSplit> parseAndOptimize(ExprNodeDesc expression) {
        if (expression.getClass() != ExprNodeGenericFuncDesc.class) {
            return null;
        }
        ExprNodeGenericFuncDesc expr = (ExprNodeGenericFuncDesc)expression;
        Class<?> op = expr.getGenericUDF().getClass();
        if (FunctionRegistry.isOpOr((ExprNodeDesc)expr)) {
            return this.pushOrOp(expr);
        }
        if (FunctionRegistry.isOpAnd((ExprNodeDesc)expr)) {
            return this.pushAndOp(expr);
        }
        if (op == GenericUDFOPGreaterThan.class) {
            return this.pushLeaf(expr, PredicateLeaf.Operator.LESS_THAN_EQUALS, true);
        }
        if (op == GenericUDFOPEqualOrGreaterThan.class) {
            return this.pushLeaf(expr, PredicateLeaf.Operator.LESS_THAN, true);
        }
        if (op == GenericUDFOPLessThan.class) {
            return this.pushLeaf(expr, PredicateLeaf.Operator.LESS_THAN, false);
        }
        if (op == GenericUDFOPEqualOrLessThan.class) {
            return this.pushLeaf(expr, PredicateLeaf.Operator.LESS_THAN_EQUALS, false);
        }
        if (op == GenericUDFOPEqual.class) {
            return this.pushLeaf(expr, PredicateLeaf.Operator.EQUALS, false);
        }
        return null;
    }

    @Nullable
    private Map<TopicPartition, KafkaInputSplit> pushLeaf(ExprNodeGenericFuncDesc expr, PredicateLeaf.Operator operator, boolean negation) {
        boolean flip;
        ExprNodeConstantDesc constantDesc;
        ExprNodeColumnDesc columnDesc;
        ExprNodeDesc[] extracted;
        if (expr.getChildren().size() != 2) {
            return null;
        }
        GenericUDF genericUDF = expr.getGenericUDF();
        if (!(genericUDF instanceof GenericUDFBaseCompare)) {
            return null;
        }
        ExprNodeDesc expr1 = (ExprNodeDesc)expr.getChildren().get(0);
        ExprNodeDesc expr2 = (ExprNodeDesc)expr.getChildren().get(1);
        if (expr1.getTypeInfo().equals((Object)expr2.getTypeInfo())) {
            expr1 = KafkaScanTrimmer.getColumnExpr(expr1);
            expr2 = KafkaScanTrimmer.getColumnExpr(expr2);
        }
        if ((extracted = ExprNodeDescUtils.extractComparePair((ExprNodeDesc)expr1, (ExprNodeDesc)expr2)) == null || extracted.length > 2) {
            return null;
        }
        if (extracted[0] instanceof ExprNodeColumnDesc) {
            columnDesc = (ExprNodeColumnDesc)extracted[0];
            constantDesc = (ExprNodeConstantDesc)extracted[1];
            flip = false;
        } else {
            flip = true;
            columnDesc = (ExprNodeColumnDesc)extracted[1];
            constantDesc = (ExprNodeConstantDesc)extracted[0];
        }
        if (columnDesc.getColumn().equals(MetadataColumn.PARTITION.getName())) {
            return KafkaScanTrimmer.buildScanFromPartitionPredicate(this.fullHouse, operator, ((Number)constantDesc.getValue()).intValue(), flip, negation);
        }
        if (columnDesc.getColumn().equals(MetadataColumn.OFFSET.getName())) {
            return KafkaScanTrimmer.buildScanFromOffsetPredicate(this.fullHouse, operator, ((Number)constantDesc.getValue()).longValue(), flip, negation);
        }
        if (columnDesc.getColumn().equals(MetadataColumn.TIMESTAMP.getName())) {
            long timestamp = ((Number)constantDesc.getValue()).longValue();
            return KafkaScanTrimmer.buildScanForTimesPredicate(this.fullHouse, operator, timestamp, flip, negation, this.kafkaConsumer);
        }
        return null;
    }

    @VisibleForTesting
    static Map<TopicPartition, KafkaInputSplit> buildScanFromPartitionPredicate(Map<TopicPartition, KafkaInputSplit> fullScan, PredicateLeaf.Operator operator, int partitionConst, boolean flip, boolean negation) {
        Predicate<TopicPartition> predicate = switch (operator) {
            case PredicateLeaf.Operator.EQUALS -> topicPartition -> topicPartition != null && topicPartition.partition() == partitionConst;
            case PredicateLeaf.Operator.LESS_THAN -> {
                Predicate<TopicPartition> intermediatePredicate = flip ? topicPartition -> topicPartition != null && partitionConst < topicPartition.partition() : topicPartition -> topicPartition != null && topicPartition.partition() < partitionConst;
                yield negation ? intermediatePredicate.negate() : intermediatePredicate;
            }
            case PredicateLeaf.Operator.LESS_THAN_EQUALS -> {
                Predicate<TopicPartition> intermediatePredicate = flip ? topicPartition -> topicPartition != null && partitionConst <= topicPartition.partition() : topicPartition -> topicPartition != null && topicPartition.partition() <= partitionConst;
                yield negation ? intermediatePredicate.negate() : intermediatePredicate;
            }
            default -> topicPartition -> true;
        };
        ImmutableMap.Builder builder = ImmutableMap.builder();
        fullScan.entrySet().stream().filter(entry -> predicate.test((TopicPartition)entry.getKey())).forEach(entry -> builder.put((Object)((TopicPartition)entry.getKey()), (Object)KafkaInputSplit.copyOf((KafkaInputSplit)((Object)((Object)entry.getValue())))));
        return builder.build();
    }

    @VisibleForTesting
    static Map<TopicPartition, KafkaInputSplit> buildScanFromOffsetPredicate(Map<TopicPartition, KafkaInputSplit> fullScan, PredicateLeaf.Operator operator, long offsetConst, boolean flip, boolean negation) {
        long endOffset;
        long startOffset;
        boolean isEndBound = flip == negation;
        switch (operator) {
            case LESS_THAN_EQUALS: {
                if (isEndBound) {
                    startOffset = -1L;
                    endOffset = negation ? offsetConst : offsetConst + 1L;
                    break;
                }
                endOffset = -1L;
                startOffset = negation ? offsetConst + 1L : offsetConst;
                break;
            }
            case EQUALS: {
                startOffset = offsetConst;
                endOffset = offsetConst + 1L;
                break;
            }
            case LESS_THAN: {
                if (isEndBound) {
                    endOffset = negation ? offsetConst + 1L : offsetConst;
                    startOffset = -1L;
                    break;
                }
                endOffset = -1L;
                startOffset = negation ? offsetConst : offsetConst + 1L;
                break;
            }
            default: {
                startOffset = -1L;
                endOffset = -1L;
            }
        }
        HashMap<TopicPartition, KafkaInputSplit> newScan = new HashMap<TopicPartition, KafkaInputSplit>();
        fullScan.forEach((tp, existingInputSplit) -> {
            KafkaInputSplit newInputSplit = startOffset != -1L && endOffset == -1L ? new KafkaInputSplit(tp.topic(), tp.partition(), Math.min(startOffset, existingInputSplit.getEndOffset()), existingInputSplit.getEndOffset(), existingInputSplit.getPath()) : (endOffset != -1L && startOffset == -1L ? new KafkaInputSplit(tp.topic(), tp.partition(), existingInputSplit.getStartOffset(), Math.max(endOffset, existingInputSplit.getStartOffset()), existingInputSplit.getPath()) : (endOffset == startOffset + 1L ? (startOffset < existingInputSplit.getStartOffset() || startOffset >= existingInputSplit.getEndOffset() ? new KafkaInputSplit(tp.topic(), tp.partition(), existingInputSplit.getEndOffset(), existingInputSplit.getEndOffset(), existingInputSplit.getPath()) : new KafkaInputSplit(tp.topic(), tp.partition(), startOffset, endOffset, existingInputSplit.getPath())) : new KafkaInputSplit(tp.topic(), tp.partition(), existingInputSplit.getStartOffset(), existingInputSplit.getEndOffset(), existingInputSplit.getPath())));
            newScan.put((TopicPartition)tp, KafkaInputSplit.intersectRange(newInputSplit, existingInputSplit));
        });
        return newScan;
    }

    @Nullable
    private static Map<TopicPartition, KafkaInputSplit> buildScanForTimesPredicate(Map<TopicPartition, KafkaInputSplit> fullHouse, PredicateLeaf.Operator operator, long timestamp, boolean flip, boolean negation, KafkaConsumer<byte[], byte[]> consumer) {
        long increment;
        long l = increment = flip && operator == PredicateLeaf.Operator.LESS_THAN || negation && operator == PredicateLeaf.Operator.LESS_THAN_EQUALS ? 1L : 0L;
        if (operator == PredicateLeaf.Operator.EQUALS || flip ^ negation) {
            ImmutableMap timePartitionsMap = Maps.toMap(fullHouse.keySet(), tp -> timestamp + increment);
            try {
                Map<TopicPartition, OffsetAndTimestamp> offsetAndTimestamp = consumer.offsetsForTimes((Map<TopicPartition, Long>)timePartitionsMap);
                return Maps.toMap(fullHouse.keySet(), tp -> {
                    KafkaInputSplit existing = (KafkaInputSplit)((Object)((Object)fullHouse.get(tp)));
                    OffsetAndTimestamp foundOffsetAndTime = (OffsetAndTimestamp)offsetAndTimestamp.get(tp);
                    long startOffset = foundOffsetAndTime == null ? existing.getEndOffset() : foundOffsetAndTime.offset();
                    return new KafkaInputSplit(Objects.requireNonNull(tp).topic(), tp.partition(), startOffset, existing.getEndOffset(), existing.getPath());
                });
            }
            catch (Exception e) {
                LOG.error("Error while looking up offsets for time", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private Map<TopicPartition, KafkaInputSplit> pushAndOp(ExprNodeGenericFuncDesc expr) {
        HashMap<TopicPartition, KafkaInputSplit> currentScan = new HashMap<TopicPartition, KafkaInputSplit>();
        this.fullHouse.forEach((tp, input) -> currentScan.put((TopicPartition)tp, KafkaInputSplit.copyOf(input)));
        for (ExprNodeDesc child : expr.getChildren()) {
            Map<TopicPartition, KafkaInputSplit> scan = this.parseAndOptimize(child);
            if (scan == null) continue;
            ImmutableSet currentKeys = ImmutableSet.copyOf(currentScan.keySet());
            currentKeys.forEach(key -> {
                KafkaInputSplit intersectionSplit;
                KafkaInputSplit newSplit = (KafkaInputSplit)((Object)((Object)scan.get(key)));
                KafkaInputSplit oldSplit = (KafkaInputSplit)((Object)((Object)currentScan.get(key)));
                currentScan.remove(key);
                if (newSplit != null && (intersectionSplit = KafkaInputSplit.intersectRange(newSplit, oldSplit)) != null) {
                    currentScan.put((TopicPartition)key, intersectionSplit);
                }
            });
        }
        return currentScan;
    }

    @Nullable
    private Map<TopicPartition, KafkaInputSplit> pushOrOp(ExprNodeGenericFuncDesc expr) {
        HashMap<TopicPartition, KafkaInputSplit> currentScan = new HashMap<TopicPartition, KafkaInputSplit>();
        for (ExprNodeDesc child : expr.getChildren()) {
            Map<TopicPartition, KafkaInputSplit> scan = this.parseAndOptimize(child);
            if (scan == null) {
                return null;
            }
            scan.forEach((tp, input) -> {
                KafkaInputSplit existingSplit = (KafkaInputSplit)((Object)((Object)currentScan.get(tp)));
                currentScan.put((TopicPartition)tp, KafkaInputSplit.unionRange(input, existingSplit == null ? input : existingSplit));
            });
        }
        return currentScan;
    }

    private static ExprNodeDesc getColumnExpr(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeColumnDesc) {
            return expr;
        }
        ExprNodeGenericFuncDesc funcDesc = null;
        if (expr instanceof ExprNodeGenericFuncDesc) {
            funcDesc = (ExprNodeGenericFuncDesc)expr;
        }
        if (null == funcDesc) {
            return expr;
        }
        GenericUDF udf = funcDesc.getGenericUDF();
        if ((udf instanceof GenericUDFBridge || udf instanceof GenericUDFToBinary || udf instanceof GenericUDFToChar || udf instanceof GenericUDFToVarchar || udf instanceof GenericUDFToDecimal || udf instanceof GenericUDFToDate || udf instanceof GenericUDFToUnixTimeStamp || udf instanceof GenericUDFToUtcTimestamp) && funcDesc.getChildren().size() == 1 && funcDesc.getChildren().get(0) instanceof ExprNodeColumnDesc) {
            return (ExprNodeDesc)expr.getChildren().get(0);
        }
        return expr;
    }
}

