/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PingResponse;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class PingRequest
extends KuduRpc<PingResponse> {
    private final String serviceName;
    private final List<Integer> requiredFeatures = new ArrayList<Integer>();

    static PingRequest makeMasterPingRequest() {
        return PingRequest.makeMasterPingRequest(null, null, 0L);
    }

    static PingRequest makeMasterPingRequest(KuduTable masterTable, Timer timer, long timeoutMillis) {
        return new PingRequest(masterTable, "kudu.master.MasterService", timer, timeoutMillis);
    }

    static PingRequest makeTabletServerPingRequest() {
        return new PingRequest("kudu.tserver.TabletServerService", null, 0L);
    }

    private PingRequest(String serviceName, Timer timer, long timeoutMillis) {
        this(null, serviceName, timer, timeoutMillis);
    }

    private PingRequest(KuduTable table, String serviceName, Timer timer, long timeoutMillis) {
        super(table, timer, timeoutMillis);
        this.serviceName = serviceName;
    }

    void addRequiredFeature(Integer feature) {
        this.requiredFeatures.add(feature);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return this.requiredFeatures;
    }

    @Override
    Message createRequestPB() {
        return Master.PingRequestPB.getDefaultInstance();
    }

    @Override
    String serviceName() {
        return this.serviceName;
    }

    @Override
    String method() {
        return "Ping";
    }

    @Override
    Pair<PingResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.PingResponsePB.Builder respBuilder = Master.PingResponsePB.newBuilder();
        PingRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        PingResponse response = new PingResponse(this.timeoutTracker.getElapsedMillis(), tsUUID);
        return new Pair<PingResponse, Object>(response, null);
    }
}

