/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kudu.Common;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RangePartition;
import org.apache.kudu.client.RangePartitionBound;
import org.apache.kudu.client.RangePartitionWithCustomHashSchema;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CreateTableOptions {
    private final List<PartialRow> splitRows = Lists.newArrayList();
    private final List<RangePartition> rangePartitions = Lists.newArrayList();
    private final List<RangePartitionWithCustomHashSchema> customRangePartitions = Lists.newArrayList();
    private Master.CreateTableRequestPB.Builder pb = Master.CreateTableRequestPB.newBuilder();
    private boolean wait = true;
    private boolean isPbGenerationDone = false;

    public CreateTableOptions addHashPartitions(List<String> columns, int buckets) {
        this.addHashPartitions(columns, buckets, 0);
        return this;
    }

    public CreateTableOptions addHashPartitions(List<String> columns, int buckets, int seed) {
        Common.PartitionSchemaPB.HashBucketSchemaPB.Builder hashBucket = this.pb.getPartitionSchemaBuilder().addHashSchemaBuilder();
        for (String column : columns) {
            hashBucket.addColumnsBuilder().setName(column);
        }
        hashBucket.setNumBuckets(buckets);
        hashBucket.setSeed(seed);
        return this;
    }

    public CreateTableOptions setRangePartitionColumns(List<String> columns) {
        Common.PartitionSchemaPB.RangeSchemaPB.Builder rangePartition = this.pb.getPartitionSchemaBuilder().getRangeSchemaBuilder();
        for (String column : columns) {
            rangePartition.addColumnsBuilder().setName(column);
        }
        return this;
    }

    public CreateTableOptions addRangePartition(PartialRow lower, PartialRow upper) {
        return this.addRangePartition(lower, upper, RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.EXCLUSIVE_BOUND);
    }

    public CreateTableOptions addRangePartition(PartialRow lower, PartialRow upper, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
        this.rangePartitions.add(new RangePartition(lower, upper, lowerBoundType, upperBoundType));
        return this;
    }

    public CreateTableOptions addRangePartition(RangePartitionWithCustomHashSchema rangePartition) {
        if (!this.splitRows.isEmpty()) {
            throw new IllegalArgumentException("no range partitions with custom hash schema are allowed when using split rows to define range partitioning for a table");
        }
        this.customRangePartitions.add(rangePartition);
        this.pb.getPartitionSchemaBuilder().addCustomHashSchemaRanges(rangePartition.toPB());
        return this;
    }

    public CreateTableOptions addSplitRow(PartialRow row) {
        if (!this.customRangePartitions.isEmpty()) {
            throw new IllegalArgumentException("no split rows are allowed to define range partitioning for a table when range partitions with custom hash schema are present");
        }
        this.splitRows.add(new PartialRow(row));
        return this;
    }

    public CreateTableOptions setNumReplicas(int numReplicas) {
        this.pb.setNumReplicas(numReplicas);
        return this;
    }

    public CreateTableOptions setDimensionLabel(String dimensionLabel) {
        Preconditions.checkArgument(dimensionLabel != null, "dimension label must not be null");
        this.pb.setDimensionLabel(dimensionLabel);
        return this;
    }

    public CreateTableOptions setExtraConfigs(Map<String, String> extraConfig) {
        this.pb.putAllExtraConfigs(extraConfig);
        return this;
    }

    public CreateTableOptions setWait(boolean wait) {
        this.wait = wait;
        return this;
    }

    public CreateTableOptions setOwner(String owner) {
        this.pb.setOwner(owner);
        return this;
    }

    public CreateTableOptions setComment(String comment) {
        this.pb.setComment(comment);
        return this;
    }

    Master.CreateTableRequestPB.Builder getBuilder() {
        if (this.isPbGenerationDone) {
            return this.pb;
        }
        if (!this.splitRows.isEmpty() && !this.customRangePartitions.isEmpty()) {
            throw new IllegalArgumentException("no split rows are allowed to define range partitioning for a table when range partitions with custom hash schema are present");
        }
        if (this.customRangePartitions.isEmpty()) {
            if (!this.splitRows.isEmpty() || !this.rangePartitions.isEmpty()) {
                this.pb.setSplitRowsRangeBounds(new Operation.OperationsEncoder().encodeRangePartitions(this.rangePartitions, this.splitRows));
            }
        } else {
            for (RangePartition p : this.rangePartitions) {
                Common.PartitionSchemaPB.RangeWithHashSchemaPB.Builder b = this.pb.getPartitionSchemaBuilder().addCustomHashSchemaRangesBuilder();
                for (Common.PartitionSchemaPB.HashBucketSchemaPB hashSchema : this.pb.getPartitionSchemaBuilder().getHashSchemaList()) {
                    b.addHashSchema(hashSchema);
                }
                b.setRangeBounds(new Operation.OperationsEncoder().encodeLowerAndUpperBounds(p.lowerBound, p.upperBound, p.lowerBoundType, p.upperBoundType));
            }
        }
        this.isPbGenerationDone = true;
        return this.pb;
    }

    List<Integer> getRequiredFeatureFlags(Schema schema) {
        ArrayList<Integer> requiredFeatureFlags = new ArrayList<Integer>();
        if (schema.hasAutoIncrementingColumn()) {
            requiredFeatureFlags.add(11);
        }
        if (schema.hasImmutableColumns()) {
            requiredFeatureFlags.add(10);
        }
        if (!this.rangePartitions.isEmpty() || !this.customRangePartitions.isEmpty()) {
            requiredFeatureFlags.add(1);
        }
        if (!this.customRangePartitions.isEmpty()) {
            requiredFeatureFlags.add(8);
        }
        return requiredFeatureFlags;
    }

    boolean shouldWait() {
        return this.wait;
    }
}

