/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.packages;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AddPackageRequest;
import org.apache.hadoop.hive.metastore.api.DropPackageRequest;
import org.apache.hadoop.hive.metastore.api.GetPackageRequest;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Package;
import org.apache.hive.hplsql.HplSqlSessionState;
import org.apache.hive.hplsql.packages.PackageRegistry;
import org.apache.thrift.TException;

public class HmsPackageRegistry
implements PackageRegistry {
    private final IMetaStoreClient msc;
    private final HplSqlSessionState hplSqlSession;

    public HmsPackageRegistry(IMetaStoreClient msc, HplSqlSessionState hplSqlSession) {
        this.msc = msc;
        this.hplSqlSession = hplSqlSession;
    }

    @Override
    public Optional<String> getPackage(String name) {
        try {
            Package pkg = this.findPackage(name);
            return pkg == null ? Optional.empty() : Optional.of(pkg.getHeader() + ";\n" + pkg.getBody());
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createPackageHeader(String name, String header, boolean replace) {
        try {
            Package existing = this.findPackage(name);
            if (existing != null && !replace) {
                throw new RuntimeException("Package " + name + " already exists");
            }
            this.msc.addPackage(this.makePackage(name, header, ""));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createPackageBody(String name, String body, boolean replace) {
        try {
            Package existing = this.findPackage(name);
            if (existing == null || StringUtils.isEmpty((CharSequence)existing.getHeader())) {
                throw new RuntimeException("Package header does not exists " + name);
            }
            if (StringUtils.isNotEmpty((CharSequence)existing.getBody()) && !replace) {
                throw new RuntimeException("Package body " + name + " already exists");
            }
            this.msc.addPackage(this.makePackage(name, existing.getHeader(), body));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private Package findPackage(String name) throws TException {
        try {
            return this.msc.findPackage(this.request(name));
        }
        catch (NoSuchObjectException e) {
            return null;
        }
    }

    @Override
    public void dropPackage(String name) {
        try {
            this.msc.dropPackage(new DropPackageRequest(this.hplSqlSession.currentCatalog(), this.hplSqlSession.currentDatabase(), name));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private GetPackageRequest request(String name) {
        return new GetPackageRequest(this.hplSqlSession.currentCatalog(), this.hplSqlSession.currentDatabase(), name.toUpperCase());
    }

    private AddPackageRequest makePackage(String name, String header, String body) {
        return new AddPackageRequest(this.hplSqlSession.currentCatalog(), this.hplSqlSession.currentDatabase(), name.toUpperCase(), this.hplSqlSession.currentUser(), header, body);
    }
}

